/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.tank;

import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.kettle.KettleBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.tank.CopperTankBlockEntity;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockStateProperties;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;

@SerialClass
public class CopperFaucetBlockEntity
extends BaseBlockEntity
implements TickableBlockEntity {
    @SerialClass.SerialField
    protected FluidStack cache = FluidStack.EMPTY;

    public CopperFaucetBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    public boolean activate() {
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        Direction attached = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        BlockEntity src = level.m_7702_(this.m_58899_().m_121945_(attached.m_122424_()));
        BlockEntity dst = level.m_7702_(this.m_58899_().m_7495_());
        if (src == null || dst == null) {
            return false;
        }
        if (src instanceof CopperTankBlockEntity) {
            KettleBlockEntity kettle;
            CopperTankBlockEntity tank = (CopperTankBlockEntity)src;
            if (dst instanceof KettleBlockEntity && !this.activateHeat(tank, kettle = (KettleBlockEntity)dst)) {
                return false;
            }
        }
        LazyOptional fsrc = src.getCapability(ForgeCapabilities.FLUID_HANDLER, attached);
        LazyOptional fdst = dst.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP);
        if (fsrc.resolve().isEmpty() || fdst.resolve().isEmpty()) {
            return false;
        }
        level.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(true)));
        return true;
    }

    private boolean activateHeat(CopperTankBlockEntity tank, KettleBlockEntity kettle) {
        return tank.getHeat() >= 50;
    }

    public void tick() {
        if (this.f_58857_ == null || this.f_58857_.f_46443_) {
            return;
        }
        if (((Boolean)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61446_)).booleanValue() && !this.tryTransfer()) {
            this.cache = FluidStack.EMPTY;
            this.sync();
            this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)BlockStateProperties.f_61446_, (Comparable)Boolean.valueOf(false)));
        }
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    private boolean tryTransfer() {
        FluidStack sdrain;
        Level level = this.m_58904_();
        if (level == null) {
            return false;
        }
        Direction attached = (Direction)this.m_58900_().m_61143_((Property)BlockStateProperties.f_61374_);
        BlockEntity src = level.m_7702_(this.m_58899_().m_121945_(attached.m_122424_()));
        BlockEntity dst = level.m_7702_(this.m_58899_().m_7495_());
        if (src == null || dst == null) {
            return false;
        }
        if (src instanceof CopperTankBlockEntity) {
            KettleBlockEntity kettle;
            CopperTankBlockEntity tank = (CopperTankBlockEntity)src;
            if (dst instanceof KettleBlockEntity && !this.activateHeat(tank, kettle = (KettleBlockEntity)dst)) {
                return false;
            }
        }
        LazyOptional fsrc = src.getCapability(ForgeCapabilities.FLUID_HANDLER, attached);
        LazyOptional fdst = dst.getCapability(ForgeCapabilities.FLUID_HANDLER, Direction.UP);
        if (fsrc.resolve().isEmpty() || fdst.resolve().isEmpty()) {
            return false;
        }
        IFluidHandler hsrc = (IFluidHandler)fsrc.resolve().get();
        IFluidHandler hdst = (IFluidHandler)fdst.resolve().get();
        int fill = hdst.fill(sdrain = hsrc.drain(50, IFluidHandler.FluidAction.SIMULATE), IFluidHandler.FluidAction.SIMULATE);
        if (fill <= 0) {
            return false;
        }
        FluidStack drain = hsrc.drain(fill, IFluidHandler.FluidAction.EXECUTE);
        this.cache = drain.copy();
        this.sync();
        if (src instanceof CopperTankBlockEntity) {
            CopperTankBlockEntity tank = (CopperTankBlockEntity)src;
            if (dst instanceof KettleBlockEntity) {
                KettleBlockEntity kettle = (KettleBlockEntity)dst;
                if (((Boolean)kettle.m_58900_().m_61143_((Property)BlockStateProperties.f_61362_)).booleanValue()) {
                    return false;
                }
                kettle.setWater(0);
                int amount = hdst.fill(drain, IFluidHandler.FluidAction.EXECUTE);
                int consume = tank.consumeHeat(amount);
                if (consume <= 0) return true;
                kettle.cookingTick(consume, true);
                if (kettle.getWater() <= 0) return true;
                kettle.setWater(0);
                return false;
            }
        }
        hdst.fill(drain, IFluidHandler.FluidAction.EXECUTE);
        return true;
    }
}

