/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.table.model;

import dev.xkmc.youkaishomecoming.content.pot.table.model.TableModelProvider;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Supplier;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.TagKey;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.ItemLike;
import net.minecraftforge.common.util.Lazy;
import org.jetbrains.annotations.Nullable;

public class VariantModelPart {
    private final String name;
    private final ResourceLocation path;
    protected final int max;
    private final Map<String, Entry> ingredients = new LinkedHashMap<String, Entry>();

    public VariantModelPart(String name, ResourceLocation path, int max) {
        this.name = name;
        this.path = path;
        this.max = max;
    }

    public ResourceLocation modelAt(String id, int index) {
        return this.path.m_247266_(e -> "cuisine/" + e + "/" + id + "/" + index);
    }

    public void addModels(List<ResourceLocation> list) {
        for (Map.Entry<String, Entry> ent : this.ingredients.entrySet()) {
            String id = ent.getKey();
            for (int i = 0; i < this.max; ++i) {
                list.add(this.modelAt(id, i));
                if (ent.getValue().seared == null) continue;
                list.add(this.modelAt(id + "_seared", i));
            }
        }
    }

    public void build(TableModelProvider pvd) {
        for (int i = 0; i < this.max; ++i) {
            ResourceLocation model = this.path.m_246208_("table/").m_266382_("_" + i);
            for (Map.Entry<String, Entry> ent : this.ingredients.entrySet()) {
                String id = ent.getKey();
                pvd.create(this.modelAt(id, i), model).tex(this.name, ent.getValue().tex);
                if (ent.getValue().seared == null) continue;
                pvd.create(this.modelAt(id + "_seared", i), model).tex(this.name, ent.getValue().tex);
            }
        }
    }

    public synchronized Entry addMapping(String id, Supplier<Ingredient> ing) {
        Entry ans = new Entry(id, (Lazy<Ingredient>)Lazy.of(ing), this.path.m_247266_(e -> "block/table/" + e + "/" + id));
        this.ingredients.put(id, ans);
        return ans;
    }

    public Entry addMapping(String id, ItemLike item) {
        return this.addMapping(id, () -> Ingredient.m_43929_((ItemLike[])new ItemLike[]{item}));
    }

    public Entry addMapping(String id, TagKey<Item> tag) {
        return this.addMapping(id, () -> Ingredient.m_204132_((TagKey)tag));
    }

    @Nullable
    public String find(ItemStack stack) {
        for (Map.Entry<String, Entry> ent : this.ingredients.entrySet()) {
            if (!((Ingredient)ent.getValue().ingredient.get()).test(stack)) continue;
            return ent.getKey();
        }
        return null;
    }

    public static class Entry {
        private final String id;
        private final Lazy<Ingredient> ingredient;
        private ResourceLocation tex;
        private ResourceLocation seared;

        public Entry(String id, Lazy<Ingredient> ingredient, ResourceLocation tex) {
            this.id = id;
            this.ingredient = ingredient;
            this.tex = tex;
        }

        public void tex(ResourceLocation tex) {
            this.tex = tex;
        }

        public void seareable() {
            this.seared = this.tex.m_266382_("_seared");
        }
    }
}

