/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.ferment;

import dev.xkmc.l2library.serial.recipe.BaseRecipe;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationDummyContainer;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.ArrayList;
import java.util.LinkedHashSet;
import net.minecraft.core.RegistryAccess;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.tags.FluidTags;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.fluids.FluidStack;

@SerialClass
public class SimpleFermentationRecipe
extends FermentationRecipe<SimpleFermentationRecipe> {
    @SerialClass.SerialField
    public ArrayList<Ingredient> ingredients = new ArrayList();
    @SerialClass.SerialField
    public ArrayList<ItemStack> results = new ArrayList();
    @SerialClass.SerialField
    public FluidStack outputFluid = FluidStack.EMPTY;
    @SerialClass.SerialField
    public FluidStack inputFluid = FluidStack.EMPTY;
    @SerialClass.SerialField
    public int time;
    @SerialClass.SerialField
    public ItemStack defaultContainer = ItemStack.f_41583_;
    @SerialClass.SerialField
    public ItemStack defaultBottle = ItemStack.f_41583_;

    public SimpleFermentationRecipe(ResourceLocation id) {
        super(id, (BaseRecipe.RecType)YHBlocks.FERMENT_RS.get());
    }

    public boolean matches(FermentationDummyContainer cont, Level level) {
        FluidStack fluid = cont.fluids().getFluidInTank(0);
        if (!this.inputFluid.isEmpty()) {
            if (fluid.getAmount() < this.inputFluid.getAmount()) {
                return false;
            }
            if (this.inputFluid.getFluid() == Fluids.f_76193_ ? !fluid.getFluid().m_205067_(FluidTags.f_13131_) : this.inputFluid.getFluid().getFluidType() != fluid.getFluid().getFluidType()) {
                return false;
            }
        } else if (!fluid.isEmpty()) {
            return false;
        }
        LinkedHashSet<ItemStack> available = new LinkedHashSet<ItemStack>();
        for (ItemStack e : cont.items().getAsList()) {
            if (e.m_41619_()) continue;
            available.add(e);
        }
        for (Ingredient ing : this.ingredients) {
            ItemStack match = null;
            for (ItemStack e : available) {
                if (!ing.test(e)) continue;
                match = e;
                break;
            }
            if (match == null) {
                return false;
            }
            available.remove(match);
        }
        return available.isEmpty();
    }

    public ItemStack assemble(FermentationDummyContainer cont, RegistryAccess access) {
        ArrayList<ItemStack> remain = new ArrayList<ItemStack>();
        for (ItemStack e : cont.items().getAsList()) {
            ItemStack rem = e.getCraftingRemainingItem();
            if (rem.m_41619_()) continue;
            remain.add(rem);
        }
        cont.items().m_6211_();
        for (ItemStack e : this.results) {
            cont.items().m_19173_(e.m_41777_());
        }
        for (ItemStack e : remain) {
            cont.items().m_19173_(e);
        }
        int amount = cont.fluids().getFluidInTank(0).getAmount();
        cont.fluids().clear();
        if (!this.outputFluid.isEmpty()) {
            FluidStack ans = this.outputFluid.copy();
            ans.setAmount(amount);
            cont.fluids().set(0, 0, ans);
        }
        return ItemStack.f_41583_;
    }

    @Override
    public int getFermentationTime() {
        return this.time;
    }
}

