/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.ferment;

import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2library.base.tile.BaseTank;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2modularblock.tile_api.TickableBlockEntity;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.base.FluidItemTile;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationDummyContainer;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationItemContainer;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationRecipe;
import dev.xkmc.youkaishomecoming.content.pot.ferment.FermentationTankBlock;
import dev.xkmc.youkaishomecoming.content.pot.overlay.InfoTile;
import dev.xkmc.youkaishomecoming.content.pot.overlay.TileTooltip;
import dev.xkmc.youkaishomecoming.init.data.YHLangData;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.Mth;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class FermentationTankBlockEntity
extends BaseBlockEntity
implements BlockContainer,
BaseContainerListener,
TickableBlockEntity,
InfoTile,
FluidItemTile {
    @SerialClass.SerialField
    public final FermentationItemContainer items = (FermentationItemContainer)((FermentationItemContainer)new FermentationItemContainer().setMax(1)).add(this);
    @SerialClass.SerialField
    public final BaseTank fluids = new BaseTank(1, 1000).add((BaseContainerListener)this);
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.items));
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluids);
    @SerialClass.SerialField
    private int totalTime = 0;
    @SerialClass.SerialField
    private int fermentationProgress = 0;
    @SerialClass.SerialField
    private ResourceLocation recipeId = null;
    private boolean doRecipeSearch = true;
    private FermentationRecipe<?> recipe = null;

    public FermentationTankBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public BaseTank getFluidHandler() {
        return this.fluids;
    }

    @Override
    public SimpleContainer getItemHandler() {
        return this.items;
    }

    public void tick() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            if (this.totalTime > 0) {
                if (((Boolean)this.m_58900_().m_61143_((Property)FermentationTankBlock.OPEN)).booleanValue()) {
                    if (this.fermentationProgress > 0) {
                        --this.fermentationProgress;
                    }
                } else {
                    ++this.fermentationProgress;
                }
            }
            return;
        }
        if (this.doRecipeSearch) {
            if (!this.items.m_7983_() || !this.fluids.isEmpty()) {
                FermentationDummyContainer cont = new FermentationDummyContainer(this.items, this.fluids);
                Optional opt = this.f_58857_.m_7465_().m_44015_((RecipeType)YHBlocks.FERMENT_RT.get(), (Container)cont, this.f_58857_);
                if (opt.isPresent()) {
                    this.recipe = (FermentationRecipe)((Object)opt.get());
                    this.totalTime = this.recipe.getFermentationTime();
                    if (!this.recipe.id.equals((Object)this.recipeId)) {
                        this.fermentationProgress = 0;
                        this.recipeId = this.recipe.id;
                    } else if (this.fermentationProgress > this.totalTime) {
                        this.fermentationProgress = this.totalTime - 1;
                    }
                } else {
                    this.recipeId = null;
                    this.recipe = null;
                    this.totalTime = 0;
                    this.fermentationProgress = 0;
                }
                this.sync();
            }
            this.doRecipeSearch = false;
        }
        if (this.totalTime > 0) {
            if (((Boolean)this.m_58900_().m_61143_((Property)FermentationTankBlock.OPEN)).booleanValue()) {
                if (this.fermentationProgress > 0) {
                    --this.fermentationProgress;
                }
            } else {
                ++this.fermentationProgress;
            }
            if (this.fermentationProgress >= this.totalTime) {
                if (this.recipe != null) {
                    this.recipe.m_5874_((Container)new FermentationDummyContainer(this.items, this.fluids), this.f_58857_.m_9598_());
                    this.f_58857_.m_46597_(this.m_58899_(), (BlockState)this.m_58900_().m_61124_((Property)FermentationTankBlock.OPEN, (Comparable)Boolean.valueOf(true)));
                    this.notifyTile();
                }
                this.fermentationProgress = 0;
                this.totalTime = 0;
                this.recipeId = null;
                this.recipe = null;
            }
        }
    }

    public List<Container> getContainers() {
        return List.of(this.items);
    }

    public void dumpInventory() {
        if (this.f_58857_ == null) {
            return;
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_().m_7494_(), (Container)this.items);
        this.notifyTile();
    }

    @Override
    public void notifyTile() {
        this.m_6596_();
        this.sync();
        this.doRecipeSearch = true;
    }

    @Override
    public TileTooltip getImage(boolean shift, BlockHitResult hit) {
        return new TileTooltip(this.items.getAsList(), this.fluids.getAsList(), 3, 3);
    }

    public float inProgress() {
        return this.totalTime == 0 ? 0.0f : Mth.m_14036_((float)(1.0f * (float)this.fermentationProgress / (float)this.totalTime), (float)0.0f, (float)1.0f);
    }

    @Override
    public List<Component> lines(boolean shift, BlockHitResult hit) {
        float progress = this.inProgress();
        if (this.totalTime <= 0) {
            return List.of();
        }
        return List.of(YHLangData.FERMENT_PROGRESS.get(Math.round(progress * 100.0f) + "%"));
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

