/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.basin;

import dev.xkmc.l2library.base.tile.BaseBlockEntity;
import dev.xkmc.l2library.base.tile.BaseContainerListener;
import dev.xkmc.l2library.base.tile.BaseTank;
import dev.xkmc.l2modularblock.tile_api.BlockContainer;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.content.pot.base.FluidItemTile;
import dev.xkmc.youkaishomecoming.content.pot.basin.BasinInput;
import dev.xkmc.youkaishomecoming.content.pot.basin.BasinItemContainer;
import dev.xkmc.youkaishomecoming.content.pot.basin.BasinRecipe;
import dev.xkmc.youkaishomecoming.init.registrate.YHBlocks;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.core.particles.ItemParticleOption;
import net.minecraft.core.particles.ParticleOptions;
import net.minecraft.core.particles.ParticleTypes;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.Container;
import net.minecraft.world.Containers;
import net.minecraft.world.SimpleContainer;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.RecipeType;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntityType;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.util.LazyOptional;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.wrapper.InvWrapper;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class BasinBlockEntity
extends BaseBlockEntity
implements BlockContainer,
BaseContainerListener,
FluidItemTile {
    @SerialClass.SerialField
    public final BasinItemContainer items = (BasinItemContainer)new BasinItemContainer().add(this);
    @SerialClass.SerialField
    public final BaseTank fluids = new BaseTank(1, 500).add((BaseContainerListener)this);
    private final LazyOptional<IItemHandler> itemHandler = LazyOptional.of(() -> new InvWrapper((Container)this.items));
    private final LazyOptional<IFluidHandler> fluidHandler = LazyOptional.of(() -> this.fluids);

    public BasinBlockEntity(BlockEntityType<?> type, BlockPos pos, BlockState state) {
        super(type, pos, state);
    }

    @Override
    public BaseTank getFluidHandler() {
        return this.fluids;
    }

    @Override
    public SimpleContainer getItemHandler() {
        return this.items;
    }

    public void process() {
        if (this.f_58857_ == null) {
            return;
        }
        if (this.f_58857_.m_5776_()) {
            return;
        }
        BasinInput cont = new BasinInput(this);
        Optional rec = this.f_58857_.m_7465_().m_44015_((RecipeType)YHBlocks.BASIN_RT.get(), (Container)cont, this.f_58857_);
        if (rec.isEmpty()) {
            return;
        }
        FluidStack ans = ((BasinRecipe)((Object)rec.get())).assembleFluid(cont, this.f_58857_.m_9598_());
        FluidStack old = this.fluids.getFluidInTank(0);
        if (!old.isEmpty()) {
            if (!ans.isFluidEqual(old)) {
                return;
            }
            if (old.getAmount() + ans.getAmount() > this.fluids.getTankCapacity(0)) {
                return;
            }
        }
        ItemStack in = this.items.m_8020_(0);
        ItemStack copy = in.m_41777_();
        in.m_41774_(1);
        this.fluids.fill(ans, IFluidHandler.FluidAction.EXECUTE);
        this.notifyTile();
        Level level = this.f_58857_;
        if (level instanceof ServerLevel) {
            ServerLevel sl = (ServerLevel)level;
            int h = this.fluids.getFluidInTank(0).getAmount() / 1000;
            Vec3 pos = this.m_58899_().m_252807_();
            sl.m_8767_((ParticleOptions)new ItemParticleOption(ParticleTypes.f_123752_, copy), pos.f_82479_ + (double)(this.f_58857_.f_46441_.m_188501_() * 0.2f) - (double)0.1f, pos.f_82480_ + (double)Math.max(0.25f, (float)h), pos.f_82481_ + (double)(this.f_58857_.f_46441_.m_188501_() * 0.2f) - (double)0.1f, 10, 0.0, 0.0, 0.0, 0.05);
            sl.m_5594_(null, this.m_58899_(), SoundEvents.f_12388_, SoundSource.BLOCKS, 0.7f, 2.0f);
        }
    }

    public List<Container> getContainers() {
        return List.of(this.items);
    }

    public void dumpInventory() {
        if (this.f_58857_ == null) {
            return;
        }
        Containers.m_19002_((Level)this.f_58857_, (BlockPos)this.m_58899_().m_7494_(), (Container)this.items);
        this.notifyTile();
    }

    @Override
    public void notifyTile() {
        this.m_6596_();
        this.sync();
    }

    @NotNull
    public <T> LazyOptional<T> getCapability(@NotNull Capability<T> cap, @Nullable Direction side) {
        if (cap == ForgeCapabilities.ITEM_HANDLER) {
            return this.itemHandler.cast();
        }
        if (cap == ForgeCapabilities.FLUID_HANDLER) {
            return this.fluidHandler.cast();
        }
        return super.getCapability(cap, side);
    }
}

