/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.pot.base;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotBlockEntity;
import dev.xkmc.youkaishomecoming.content.pot.base.BasePotResultSlot;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.Container;
import net.minecraft.world.entity.player.Inventory;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.entity.player.StackedContents;
import net.minecraft.world.inventory.ContainerData;
import net.minecraft.world.inventory.ContainerLevelAccess;
import net.minecraft.world.inventory.InventoryMenu;
import net.minecraft.world.inventory.MenuType;
import net.minecraft.world.inventory.RecipeBookMenu;
import net.minecraft.world.inventory.RecipeBookType;
import net.minecraft.world.inventory.SimpleContainerData;
import net.minecraft.world.inventory.Slot;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.items.IItemHandler;
import net.minecraftforge.items.IItemHandlerModifiable;
import net.minecraftforge.items.ItemStackHandler;
import net.minecraftforge.items.SlotItemHandler;
import net.minecraftforge.items.wrapper.RecipeWrapper;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.block.entity.container.CookingPotMealSlot;
import vectorwing.farmersdelight.common.tag.ModTags;

public abstract class BasePotMenu
extends RecipeBookMenu<RecipeWrapper> {
    public static final ResourceLocation EMPTY_CONTAINER_SLOT = YoukaisHomecoming.loc("item/empty_container_slot_bottle");
    public final BasePotBlockEntity blockEntity;
    public final ItemStackHandler inventory;
    protected final ContainerData cookingPotData;
    private final ContainerLevelAccess canInteractWithCallable;
    protected final Level level;

    public BasePotMenu(MenuType<? extends BasePotMenu> menu, int id, Inventory inv, @Nullable FriendlyByteBuf data) {
        this(menu, id, inv, BasePotMenu.getTileEntity(inv, data), (ContainerData)new SimpleContainerData(4));
    }

    public BasePotMenu(MenuType<? extends BasePotMenu> menu, int id, Inventory inv, BasePotBlockEntity be, ContainerData data) {
        super(menu, id);
        int column;
        int startPlayerInvY;
        this.blockEntity = be;
        this.inventory = be.getInventory();
        this.cookingPotData = data;
        this.level = inv.f_35978_.m_9236_();
        this.canInteractWithCallable = ContainerLevelAccess.m_39289_((Level)be.m_58904_(), (BlockPos)be.m_58899_());
        int startX = 8;
        int startY = 18;
        int inputStartX = 35;
        int inputStartY = 18;
        int borderSlotSize = 18;
        for (startPlayerInvY = 0; startPlayerInvY < 2; ++startPlayerInvY) {
            for (column = 0; column < 2; ++column) {
                this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, startPlayerInvY * 2 + column, inputStartX + column * borderSlotSize, inputStartY + startPlayerInvY * borderSlotSize));
            }
        }
        this.m_38897_((Slot)new CookingPotMealSlot((IItemHandler)this.inventory, 4, 121, 27));
        this.m_38897_((Slot)new SlotItemHandler((IItemHandler)this.inventory, 5, 89, 54){

            public Pair<ResourceLocation, ResourceLocation> m_7543_() {
                return Pair.of((Object)InventoryMenu.f_39692_, (Object)EMPTY_CONTAINER_SLOT);
            }
        });
        this.m_38897_((Slot)new BasePotResultSlot(inv.f_35978_, be, (IItemHandler)this.inventory, 6, 121, 54));
        startPlayerInvY = startY * 4 + 12;
        for (int row = 0; row < 3; ++row) {
            for (int column2 = 0; column2 < 9; ++column2) {
                this.m_38897_(new Slot((Container)inv, 9 + row * 9 + column2, startX + column2 * borderSlotSize, startPlayerInvY + row * borderSlotSize));
            }
        }
        for (column = 0; column < 9; ++column) {
            this.m_38897_(new Slot((Container)inv, column, startX + column * borderSlotSize, 142));
        }
        this.m_38884_(data);
    }

    private static BasePotBlockEntity getTileEntity(Inventory playerInventory, @Nullable FriendlyByteBuf data) {
        Objects.requireNonNull(playerInventory, "playerInventory cannot be null");
        Objects.requireNonNull(data, "data cannot be null");
        BlockEntity tileAtPos = playerInventory.f_35978_.m_9236_().m_7702_(data.m_130135_());
        if (tileAtPos instanceof BasePotBlockEntity) {
            BasePotBlockEntity pot = (BasePotBlockEntity)tileAtPos;
            return pot;
        }
        throw new IllegalStateException("Tile entity is not correct! " + tileAtPos);
    }

    public abstract Block getBlock();

    public boolean m_6875_(Player playerIn) {
        return BasePotMenu.m_38889_((ContainerLevelAccess)this.canInteractWithCallable, (Player)playerIn, (Block)this.getBlock());
    }

    public ItemStack m_7648_(Player playerIn, int index) {
        int indexMealDisplay = 4;
        int indexContainerInput = 5;
        int indexOutput = 6;
        int startPlayerInv = indexOutput + 1;
        int endPlayerInv = startPlayerInv + 36;
        ItemStack slotStackCopy = ItemStack.f_41583_;
        Slot slot = (Slot)this.f_38839_.get(index);
        if (slot.m_6657_()) {
            ItemStack slotStack = slot.m_7993_();
            slotStackCopy = slotStack.m_41777_();
            if (index == indexOutput) {
                if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, true)) {
                    return ItemStack.f_41583_;
                }
            } else if (index <= indexOutput) {
                if (!this.m_38903_(slotStack, startPlayerInv, endPlayerInv, false)) {
                    return ItemStack.f_41583_;
                }
            } else {
                boolean isValidContainer;
                boolean bl = isValidContainer = slotStack.m_204117_(ModTags.SERVING_CONTAINERS) || slotStack.m_150930_(this.blockEntity.getContainer().m_41720_());
                if (isValidContainer && !this.m_38903_(slotStack, indexContainerInput, indexContainerInput + 1, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, 0, indexMealDisplay, false)) {
                    return ItemStack.f_41583_;
                }
                if (!this.m_38903_(slotStack, indexContainerInput, indexOutput, false)) {
                    return ItemStack.f_41583_;
                }
            }
            if (slotStack.m_41619_()) {
                slot.m_5852_(ItemStack.f_41583_);
            } else {
                slot.m_6654_();
            }
            if (slotStack.m_41613_() == slotStackCopy.m_41613_()) {
                return ItemStack.f_41583_;
            }
            slot.m_142406_(playerIn, slotStack);
        }
        return slotStackCopy;
    }

    public double getCookProgressionScaled() {
        int i = this.cookingPotData.m_6413_(0);
        int j = this.cookingPotData.m_6413_(1);
        return j != 0 && i != 0 ? (double)i * 1.0 / (double)j : 0.0;
    }

    public boolean isHeated() {
        return this.blockEntity.isHeated();
    }

    public void m_5816_(StackedContents helper) {
        for (int i = 0; i < this.inventory.getSlots(); ++i) {
            helper.m_36466_(this.inventory.getStackInSlot(i));
        }
    }

    public void m_6650_() {
        for (int i = 0; i < 4; ++i) {
            this.inventory.setStackInSlot(i, ItemStack.f_41583_);
        }
    }

    public boolean m_6032_(Recipe<? super RecipeWrapper> recipe) {
        return recipe.m_5818_((Container)new RecipeWrapper((IItemHandlerModifiable)this.inventory), this.level);
    }

    public int m_6636_() {
        return 5;
    }

    public int m_6635_() {
        return 2;
    }

    public int m_6656_() {
        return 2;
    }

    public int m_6653_() {
        return 5;
    }

    public abstract RecipeBookType m_5867_();

    public boolean m_142157_(int slot) {
        return slot < this.m_6635_() * this.m_6656_();
    }
}

