/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.item.fluid;

import com.mojang.datafixers.util.Pair;
import dev.xkmc.l2library.base.effects.EffectBuilder;
import dev.xkmc.youkaishomecoming.content.item.fluid.FluidColorHelper;
import dev.xkmc.youkaishomecoming.content.item.fluid.SlipFluidWrapper;
import dev.xkmc.youkaishomecoming.content.item.fluid.YHFluid;
import dev.xkmc.youkaishomecoming.content.item.food.YHDrinkItem;
import dev.xkmc.youkaishomecoming.init.food.YHDrink;
import dev.xkmc.youkaishomecoming.init.registrate.YHEffects;
import java.util.List;
import java.util.Optional;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResultHolder;
import net.minecraft.world.effect.MobEffectInstance;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.food.FoodProperties;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.TooltipFlag;
import net.minecraft.world.level.Level;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.common.capabilities.ICapabilityProvider;
import net.minecraftforge.fluids.FluidStack;
import net.minecraftforge.fluids.capability.IFluidHandler;
import net.minecraftforge.fluids.capability.IFluidHandlerItem;
import org.jetbrains.annotations.Nullable;

public class SlipBottleItem
extends YHDrinkItem {
    private final FoodProperties NONE = new FoodProperties.Builder().m_38767_();

    public SlipBottleItem(Item.Properties builder) {
        super(builder);
    }

    public boolean m_41472_() {
        return true;
    }

    @Override
    public InteractionResultHolder<ItemStack> m_7203_(Level level, Player player, InteractionHand hand) {
        ItemStack stack = player.m_21120_(hand);
        FoodProperties food = this.getFoodProperties(stack, (LivingEntity)player);
        if (food == null || food == this.NONE || food.m_38749_().isEmpty()) {
            return InteractionResultHolder.m_19098_((Object)stack);
        }
        return super.m_7203_(level, player, hand);
    }

    @Nullable
    public FoodProperties getFoodProperties(ItemStack stack, @Nullable LivingEntity entity) {
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty()) {
            return this.NONE;
        }
        FluidStack fluid = ((IFluidHandlerItem)handler.get()).getFluidInTank(0);
        if (fluid.isEmpty()) {
            return this.NONE;
        }
        Object object = fluid.getFluid();
        if (object instanceof YHFluid) {
            YHFluid sake = (YHFluid)((Object)object);
            object = sake.type;
            if (object instanceof YHDrink) {
                YHDrink type = (YHDrink)object;
                FoodProperties food = type.item.asStack().getFoodProperties(entity);
                if (food == null) {
                    return this.NONE;
                }
                FoodProperties.Builder builder = new FoodProperties.Builder();
                if (food.m_38747_()) {
                    builder.m_38765_();
                }
                for (Pair e : food.m_38749_()) {
                    MobEffectInstance ins = (MobEffectInstance)e.getFirst();
                    EffectBuilder ans = new EffectBuilder(ins);
                    if (ins.m_19544_() == YHEffects.DRUNK.get()) {
                        int amp = ins.m_19564_() + 1;
                        ans.setDuration(amp * ins.m_19557_() / 5);
                        ans.setAmplifier(0);
                    } else {
                        ans.setDuration(ins.m_19557_() / 5);
                    }
                    builder.effect(() -> ans.ins, ((Float)e.getSecond()).floatValue());
                }
                return builder.m_38767_();
            }
        }
        return this.NONE;
    }

    @Override
    public ItemStack m_5922_(ItemStack stack, Level level, LivingEntity user) {
        Object t;
        Optional handler = stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve();
        if (handler.isEmpty() || !((t = handler.get()) instanceof SlipFluidWrapper)) {
            return stack;
        }
        SlipFluidWrapper slip = (SlipFluidWrapper)t;
        FluidStack fluid = slip.getFluid();
        super.m_5922_(stack, level, user);
        slip.getContainer().m_41764_(1);
        slip.setFluid(fluid);
        slip.drain(50, IFluidHandler.FluidAction.EXECUTE);
        return slip.getContainer();
    }

    public int m_8105_(ItemStack stack) {
        return 10;
    }

    public ICapabilityProvider initCapabilities(ItemStack stack, @Nullable CompoundTag nbt) {
        if (this instanceof SlipBottleItem) {
            return new SlipFluidWrapper(stack);
        }
        return super.initCapabilities(stack, nbt);
    }

    public static FluidStack getFluid(ItemStack stack) {
        return stack.getCapability(ForgeCapabilities.FLUID_HANDLER_ITEM).resolve().map(h -> h.getFluidInTank(0)).orElse(FluidStack.EMPTY);
    }

    @Override
    public void m_7373_(ItemStack stack, @Nullable Level level, List<Component> list, TooltipFlag flag) {
        Object object;
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (!fluid.isEmpty() && (object = fluid.getFluid()) instanceof YHFluid) {
            YHFluid sake = (YHFluid)((Object)object);
            object = sake.type;
            if (object instanceof YHDrink) {
                YHDrink type = (YHDrink)object;
                list.add(((Item)type.item.get()).m_41466_());
            }
        }
        super.m_7373_(stack, level, list, flag);
    }

    public static int color(ItemStack stack, int layer) {
        if (layer != 1) {
            return -1;
        }
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (fluid.isEmpty()) {
            return -1;
        }
        return FluidColorHelper.getColor(fluid);
    }

    public static float texture(ItemStack stack) {
        FluidStack fluid = SlipBottleItem.getFluid(stack);
        if (fluid.isEmpty()) {
            return 0.0f;
        }
        return 1.0f;
    }

    public boolean m_142522_(ItemStack stack) {
        return !SlipBottleItem.getFluid(stack).isEmpty();
    }

    public int m_142158_(ItemStack stack) {
        return 13 * SlipBottleItem.getFluid(stack).getAmount() / 1000;
    }

    public int m_142159_(ItemStack stack) {
        return -1;
    }
}

