/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.youkai;

import dev.xkmc.fastprojectileapi.collision.EntityStorageHelper;
import dev.xkmc.fastprojectileapi.collision.UserCacheHolder;
import dev.xkmc.fastprojectileapi.entity.EntityCachingUser;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.virtual.DanmakuManager;
import dev.xkmc.fastprojectileapi.spellcircle.SpellCircleHolder;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.l2serial.serialization.codec.TagCodec;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.compat.touhoulittlemaid.TouhouConditionalSpawns;
import dev.xkmc.youkaishomecoming.content.capability.GrazeCapability;
import dev.xkmc.youkaishomecoming.content.capability.GrazeHelper;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.ItemDanmakuEntity;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RestrictData;
import dev.xkmc.youkaishomecoming.content.entity.youkai.CombatProgress;
import dev.xkmc.youkaishomecoming.content.entity.youkai.SyncedData;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiTargetContainer;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.LivingCardHolder;
import dev.xkmc.youkaishomecoming.content.spell.spellcard.SpellCardWrapper;
import dev.xkmc.youkaishomecoming.events.EffectEventHandlers;
import dev.xkmc.youkaishomecoming.events.YoukaiFightEvent;
import dev.xkmc.youkaishomecoming.init.data.YHDamageTypes;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import dev.xkmc.youkaishomecoming.init.data.YHTagGen;
import dev.xkmc.youkaishomecoming.init.registrate.YHDanmaku;
import dev.xkmc.youkaishomecoming.init.registrate.YHEntities;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.LinkedList;
import java.util.Objects;
import net.minecraft.core.BlockPos;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.syncher.EntityDataAccessor;
import net.minecraft.network.syncher.EntityDataSerializer;
import net.minecraft.network.syncher.SynchedEntityData;
import net.minecraft.server.level.ServerPlayer;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundEvents;
import net.minecraft.stats.Stats;
import net.minecraft.tags.DamageTypeTags;
import net.minecraft.world.damagesource.DamageSource;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.EntityType;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.Mob;
import net.minecraft.world.entity.PathfinderMob;
import net.minecraft.world.entity.ai.attributes.AttributeSupplier;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.entity.ai.control.FlyingMoveControl;
import net.minecraft.world.entity.ai.control.MoveControl;
import net.minecraft.world.entity.ai.navigation.FlyingPathNavigation;
import net.minecraft.world.entity.ai.navigation.PathNavigation;
import net.minecraft.world.entity.monster.Monster;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.gameevent.GameEvent;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.common.MinecraftForge;
import net.minecraftforge.eventbus.api.Event;
import org.jetbrains.annotations.Nullable;

@SerialClass
public abstract class YoukaiEntity
extends PathfinderMob
implements SpellCircleHolder,
LivingCardHolder,
EntityCachingUser {
    private static final int GROUND_HEIGHT = 5;
    private static final int ATTEMPT_ABOVE = 3;
    protected static final SyncedData YOUKAI_DATA = new SyncedData(YoukaiEntity::defineId);
    protected static final EntityDataAccessor<Integer> DATA_FLAGS_ID = YOUKAI_DATA.define(SyncedData.INT, 0, "youkai_flags");
    public final MoveControl walkCtrl;
    public final MoveControl flyCtrl;
    public final PathNavigation walkNav;
    public final PathNavigation fltNav;
    @SerialClass.SerialField
    public final YoukaiTargetContainer targets;
    @SerialClass.SerialField
    public SpellCardWrapper spellCard;
    @SerialClass.SerialField
    public CombatProgress combatProgress = new CombatProgress();
    private final LinkedList<SimplifiedProjectile> allDanmakus = new LinkedList();
    private ArrayList<SimplifiedProjectile> temp;
    private final ArrayList<SimplifiedProjectile> toBeSent = new ArrayList();
    private boolean removeDanmaku = false;
    private final UserCacheHolder cache = new UserCacheHolder();

    private static <T> EntityDataAccessor<T> defineId(EntityDataSerializer<T> ser) {
        return SynchedEntityData.m_135353_(YoukaiEntity.class, ser);
    }

    public static AttributeSupplier.Builder createAttributes() {
        return Monster.m_33035_().m_22268_(Attributes.f_22279_, 0.3).m_22268_(Attributes.f_22280_, 0.4).m_22268_(Attributes.f_22277_, 48.0);
    }

    public YoukaiEntity(EntityType<? extends YoukaiEntity> pEntityType, Level pLevel) {
        this(pEntityType, pLevel, 10);
    }

    public YoukaiEntity(EntityType<? extends YoukaiEntity> pEntityType, Level pLevel, int maxSize) {
        super(pEntityType, pLevel);
        this.walkCtrl = this.f_21342_;
        this.walkNav = this.f_21344_;
        this.flyCtrl = new FlyingMoveControl((Mob)this, 10, false);
        this.fltNav = new FlyingPathNavigation((Mob)this, this.m_9236_());
        this.targets = new YoukaiTargetContainer(this, maxSize);
        this.combatProgress.init(this);
    }

    protected SoundEvent m_7515_() {
        return SoundEvents.f_271165_;
    }

    protected SoundEvent m_7975_(DamageSource pDamageSource) {
        return SoundEvents.f_271165_;
    }

    protected SoundEvent m_5592_() {
        return SoundEvents.f_271165_;
    }

    public boolean m_6573_(Player pPlayer) {
        return false;
    }

    protected SyncedData data() {
        return YOUKAI_DATA;
    }

    protected void m_8097_() {
        super.m_8097_();
        this.data().register(this.f_19804_);
    }

    public void m_7380_(CompoundTag tag) {
        Tag data;
        super.m_7380_(tag);
        tag.m_128350_("Health", this.getCombatProgress());
        tag.m_128405_("Age", this.f_19797_);
        tag.m_128365_("auto-serial", (Tag)Objects.requireNonNull(TagCodec.toTag((CompoundTag)new CompoundTag(), (Object)this)));
        this.data().write(tag, this.f_19804_);
        if (this.m_21536_() && (data = TagCodec.valueToTag((Object)new RestrictData(this.m_21534_(), this.m_21535_()))) != null) {
            tag.m_128365_("Restrict", data);
        }
    }

    public void m_7378_(CompoundTag tag) {
        RestrictData res;
        Tag data;
        super.m_7378_(tag);
        this.f_19797_ = tag.m_128451_("Age");
        if (tag.m_128441_("auto-serial")) {
            Wrappers.run(() -> TagCodec.fromTag((CompoundTag)tag.m_128469_("auto-serial"), this.getClass(), (Object)this, f -> true));
        }
        this.data().read(tag, this.f_19804_);
        if (this.m_5448_() == null) {
            this.setWalking();
        }
        if ((data = tag.m_128423_("Restrict")) != null && (res = (RestrictData)TagCodec.valueFromTag((Tag)data, RestrictData.class)) != null) {
            this.m_21446_(res.center(), (int)res.radius());
        }
    }

    public boolean getFlag(int flag) {
        return ((Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID) & flag) != 0;
    }

    public void setFlag(int flag, boolean enable) {
        int b0 = (Integer)this.f_19804_.m_135370_(DATA_FLAGS_ID);
        b0 = enable ? (int)((byte)(b0 | flag)) : (int)((byte)(b0 & -1 - flag));
        this.f_19804_.m_135381_(DATA_FLAGS_ID, (Object)b0);
    }

    public boolean invalidTarget(LivingEntity e) {
        return !e.m_6084_() || !e.isAddedToWorld() || e.m_9236_() != this.m_9236_() || e == this || !EntityStorageHelper.isPresent((Entity)e);
    }

    public boolean shouldIgnore(LivingEntity e) {
        if (e.m_6095_().m_204039_(YHTagGen.YOUKAI_IGNORE)) {
            return true;
        }
        if (this.invalidTarget(e)) {
            return true;
        }
        YoukaiFightEvent event = new YoukaiFightEvent(this, e);
        return MinecraftForge.EVENT_BUS.post((Event)event);
    }

    public boolean m_6673_(DamageSource pSource) {
        LivingEntity le;
        Entity entity = pSource.m_7639_();
        if (entity instanceof LivingEntity && this.shouldIgnore(le = (LivingEntity)entity)) {
            return true;
        }
        return pSource.m_269533_(DamageTypeTags.f_268549_);
    }

    protected boolean m_7341_(Entity pVehicle) {
        return false;
    }

    protected boolean m_8028_() {
        return false;
    }

    @Override
    public float getDamage(YHDanmaku.IDanmakuType type) {
        return (float)this.m_21133_(Attributes.f_22281_);
    }

    public double getStopRange() {
        return 16.0;
    }

    @Override
    @Nullable
    public LivingEntity targetEntity() {
        return this.m_5448_();
    }

    @Override
    public LivingEntity shooter() {
        return this;
    }

    public void shoot(float dmg, int life, Vec3 vec, DyeColor color) {
        ItemDanmakuEntity danmaku = new ItemDanmakuEntity((EntityType<? extends ItemDanmakuEntity>)((EntityType)YHEntities.ITEM_DANMAKU.get()), (LivingEntity)this, this.m_9236_());
        danmaku.setItem(YHDanmaku.Bullet.CIRCLE.get(color).asStack());
        danmaku.setup(dmg, life, true, true, vec);
        this.m_9236_().m_7967_((Entity)danmaku);
    }

    public void onDanmakuHit(LivingEntity e, IYHDanmaku danmaku) {
        if (EffectEventHandlers.isFullCharacter(e)) {
            return;
        }
        if (this.targets.contains(e)) {
            double heal = (Double)YHModConfig.COMMON.danmakuHealOnHitTarget.get();
            this.m_5634_(this.m_21233_() * (float)heal);
        }
    }

    public void onDanmakuImmune(LivingEntity e, IYHDanmaku danmaku, DamageSource source) {
    }

    public float percentageDamage(LivingEntity le) {
        if (le instanceof Player) {
            return ((Double)YHModConfig.COMMON.danmakuPlayerPHPDamage.get()).floatValue();
        }
        return ((Double)YHModConfig.COMMON.danmakuMinPHPDamage.get()).floatValue();
    }

    public final void setFlying() {
        this.m_20242_(true);
        if (this.f_21342_ == this.flyCtrl) {
            return;
        }
        this.m_21573_().m_26573_();
        this.f_21342_ = this.flyCtrl;
        this.f_21344_ = this.fltNav;
    }

    public final void setWalking() {
        this.m_20242_(false);
        if (this.f_21342_ == this.walkCtrl) {
            return;
        }
        this.m_21573_().m_26573_();
        this.m_21567_(0.0f);
        this.m_21570_(0.0f);
        this.m_21564_(0.0f);
        this.f_21342_ = this.walkCtrl;
        this.f_21344_ = this.walkNav;
    }

    public final boolean isFlying() {
        return this.f_21342_ == this.flyCtrl;
    }

    public void m_8107_() {
        if (!this.m_9236_().m_5776_()) {
            if (!this.m_20096_() && this.m_20184_().f_82480_ < 0.0) {
                double fall = this.m_5448_() != null ? 0.6 : 0.8;
                this.m_20256_(this.m_20184_().m_82542_(1.0, fall, 1.0));
            }
            this.targets.tick(super.m_5448_());
            if (this.spellCard != null) {
                if (this.m_5448_() != null && this.shouldShowSpellCircle()) {
                    this.spellCard.tick(this);
                    this.tickDanmaku();
                } else {
                    this.spellCard.reset();
                    this.allDanmakus.clear();
                    this.toBeSent.clear();
                }
            }
        }
        super.m_8107_();
    }

    public void trySummonReinforcementOnDeath(LivingEntity le) {
        TouhouConditionalSpawns.triggetYukari(le, this.m_20182_());
    }

    protected void m_6475_(DamageSource source, float amount) {
        if (this.spellCard != null) {
            this.spellCard.hurt(this, source, amount);
        }
        this.actuallyHurtImpl(source, amount);
    }

    protected final void actuallyHurtImpl(DamageSource source, float amount) {
        if (!this.m_6673_(source)) {
            if ((amount = ForgeHooks.onLivingHurt((LivingEntity)this, (DamageSource)source, (float)amount)) <= 0.0f) {
                return;
            }
            amount = this.m_21161_(source, amount);
            amount = this.m_6515_(source, amount);
            amount = ForgeHooks.onLivingDamage((LivingEntity)this, (DamageSource)source, (float)amount);
            this.hurtFinal(source, amount);
        }
    }

    protected void hurtFinal(DamageSource source, float amount) {
        Entity entity;
        if (!Float.isFinite(amount)) {
            return;
        }
        float abs = this.m_6103_();
        if (!Float.isFinite(abs)) {
            return;
        }
        float actual = Math.max(amount - Math.max(0.0f, abs), 0.0f);
        float absorb = amount - actual;
        this.m_7911_(Math.max(0.0f, this.m_6103_() - absorb));
        if (absorb > 0.0f && absorb < 3.4028235E37f && (entity = source.m_7639_()) instanceof ServerPlayer) {
            ServerPlayer serverplayer = (ServerPlayer)entity;
            serverplayer.m_36222_(Stats.f_12929_, Math.round(absorb * 10.0f));
        }
        if (actual != 0.0f) {
            this.m_21231_().m_289194_(source, actual);
            this.hurtFinalImpl(source, actual);
            this.m_7911_(Math.max(0.0f, this.m_6103_() - actual));
            this.m_146850_(GameEvent.f_223706_);
        }
    }

    protected void hurtFinalImpl(DamageSource source, float amount) {
        Player player;
        Entity entity;
        if (this.combatProgress == null) {
            return;
        }
        if (!source.m_269533_(YHDamageTypes.DANMAKU_TYPE) && (entity = source.m_7639_()) instanceof Player) {
            player = (Player)entity;
            ((GrazeCapability)GrazeCapability.HOLDER.get(player)).remove(this.m_20148_());
        }
        this.setCombatProgress(this.getCombatProgress() - amount);
        if (this.combatProgress.progress <= 0.0f) {
            this.eraseAllDanmaku(null);
            entity = source.m_7639_();
            if (entity instanceof Player) {
                player = (Player)entity;
                GrazeHelper.onDanmakuKill(player, this);
            }
        }
    }

    public void validateData() {
        if (this.combatProgress == null || this.getCombatProgress() != this.combatProgress.progress || this.getCombatProgress() > 0.0f) {
            if (this.f_20919_ > 0) {
                this.f_20919_ = 0;
            }
            if (this.f_20890_) {
                this.f_20890_ = false;
            }
        }
    }

    public void m_21153_(float amount) {
        if (!Float.isFinite(amount)) {
            return;
        }
        this.setCombatProgress(amount);
    }

    protected boolean m_6107_() {
        if (this.combatProgress == null || this.getCombatProgress() != this.combatProgress.progress) {
            return false;
        }
        return this.getCombatProgress() <= 0.0f;
    }

    public boolean m_21224_() {
        if (this.combatProgress == null || this.getCombatProgress() != this.combatProgress.progress) {
            return false;
        }
        return this.getCombatProgress() <= 0.0f;
    }

    public boolean m_6084_() {
        if (this.m_213877_()) {
            return false;
        }
        if (this.combatProgress == null || this.getCombatProgress() != this.combatProgress.progress) {
            return true;
        }
        return this.getCombatProgress() > 0.0f;
    }

    protected float getVanillaProgress() {
        return super.m_21223_();
    }

    public void setCombatProgress(float amount) {
        super.m_21153_(amount);
        if (this.combatProgress == null) {
            return;
        }
        if (amount > this.m_21233_()) {
            this.combatProgress.setMax();
        } else {
            this.combatProgress.set((LivingEntity)this, amount);
        }
    }

    public float getCombatProgress() {
        return this.combatProgress == null ? super.m_21223_() : this.combatProgress.getProgress();
    }

    public float m_21223_() {
        return this.getCombatProgress();
    }

    protected void m_6153_() {
        if (this.combatProgress == null || this.getCombatProgress() != this.combatProgress.progress) {
            return;
        }
        if (this.getCombatProgress() > 0.0f) {
            return;
        }
        super.m_6153_();
    }

    public void m_6667_(DamageSource source) {
        if (this.combatProgress == null || this.getCombatProgress() != this.combatProgress.progress) {
            return;
        }
        if (this.getCombatProgress() > 0.0f) {
            return;
        }
        super.m_6667_(source);
    }

    public void m_6710_(@Nullable LivingEntity e) {
        if (e != null && this.shouldIgnore(e)) {
            return;
        }
        super.m_6710_(e);
    }

    @Nullable
    public LivingEntity m_5448_() {
        if (this.targets == null) {
            return null;
        }
        return this.targets.getTarget();
    }

    public void setTargetAndInitSession(LivingEntity le) {
        Player player;
        if (le instanceof Player && EffectEventHandlers.isFullCharacter((LivingEntity)(player = (Player)le))) {
            GrazeCapability cap = (GrazeCapability)GrazeCapability.HOLDER.get(player);
            cap.initSession(this);
            return;
        }
        this.m_6710_(le);
    }

    protected void m_8024_() {
        LivingEntity target = this.m_5448_();
        if (target != null && this.m_6779_(target) && this.f_21342_ == this.flyCtrl) {
            boolean tooHigh = this.tooHigh();
            int expectedHeight = tooHigh ? 0 : 3;
            double low = -0.5;
            double high = tooHigh ? 0.0 : 0.5;
            double diff = target.m_20188_() + (double)expectedHeight - this.m_20188_();
            Vec3 vec3 = this.m_20184_();
            double moveY = vec3.f_82480_ * 0.5 + diff * 0.02;
            if (this.m_20188_() < target.m_20188_() + (double)expectedHeight + low) {
                this.setY(Math.max(vec3.f_82480_, moveY));
            }
            if (this.m_20188_() > target.m_20188_() + (double)expectedHeight + high) {
                if (diff < -1.0) {
                    this.setY(Math.min(vec3.f_82480_, moveY));
                } else if (tooHigh) {
                    this.setY(Math.min(vec3.f_82480_, -0.01));
                }
            }
        }
        super.m_8024_();
    }

    private void setY(double vy) {
        Vec3 vec3 = this.m_20184_();
        this.m_20334_(vec3.f_82479_, vy, vec3.f_82481_);
        if (vy > 0.0 && this.m_20096_()) {
            this.f_19812_ = true;
        }
    }

    public boolean tooHigh() {
        BlockPos pos = this.m_20097_();
        for (int i = 0; i < 5; ++i) {
            BlockPos off = pos.m_7918_(0, -i, 0);
            if (this.m_9236_().m_8055_(off).m_60795_()) continue;
            return false;
        }
        return true;
    }

    public boolean shouldHurt(LivingEntity le) {
        return this.targets.contains(le);
    }

    @Override
    public LivingEntity self() {
        return super.self();
    }

    @Override
    public DamageSource getDanmakuDamageSource(IYHDanmaku danmaku) {
        if (this.spellCard != null) {
            return this.spellCard.card.getDanmakuDamageSource(danmaku);
        }
        return YHDamageTypes.danmaku(danmaku);
    }

    public void resetTarget(Player target) {
        this.targets.remove(target.m_20148_());
        this.m_6710_(null);
        this.m_6703_(null);
        this.setCombatProgress(this.combatProgress.maxProgress);
    }

    public void danmakuHitTarget(IYHDanmaku self, DamageSource source, LivingEntity target) {
        if (this.combatProgress.progress <= 0.0f) {
            return;
        }
        if (target instanceof Player) {
            Player player = (Player)target;
            GrazeCapability graze = (GrazeCapability)GrazeCapability.HOLDER.get(player);
            GrazeCapability.HitType type = graze.performErase(this);
            if (type.erase()) {
                this.eraseAllDanmaku(player);
            }
            if (type.skipDamage()) {
                return;
            }
        }
        float hp = target.m_21223_();
        boolean immune = !target.m_6469_(source, self.damage((Entity)target));
        float ahp = target.m_21223_();
        if (ahp >= hp && ahp > 0.0f) {
            immune = true;
        }
        this.onDanmakuHit(target, self);
        if (immune) {
            this.onDanmakuImmune(target, self, source);
        }
    }

    @Override
    public void shoot(Entity danmaku) {
        if (danmaku instanceof SimplifiedProjectile) {
            SimplifiedProjectile proj = (SimplifiedProjectile)danmaku;
            if (this.temp != null) {
                this.temp.add(proj);
            } else {
                this.allDanmakus.add(proj);
            }
            this.toBeSent.add(proj);
        } else {
            LivingCardHolder.super.shoot(danmaku);
        }
    }

    private void tickDanmaku() {
        this.removeDanmaku = false;
        this.temp = new ArrayList();
        Iterator itr = this.allDanmakus.iterator();
        while (itr.hasNext()) {
            SimplifiedProjectile e = (SimplifiedProjectile)itr.next();
            if (e.isAddedToWorld() && !e.m_213877_()) continue;
            if (e.isValid()) {
                e.m_146867_();
                ++e.f_19797_;
                e.m_8119_();
            }
            if (this.removeDanmaku) break;
            if (e.isValid()) continue;
            itr.remove();
        }
        if (!this.removeDanmaku) {
            this.allDanmakus.addAll(this.temp);
            DanmakuManager.send((LivingEntity)this, this.toBeSent);
        }
        this.temp = null;
        this.toBeSent.clear();
    }

    public void eraseAllDanmaku(@Nullable Player player) {
        for (SimplifiedProjectile e : this.allDanmakus) {
            if (player == null) {
                e.markErased(true);
                continue;
            }
            e.erase((LivingEntity)player);
        }
        this.allDanmakus.clear();
        this.removeDanmaku = true;
    }

    @Override
    public UserCacheHolder entityCache() {
        return this.cache;
    }
}

