/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.entity.rumia;

import dev.xkmc.youkaishomecoming.content.entity.danmaku.DanmakuHelper;
import dev.xkmc.youkaishomecoming.content.entity.rumia.RumiaEntity;
import dev.xkmc.youkaishomecoming.content.entity.youkai.YoukaiAttackGoal;
import java.util.List;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import net.minecraft.world.entity.ai.attributes.Attributes;
import net.minecraft.world.item.DyeColor;
import net.minecraft.world.phys.Vec3;

public class RumiaAttackGoal
extends YoukaiAttackGoal<RumiaEntity> {
    private static final int BALL_RANGE = 10;
    private static final int SHOOT_FREQUENCY = 40;
    private static final int SEPARATION = 12;
    private static final int ANGLE = 3;
    private static final float SPEED = 0.64f;
    private static final float SPEED_VAR = 0.08f;

    public RumiaAttackGoal(RumiaEntity pBlaze) {
        super(pBlaze);
    }

    @Override
    public boolean m_8036_() {
        return !((RumiaEntity)this.youkai).isBlocked() && super.m_8036_();
    }

    @Override
    protected boolean specialAction() {
        if (((RumiaEntity)this.youkai).isCharged()) {
            LivingEntity target = ((RumiaEntity)this.youkai).m_5448_();
            if (target != null) {
                boolean sight = ((RumiaEntity)this.youkai).m_21574_().m_148306_((Entity)target);
                double dist = ((RumiaEntity)this.youkai).m_20280_((Entity)target);
                if (sight) {
                    this.attack(target, dist, true);
                }
            }
            return true;
        }
        return false;
    }

    @Override
    protected double getMeleeRange() {
        return ((RumiaEntity)this.youkai).isCharged() ? 3.0 : 2.0;
    }

    @Override
    protected void attack(LivingEntity target, double dist, boolean sight) {
        if (sight && dist < 100.0) {
            ((RumiaEntity)this.youkai).state.startChargeAttack(target);
        }
        super.attack(target, dist, sight);
    }

    @Override
    protected void meleeAttack(LivingEntity target) {
        if (((RumiaEntity)this.youkai).m_7327_((Entity)target)) {
            ((RumiaEntity)this.youkai).state.onAttack(target);
        }
    }

    @Override
    protected int shoot(LivingEntity target, List<LivingEntity> all) {
        if (((RumiaEntity)this.youkai).isCharged()) {
            return 10;
        }
        int round = ((RumiaEntity)this.youkai).isEx() ? 5 : 3;
        this.shoot(target, round);
        double range = this.getShootRange();
        for (LivingEntity e : all) {
            if (e == target || !(e.m_20280_((Entity)this.youkai) < range * range)) continue;
            this.shoot(e, round - 2);
        }
        int ans = 40;
        if (((RumiaEntity)this.youkai).isEx()) {
            ans /= 2;
        }
        return ans;
    }

    private void shoot(LivingEntity target, int round) {
        double range = this.getShootRange();
        double dx = target.m_20185_() - ((RumiaEntity)this.youkai).m_20185_();
        double dy = target.m_20227_(0.5) - ((RumiaEntity)this.youkai).m_20227_(0.5);
        double dz = target.m_20189_() - ((RumiaEntity)this.youkai).m_20189_();
        Vec3 vec = new Vec3(dx, dy, dz).m_82541_();
        DanmakuHelper.Orientation ori = DanmakuHelper.getOrientation(vec);
        int off = (double)((RumiaEntity)this.youkai).m_217043_().m_188501_() < 0.5 ? -3 : 3;
        float dmg = (float)((RumiaEntity)this.youkai).m_21133_(Attributes.f_22281_);
        for (int i = 0; i < round; ++i) {
            float speed = 0.64f + (float)i * 0.08f;
            int angle = off * (round - i - 2);
            int life = (int)(range / (double)speed);
            ((RumiaEntity)this.youkai).shoot(dmg, life, ori.rotateDegrees(-12 + angle).m_82490_((double)speed), DyeColor.RED);
            ((RumiaEntity)this.youkai).shoot(dmg, life, ori.rotateDegrees(angle).m_82490_((double)speed), DyeColor.BLACK);
            ((RumiaEntity)this.youkai).shoot(dmg, life, ori.rotateDegrees(12 + angle).m_82490_((double)speed), DyeColor.RED);
        }
    }
}

