/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.variants;

import com.tterrag.registrate.providers.RegistrateBlockstateProvider;
import dev.xkmc.youkaishomecoming.content.block.variants.TemplateModelHandler;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.TrapDoorBlock;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.properties.BlockSetType;
import net.minecraft.world.level.block.state.properties.Half;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.shapes.CollisionContext;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.client.model.generators.ConfiguredModel;
import net.minecraftforge.client.model.generators.ModelFile;

public class ThinTrapdoorBlock
extends TrapDoorBlock {
    protected static final int TH = 1;
    protected static final VoxelShape EAST_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)1.0, (double)16.0, (double)16.0);
    protected static final VoxelShape WEST_OPEN_AABB = Block.m_49796_((double)15.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape SOUTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)16.0, (double)1.0);
    protected static final VoxelShape NORTH_OPEN_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)15.0, (double)16.0, (double)16.0, (double)16.0);
    protected static final VoxelShape BOTTOM_AABB = Block.m_49796_((double)0.0, (double)0.0, (double)0.0, (double)16.0, (double)1.0, (double)16.0);
    protected static final VoxelShape TOP_AABB = Block.m_49796_((double)0.0, (double)15.0, (double)0.0, (double)16.0, (double)16.0, (double)16.0);

    public ThinTrapdoorBlock(BlockBehaviour.Properties pProperties, BlockSetType pType) {
        super(pProperties, pType);
    }

    public VoxelShape m_5940_(BlockState pState, BlockGetter pLevel, BlockPos pPos, CollisionContext pContext) {
        if (!((Boolean)pState.m_61143_((Property)f_57514_)).booleanValue()) {
            return pState.m_61143_((Property)f_57515_) == Half.TOP ? TOP_AABB : BOTTOM_AABB;
        }
        return switch ((Direction)pState.m_61143_((Property)f_54117_)) {
            case Direction.SOUTH -> SOUTH_OPEN_AABB;
            case Direction.WEST -> WEST_OPEN_AABB;
            case Direction.EAST -> EAST_OPEN_AABB;
            default -> NORTH_OPEN_AABB;
        };
    }

    public static void buildModels(RegistrateBlockstateProvider pvd, TrapDoorBlock block, String baseName, ResourceLocation texture) {
        TemplateModelHandler handler = new TemplateModelHandler(pvd.models());
        Object bottom = handler.trapdoorOrientableBottom(baseName + "_bottom", texture);
        Object top = handler.trapdoorOrientableTop(baseName + "_top", texture);
        Object open = handler.trapdoorOrientableOpen(baseName + "_open", texture);
        ThinTrapdoorBlock.trapdoorBlock(pvd, block, bottom, top, open);
    }

    public static void trapdoorBlock(RegistrateBlockstateProvider pvd, TrapDoorBlock block, ModelFile bottom, ModelFile top, ModelFile open) {
        pvd.getVariantBuilder((Block)block).forAllStatesExcept(state -> {
            int xRot = 0;
            int yRot = (int)((Direction)state.m_61143_((Property)TrapDoorBlock.f_54117_)).m_122435_() + 180;
            boolean isOpen = (Boolean)state.m_61143_((Property)TrapDoorBlock.f_57514_);
            if (isOpen && state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP) {
                xRot += 180;
                yRot += 180;
            }
            return ConfiguredModel.builder().modelFile(isOpen ? open : (state.m_61143_((Property)TrapDoorBlock.f_57515_) == Half.TOP ? top : bottom)).rotationX(xRot).rotationY(yRot %= 360).build();
        }, new Property[]{TrapDoorBlock.f_57516_, TrapDoorBlock.f_57517_});
    }
}

