/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.youkaishomecoming.content.block.plant.grape;

import dev.xkmc.l2harvester.api.HarvestResult;
import dev.xkmc.l2harvester.api.HarvestableBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.grape.VineTrunkBlock;
import dev.xkmc.youkaishomecoming.content.block.plant.rope.RopeLoggedCropBlock;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.util.RandomSource;
import net.minecraft.world.InteractionHand;
import net.minecraft.world.InteractionResult;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.monster.Ravager;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockGetter;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.LevelReader;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.BushBlock;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockBehaviour;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.block.state.StateDefinition;
import net.minecraft.world.level.block.state.properties.BooleanProperty;
import net.minecraft.world.level.block.state.properties.IntegerProperty;
import net.minecraft.world.level.block.state.properties.Property;
import net.minecraft.world.phys.BlockHitResult;
import net.minecraftforge.common.ForgeHooks;
import net.minecraftforge.event.ForgeEventFactory;
import org.jetbrains.annotations.Nullable;
import vectorwing.farmersdelight.common.registry.ModSounds;

public abstract class BaseCropVineBlock
extends BushBlock
implements HarvestableBlock {
    public static final BooleanProperty TOP = BooleanProperty.m_61465_((String)"top");

    public BaseCropVineBlock(BlockBehaviour.Properties prop) {
        super(prop);
        this.m_49959_((BlockState)((BlockState)((BlockState)this.f_49792_.m_61090_()).m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(0))).m_61124_((Property)TOP, (Comparable)Boolean.valueOf(false)));
    }

    protected void m_7926_(StateDefinition.Builder<Block, BlockState> builder) {
        builder.m_61104_(new Property[]{this.getAgeProperty(), TOP});
    }

    protected abstract IntegerProperty getAgeProperty();

    public abstract int getMaxAge();

    protected abstract int getBaseAge();

    protected abstract VineTrunkBlock getTrunk();

    protected abstract ItemLike getFruit();

    @Nullable
    protected abstract BlockPos getTrunk(BlockState var1, BlockGetter var2, BlockPos var3);

    public abstract ItemStack m_7397_(BlockGetter var1, BlockPos var2, BlockState var3);

    public InteractionResult m_6227_(BlockState state, Level level, BlockPos pos, Player player, InteractionHand hand, BlockHitResult hit) {
        if (((Integer)state.m_61143_((Property)this.getAgeProperty())).intValue() == this.getMaxAge()) {
            if (!level.m_5776_()) {
                this.pickup(state, level, pos, player);
            }
            level.m_5594_(player, pos, (SoundEvent)ModSounds.ITEM_TOMATO_PICK_FROM_BUSH.get(), SoundSource.BLOCKS, 1.0f, 0.8f + level.f_46441_.m_188501_() * 0.4f);
            return InteractionResult.SUCCESS;
        }
        return InteractionResult.PASS;
    }

    protected void pickup(BlockState state, Level level, BlockPos pos, Player player) {
        int quantity = 1 + level.f_46441_.m_188503_(2);
        BaseCropVineBlock.m_49840_((Level)level, (BlockPos)pos, (ItemStack)new ItemStack(this.getFruit(), quantity));
        level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getBaseAge())), 2);
    }

    public boolean m_7898_(BlockState state, LevelReader level, BlockPos pos) {
        return this.getTrunk(state, (BlockGetter)level, pos) != null;
    }

    protected float getGrowthSpeed(BlockState state, BlockGetter level, BlockPos pos) {
        BlockPos trunk = this.getTrunk(state, level, pos);
        if (trunk == null) {
            return 0.0f;
        }
        return this.getTrunk().getGrowthSpeed(level, pos);
    }

    protected boolean mayGrow(BlockState state, LevelReader level, BlockPos pos) {
        return level.m_45524_(pos, 0) >= 9;
    }

    protected boolean attemptGrowth(BlockState state, LevelReader level, BlockPos pos, @Nullable RandomSource random, boolean simulate, boolean natural, float speed) {
        int age = (Integer)state.m_61143_((Property)this.getAgeProperty());
        if (age < this.getMaxAge()) {
            if (simulate) {
                return true;
            }
            assert (random != null);
            Level setter = (Level)level;
            if (!natural) {
                this.doGrowth(state, setter, pos, random);
                return true;
            }
            if (ForgeHooks.onCropsGrowPre((Level)setter, (BlockPos)pos, (BlockState)state, (random.m_188501_() < speed ? 1 : 0) != 0)) {
                setter.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age + 1)), 2);
                ForgeHooks.onCropsGrowPost((Level)setter, (BlockPos)pos, (BlockState)state);
                return true;
            }
        }
        return false;
    }

    protected void doGrowth(BlockState state, Level level, BlockPos pos, RandomSource random) {
        int age = (Integer)state.m_61143_((Property)this.getAgeProperty());
        if (age < this.getMaxAge()) {
            level.m_7731_(pos, (BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(age + 1)), 2);
        }
    }

    public void m_213898_(BlockState state, ServerLevel level, BlockPos pos, RandomSource rand) {
        if (!level.isAreaLoaded(pos, 1)) {
            return;
        }
        float f = this.getGrowthSpeed(state, (BlockGetter)level, pos) * 0.02f;
        if (!this.mayGrow(state, (LevelReader)level, pos)) {
            return;
        }
        this.attemptGrowth(state, (LevelReader)level, pos, rand, false, true, f);
    }

    public void m_7892_(BlockState state, Level level, BlockPos pos, Entity e) {
        if (e instanceof Ravager && ForgeEventFactory.getMobGriefingEvent((Level)level, (Entity)e)) {
            level.m_46953_(pos, true, e);
        }
        super.m_7892_(state, level, pos, e);
    }

    @Nullable
    public HarvestResult getHarvestResult(Level level, BlockState state, BlockPos pos) {
        if ((Integer)state.m_61143_((Property)this.getAgeProperty()) < this.getMaxAge()) {
            return null;
        }
        int quantity = 1 + level.f_46441_.m_188503_(2);
        return new HarvestResult((BlockState)state.m_61124_((Property)this.getAgeProperty(), (Comparable)Integer.valueOf(this.getBaseAge())), List.of(new ItemStack(this.getFruit(), quantity)));
    }

    public void m_6240_(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        this.doPlayerDestroy(level, player, pos, state, be, stack);
        BaseCropVineBlock.destroyAndPlaceRope(level, pos);
    }

    public void doPlayerDestroy(Level level, Player player, BlockPos pos, BlockState state, @Nullable BlockEntity be, ItemStack stack) {
        super.m_6240_(level, player, pos, state, be, stack);
    }

    public BlockState m_7417_(BlockState state, Direction facing, BlockState fstate, LevelAccessor level, BlockPos cpos, BlockPos fpos) {
        if (!state.m_60710_((LevelReader)level, cpos)) {
            level.m_186460_(cpos, (Block)this, 1);
        }
        return state;
    }

    public void m_213897_(BlockState state, ServerLevel level, BlockPos pos, RandomSource random) {
        level.m_46961_(pos, true);
        BaseCropVineBlock.destroyAndPlaceRope((Level)level, pos);
    }

    public static void destroyAndPlaceRope(Level level, BlockPos pos) {
        level.m_46597_(pos, RopeLoggedCropBlock.getRopeBlock());
    }
}

