/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.spellcircle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.math.Axis;
import dev.xkmc.fastprojectileapi.spellcircle.SpellCircleConfig;
import dev.xkmc.l2serial.serialization.SerialClass;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.Nullable;

@SerialClass
public class SpellComponent {
    @SerialClass.SerialField
    public ArrayList<Stroke> strokes = new ArrayList();
    @SerialClass.SerialField
    public ArrayList<Layer> layers = new ArrayList();

    @Nullable
    public static SpellComponent getFromConfig(String s) {
        return ((SpellCircleConfig)YoukaisHomecoming.SPELL.getMerged()).map.get(s);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void render(RenderHandle handle) {
        handle.matrix.m_85836_();
        for (Stroke stroke : this.strokes) {
            stroke.render(handle);
        }
        for (Layer layer : this.layers) {
            layer.render(handle);
        }
        handle.matrix.m_85849_();
    }

    @OnlyIn(value=Dist.CLIENT)
    public static class RenderHandle {
        public final PoseStack matrix;
        public final VertexConsumer builder;
        public final float tick;
        public final int light;
        public float alpha = 1.0f;

        public RenderHandle(PoseStack matrix, VertexConsumer builder, float tick, int light) {
            this.matrix = matrix;
            this.builder = builder;
            this.tick = tick;
            this.light = light;
        }
    }

    @SerialClass
    public static class Stroke {
        @SerialClass.SerialField
        public int vertex;
        @SerialClass.SerialField
        public int cycle = 1;
        @SerialClass.SerialField
        public int rune = 0;
        @SerialClass.SerialField
        public String color;
        @SerialClass.SerialField
        public float width;
        @SerialClass.SerialField
        public float radius;
        @SerialClass.SerialField
        public float z;
        @SerialClass.SerialField
        public float angle;

        @OnlyIn(value=Dist.CLIENT)
        public void render(RenderHandle handle) {
            float da = (float)Math.PI * 2 * (float)this.cycle / (float)this.vertex;
            float a = this.angle;
            float w = this.width / (float)Math.cos(da / 2.0f);
            int col = this.getColor();
            float dv = (float)(this.rune > 0 ? 8 : 1) / 128.0f;
            float du = (float)((int)(Math.PI * 2 * (double)this.radius * (double)this.cycle / (double)this.width * 8.0)) / 8.0f / (float)this.vertex * dv;
            for (int i = 0; i < this.vertex; ++i) {
                Stroke.rect(handle, a + da * (float)i, da, this.radius, w, this.z, col, (float)i * du, this.rune == 0 ? 0.0f : (float)(this.rune - 1) * dv, du, dv);
            }
        }

        @OnlyIn(value=Dist.CLIENT)
        private int getColor() {
            if (this.color == null) {
                return -1;
            }
            String str = this.color;
            if (str.startsWith("0x")) {
                str = str.substring(2);
            }
            return Integer.parseUnsignedInt(str, 16);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void rect(RenderHandle handle, float a, float da, float r, float w, float z, int col, float u, float v, float du, float dv) {
            float inner = r - w / 2.0f;
            float outer = r + w / 2.0f;
            Stroke.vertex(handle, a, inner, z, col, u, v);
            Stroke.vertex(handle, a, outer, z, col, u, v + dv);
            Stroke.vertex(handle, a + da, outer, z, col, u + du, v + dv);
            Stroke.vertex(handle, a + da, inner, z, col, u + du, v);
        }

        @OnlyIn(value=Dist.CLIENT)
        private static void vertex(RenderHandle handle, float a, float r, float z, int col, float u, float v) {
            int alp = (int)((float)(col >> 24 & 0xFF) * handle.alpha);
            handle.builder.m_252986_(handle.matrix.m_85850_().m_252922_(), r * (float)Math.cos(a), r * (float)Math.sin(a), z).m_6122_(col >> 16 & 0xFF, col >> 8 & 0xFF, col & 0xFF, alp).m_7421_(u, v).m_5752_();
        }
    }

    @SerialClass
    public static class Layer {
        @SerialClass.SerialField
        public ArrayList<String> children = new ArrayList();
        private List<SpellComponent> _children;
        @SerialClass.SerialField
        @Nullable
        public Value z_offset;
        @SerialClass.SerialField
        @Nullable
        public Value scale;
        @SerialClass.SerialField
        @Nullable
        public Value radius;
        @SerialClass.SerialField
        @Nullable
        public Value rotation;
        @SerialClass.SerialField
        @Nullable
        public Value alpha;

        @OnlyIn(value=Dist.CLIENT)
        public void render(RenderHandle handle) {
            if (this._children == null) {
                this._children = this.children.stream().map(SpellComponent::getFromConfig).collect(Collectors.toList());
                return;
            }
            int n = this._children.size();
            float z = this.get(this.z_offset, handle, 0.0f);
            float s = this.get(this.scale, handle, 1.0f);
            float a = this.get(this.rotation, handle, 0.0f);
            double r = this.get(this.radius, handle, 0.0f);
            float al = handle.alpha;
            if (this.alpha != null) {
                handle.alpha *= this.alpha.get(handle.tick);
            }
            handle.matrix.m_85836_();
            handle.matrix.m_252880_(0.0f, 0.0f, z);
            handle.matrix.m_85841_(s, s, s);
            for (SpellComponent child : this._children) {
                handle.matrix.m_85836_();
                handle.matrix.m_252781_(Axis.f_252403_.m_252977_(a));
                handle.matrix.m_85837_(r, 0.0, 0.0);
                child.render(handle);
                handle.matrix.m_85849_();
                a += 360.0f / (float)n;
            }
            handle.matrix.m_85849_();
            handle.alpha = al;
        }

        @OnlyIn(value=Dist.CLIENT)
        private float get(@Nullable Value val, RenderHandle handle, float def) {
            return val == null ? def : val.get(handle.tick);
        }
    }

    @SerialClass
    public static class Value {
        @SerialClass.SerialField
        public float value;
        @SerialClass.SerialField
        public float delta;
        @SerialClass.SerialField
        public float amplitude;
        @SerialClass.SerialField
        public float period;
        @SerialClass.SerialField
        public float dt;

        @OnlyIn(value=Dist.CLIENT)
        public float get(float tick) {
            float ans = this.value + this.delta * tick;
            if (this.period > 0.0f) {
                ans += this.amplitude * (float)Math.sin((double)((tick - this.dt) * 2.0f) * Math.PI / (double)this.period);
            }
            return ans;
        }
    }
}

