/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.spellcircle;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.math.Axis;
import dev.xkmc.fastprojectileapi.spellcircle.SpellCircleConfig;
import dev.xkmc.fastprojectileapi.spellcircle.SpellCircleHolder;
import dev.xkmc.fastprojectileapi.spellcircle.SpellComponent;
import dev.xkmc.fastprojectileapi.spellcircle.SpellRenderState;
import dev.xkmc.youkaishomecoming.init.YoukaisHomecoming;
import net.minecraft.client.model.EntityModel;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.entity.LivingEntityRenderer;
import net.minecraft.client.renderer.entity.layers.RenderLayer;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.LivingEntity;
import org.jetbrains.annotations.Nullable;
import org.joml.Quaternionf;

public class SpellCircleLayer<T extends LivingEntity, M extends EntityModel<T>>
extends RenderLayer<T, M> {
    private static final ResourceLocation SPELL = YoukaisHomecoming.loc("textures/entities/spell_circle.png");

    public SpellCircleLayer(LivingEntityRenderer<T, M> pRenderer) {
        super(pRenderer);
    }

    public void render(PoseStack pose, MultiBufferSource buffer, int light, T entity, float swing, float swingAmp, float pTick, float age, float yaw, float pitch) {
        SpellCircleLayer.renderImpl(pose, buffer, light, entity, pTick, null);
    }

    public static <T extends Entity> void renderImpl(PoseStack pose, MultiBufferSource buffer, int light, T entity, float pTick, @Nullable Quaternionf front) {
        if (!(entity instanceof SpellCircleHolder)) {
            return;
        }
        SpellCircleHolder e = (SpellCircleHolder)entity;
        ResourceLocation rl = e.getSpellCircle();
        if (rl == null) {
            return;
        }
        SpellComponent component = SpellCircleConfig.getFromConfig(rl);
        if (component == null) {
            return;
        }
        SpellComponent.RenderHandle handle = new SpellComponent.RenderHandle(pose, buffer.m_6299_(SpellRenderState.getSpell(SPELL)), (float)entity.f_19797_ + pTick, light);
        pose.m_85836_();
        pose.m_252880_(0.0f, entity.m_20206_() / 2.0f, 0.0f);
        float scale = e.getCircleSize(pTick);
        pose.m_85841_(scale / 16.0f, scale / 16.0f, scale / 16.0f);
        if (front != null) {
            pose.m_252781_(front);
            pose.m_252781_(Axis.f_252436_.m_252977_(180.0f));
        }
        component.render(handle);
        pose.m_85849_();
    }
}

