/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.virtual;

import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import dev.xkmc.l2serial.util.Wrappers;
import dev.xkmc.youkaishomecoming.content.entity.danmaku.IYHDanmaku;
import it.unimi.dsi.fastutil.ints.Int2ObjectOpenHashMap;
import java.util.Iterator;
import java.util.LinkedList;
import net.minecraft.client.Camera;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.LevelRenderer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.culling.Frustum;
import net.minecraft.client.renderer.entity.EntityRenderDispatcher;
import net.minecraft.client.renderer.entity.EntityRenderer;
import net.minecraft.util.Mth;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.level.Level;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.Vec3;
import org.jetbrains.annotations.Nullable;
import org.joml.Matrix3f;
import org.joml.Matrix4f;

public class ClientDanmakuCache {
    private static ClientDanmakuCache CACHE = null;
    private static EntityRenderer[] RENDERERS;
    private final Level level;
    private final LinkedList<SimplifiedProjectile> all = new LinkedList();
    private final Int2ObjectOpenHashMap<SimplifiedProjectile> map = new Int2ObjectOpenHashMap(2048);

    private static <T extends SimplifiedProjectile> EntityRenderer<T> getRenderer(EntityRenderDispatcher disp, T e) {
        int id = e.getTypeId();
        if (RENDERERS == null || RENDERERS.length <= id) {
            RENDERERS = new EntityRenderer[id + 1];
        }
        if (RENDERERS[id] == null) {
            ClientDanmakuCache.RENDERERS[id] = disp.m_114382_(e);
        }
        return (EntityRenderer)Wrappers.cast((Object)RENDERERS[id]);
    }

    public static ClientDanmakuCache get(Level level) {
        if (CACHE == null || ClientDanmakuCache.CACHE.level != level) {
            CACHE = new ClientDanmakuCache(level);
        }
        return CACHE;
    }

    public ClientDanmakuCache(Level level) {
        this.level = level;
    }

    public void add(SimplifiedProjectile sp) {
        this.all.add(sp);
        this.map.put(sp.m_19879_(), (Object)sp);
    }

    public void erase(int id, boolean kill) {
        SimplifiedProjectile e = (SimplifiedProjectile)this.map.get(id);
        e.markErased(kill);
    }

    public void tick() {
        Iterator itr = this.all.iterator();
        while (itr.hasNext()) {
            SimplifiedProjectile e = (SimplifiedProjectile)itr.next();
            e.m_146867_();
            ++e.f_19797_;
            e.m_8119_();
            if (e.isValid()) continue;
            itr.remove();
            this.map.remove(e.m_19879_());
        }
    }

    public void renderAll(Camera cam, Frustum frustum, PoseStack pose, float pTick, MultiBufferSource.BufferSource buffer) {
        Entity entity;
        Vec3 vec3 = cam.m_90583_();
        double d0 = vec3.m_7096_();
        double d1 = vec3.m_7098_();
        double d2 = vec3.m_7094_();
        EntityRenderDispatcher disp = Minecraft.m_91087_().m_91290_();
        VertexConsumer box = disp.m_114377_() && !Minecraft.m_91087_().m_91299_() ? buffer.m_6299_(RenderType.m_110504_()) : null;
        for (SimplifiedProjectile e : this.all) {
            this.maybeRenderEntity(disp, frustum, e, d0, d1, d2, pTick, pose, box);
        }
        if (box != null && (entity = cam.m_90592_()) instanceof Player) {
            Player pl = (Player)entity;
            if (!this.all.isEmpty() && !Minecraft.m_91087_().f_91066_.m_92176_().m_90612_()) {
                ClientDanmakuCache.renderPlayerHitbox(pose, box, pl, d0, d1, d2, pTick);
            }
        }
    }

    private <E extends SimplifiedProjectile> void maybeRenderEntity(EntityRenderDispatcher disp, Frustum frustum, E e, double camx, double camy, double camz, float pTick, PoseStack pose, @Nullable VertexConsumer box) {
        EntityRenderer<E> er = ClientDanmakuCache.getRenderer(disp, e);
        if (!er.m_5523_(e, frustum, camx, camy, camz)) {
            return;
        }
        double dx = Mth.m_14139_((double)pTick, (double)e.f_19790_, (double)e.m_20185_());
        double dy = Mth.m_14139_((double)pTick, (double)e.f_19791_, (double)e.m_20186_());
        double dz = Mth.m_14139_((double)pTick, (double)e.f_19792_, (double)e.m_20189_());
        this.renderEntity(e, er, dx - camx, dy - camy, dz - camz, pTick, pose, box);
    }

    public <E extends SimplifiedProjectile> void renderEntity(E e, EntityRenderer<E> er, double x, double y, double z, float pTick, PoseStack pose, @Nullable VertexConsumer box) {
        if (!(er instanceof ProjectileRenderer)) {
            return;
        }
        ProjectileRenderer pr = (ProjectileRenderer)er;
        ProjectileRenderer r = (ProjectileRenderer)Wrappers.cast((Object)pr);
        Vec3 vec3 = er.m_7860_(e, pTick);
        double dx = x + vec3.m_7096_();
        double dy = y + vec3.m_7098_();
        double dz = z + vec3.m_7094_();
        pose.m_85836_();
        pose.m_85837_(dx, dy, dz);
        r.render(e, pTick, pose);
        if (box != null) {
            pose.m_85837_(-vec3.m_7096_(), -vec3.m_7098_(), -vec3.m_7094_());
            ClientDanmakuCache.renderHitbox(pose, box, e, pTick);
        }
        pose.m_85849_();
    }

    public static void renderHitbox(PoseStack pose, VertexConsumer vc, Entity e, float pTick) {
        AABB aabb = e.m_20191_().m_82386_(-e.m_20185_(), -e.m_20186_(), -e.m_20189_());
        LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)vc, (AABB)aabb, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        Vec3 vec3 = e.m_20252_(pTick);
        Matrix4f mat4 = pose.m_85850_().m_252922_();
        Matrix3f mat3 = pose.m_85850_().m_252943_();
        vc.m_252986_(mat4, 0.0f, e.m_20192_(), 0.0f).m_6122_(0, 0, 255, 255).m_252939_(mat3, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_5752_();
        vc.m_252986_(mat4, (float)(vec3.f_82479_ * 2.0), (float)((double)e.m_20192_() + vec3.f_82480_ * 2.0), (float)(vec3.f_82481_ * 2.0)).m_6122_(0, 0, 255, 255).m_252939_(mat3, (float)vec3.f_82479_, (float)vec3.f_82480_, (float)vec3.f_82481_).m_5752_();
    }

    public static void renderPlayerHitbox(PoseStack pose, VertexConsumer vc, Player e, double camx, double camy, double camz, float pTick) {
        double dx = Mth.m_14139_((double)pTick, (double)e.f_19790_, (double)e.m_20185_()) - camx - e.m_20185_();
        double dy = Mth.m_14139_((double)pTick, (double)e.f_19791_, (double)e.m_20186_()) - camy - e.m_20186_();
        double dz = Mth.m_14139_((double)pTick, (double)e.f_19792_, (double)e.m_20189_()) - camz - e.m_20189_();
        if (e.m_20145_()) {
            AABB base = e.m_20191_().m_82386_(dx, dy, dz);
            AABB hit = IYHDanmaku.alterEntityHitBox((Entity)e, 0.0f, 0.0f).m_82386_(dx, dy, dz);
            LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)vc, (AABB)base, (float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
            if (!base.equals((Object)hit)) {
                LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)vc, (AABB)hit, (float)1.0f, (float)0.25f, (float)0.25f, (float)1.0f);
            }
        }
        AABB graze = IYHDanmaku.alterEntityHitBox((Entity)e, 0.0f, 1.5f).m_82386_(dx, dy, dz);
        LevelRenderer.m_109646_((PoseStack)pose, (VertexConsumer)vc, (AABB)graze, (float)0.25f, (float)1.0f, (float)0.0f, (float)1.0f);
    }
}

