/*
 * Decompiled with CFR 0.152.
 */
package dev.xkmc.fastprojectileapi.render.type;

import com.mojang.blaze3d.vertex.PoseStack;
import dev.xkmc.fastprojectileapi.entity.SimplifiedProjectile;
import dev.xkmc.fastprojectileapi.render.core.BulkDataWriter;
import dev.xkmc.fastprojectileapi.render.core.DanmakuRenderStates;
import dev.xkmc.fastprojectileapi.render.core.DisplayType;
import dev.xkmc.fastprojectileapi.render.core.ProjectileRenderer;
import dev.xkmc.fastprojectileapi.render.type.RenderableProjectileType;
import dev.xkmc.youkaishomecoming.init.data.YHModConfig;
import java.util.List;
import java.util.function.Consumer;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.resources.ResourceLocation;
import org.joml.Matrix4f;
import org.joml.Matrix4fc;
import org.joml.Vector4f;

public record PencilLayerLaserType(ResourceLocation inner, ResourceLocation outer, int color) implements RenderableProjectileType<PencilLayerLaserType, Ins>
{
    @Override
    public int order() {
        return 10;
    }

    @Override
    public void start(MultiBufferSource buffer, List<Ins> list) {
        boolean additive = (Boolean)YHModConfig.CLIENT.laserRenderAdditive.get();
        boolean invert = (Boolean)YHModConfig.CLIENT.laserRenderInverted.get();
        int n = list.size() * 4;
        int count = 1;
        if (invert || !additive) {
            ++count;
        }
        BulkDataWriter vc = new BulkDataWriter(buffer.m_6299_(DanmakuRenderStates.laser(this.inner, DisplayType.TRANSPARENT)), n * count);
        for (Ins e : list) {
            e.texInner(vc, e.core);
        }
        if (invert || !additive) {
            for (Ins e : list) {
                e.texOuter(invert, vc, e.tran);
            }
        }
        vc.flush();
        if (additive) {
            vc = new BulkDataWriter(buffer.m_6299_(DanmakuRenderStates.laser(this.outer, DisplayType.ADDITIVE)), n);
            for (Ins e : list) {
                e.texOuter(false, vc, e.add);
            }
            vc.flush();
        }
    }

    @Override
    public void create(Consumer<Ins> holder, ProjectileRenderer<?> r, SimplifiedProjectile e, PoseStack pose, float pTick) {
        double fade = r.fading(e);
        double tran = fade * (Double)YHModConfig.CLIENT.laserTransparency.get();
        int core = (int)(fade * 255.0) << 24 | 0xFFFFFF;
        int outer = (int)(tran * 255.0) << 24 | this.color & 0xFFFFFF;
        int add = (int)((double)(this.color & 0xFF) * tran) | (int)((double)(this.color >> 8 & 0xFF) * tran) << 8 | (int)((double)(this.color >> 16 & 0xFF) * tran) << 16 | 0xFF000000;
        Cache data = Cache.vertex(pose.m_85850_().m_252922_());
        holder.accept(new Ins(data, core, outer, add));
    }

    public record Ins(Cache cache, int core, int tran, int add) {
        public void texInner(BulkDataWriter vc, int color) {
            this.renderPart(false, vc, color, this.cache.r0);
        }

        public void texOuter(boolean invert, BulkDataWriter vc, int color) {
            this.renderPart(invert, vc, color, this.cache.r1);
        }

        private void renderPart(boolean invert, BulkDataWriter vc, int color, float[][] arr) {
            this.renderConeStart(invert, vc, color, arr, 0, 12);
            this.renderCube(invert, vc, color, arr, 0);
            this.renderCube(invert, vc, color, arr, 4);
            this.renderConeEnd(invert, vc, color, arr, 8, 13);
        }

        private void renderCube(boolean invert, BulkDataWriter vc, int color, float[][] arr, int start) {
            int i0 = start;
            int i1 = start + 1;
            int i2 = start + 2;
            int i3 = start + 3;
            int i4 = start + 4;
            int i5 = start + 5;
            int i6 = start + 6;
            int i7 = start + 7;
            this.renderQuad(invert, vc, color, arr, i0, i2, i4, i6);
            this.renderQuad(invert, vc, color, arr, i3, i1, i7, i5);
            this.renderQuad(invert, vc, color, arr, i2, i3, i6, i7);
            this.renderQuad(invert, vc, color, arr, i1, i0, i5, i4);
        }

        private void renderConeStart(boolean invert, BulkDataWriter vc, int color, float[][] arr, int start, int vertex) {
            int v = vertex;
            int i4 = start;
            int i5 = start + 1;
            int i6 = start + 2;
            int i7 = start + 3;
            this.renderQuad(invert, vc, color, arr, v, v, i4, i6);
            this.renderQuad(invert, vc, color, arr, v, v, i7, i5);
            this.renderQuad(invert, vc, color, arr, v, v, i6, i7);
            this.renderQuad(invert, vc, color, arr, v, v, i5, i4);
        }

        private void renderConeEnd(boolean invert, BulkDataWriter vc, int color, float[][] arr, int start, int vertex) {
            int v = vertex;
            int i0 = start;
            int i1 = start + 1;
            int i2 = start + 2;
            int i3 = start + 3;
            this.renderQuad(invert, vc, color, arr, i0, i2, v, v);
            this.renderQuad(invert, vc, color, arr, i3, i1, v, v);
            this.renderQuad(invert, vc, color, arr, i2, i3, v, v);
            this.renderQuad(invert, vc, color, arr, i1, i0, v, v);
        }

        private void renderQuad(boolean invert, BulkDataWriter vc, int col, float[][] arr, int i0, int i1, int i2, int i3) {
            if (invert) {
                this.addVertex(vc, col, arr[i3], 0.0f, 0.0f);
                this.addVertex(vc, col, arr[i1], 0.0f, 1.0f);
                this.addVertex(vc, col, arr[i0], 1.0f, 1.0f);
                this.addVertex(vc, col, arr[i2], 1.0f, 0.0f);
            } else {
                this.addVertex(vc, col, arr[i2], 1.0f, 0.0f);
                this.addVertex(vc, col, arr[i0], 1.0f, 1.0f);
                this.addVertex(vc, col, arr[i1], 0.0f, 1.0f);
                this.addVertex(vc, col, arr[i3], 0.0f, 0.0f);
            }
        }

        private void addVertex(BulkDataWriter vc, int col, float[] arr, float u, float v) {
            vc.addVertex(arr[0], arr[1], arr[2], u, v, col);
        }
    }

    public record Cache(float[][] r0, float[][] r1) {
        private static Cache vertex(Matrix4f mat) {
            Vector4f p0 = new Vector4f(0.0f, 0.0f, 0.0f, 1.0f).mul((Matrix4fc)mat);
            Vector4f px = new Vector4f(1.0f, 0.0f, 0.0f, 0.0f).mul((Matrix4fc)mat);
            Vector4f py = new Vector4f(0.0f, 1.0f, 0.0f, 0.0f).mul((Matrix4fc)mat);
            Vector4f pz = new Vector4f(0.0f, 0.0f, 1.0f, 0.0f).mul((Matrix4fc)mat);
            Cache ans = new Cache(new float[14][3], new float[14][3]);
            Cache.fill(ans.r0, p0, px, py, pz, 0.16666667f, 0.125f, 0.25f, 0.5f);
            Cache.fill(ans.r1, p0, px, py, pz, 0.33333334f, 0.25f, 0.25f, 0.875f);
            return ans;
        }

        private static void fill(float[][] arr, Vector4f p0, Vector4f px, Vector4f py, Vector4f pz, float r0, float r1, float dy, float end) {
            Cache.fill(0, arr, p0, px, py, pz, r1, 0.5f - dy);
            Cache.fill(4, arr, p0, px, py, pz, r0, 0.5f);
            Cache.fill(8, arr, p0, px, py, pz, r1, 0.5f + dy);
            Cache.end(arr[12], p0, py, 0.5f - end);
            Cache.end(arr[13], p0, py, 0.5f + end);
        }

        private static void fill(int offset, float[][] arr, Vector4f p0, Vector4f px, Vector4f py, Vector4f pz, float r0, float dy) {
            Cache.calc(arr[offset], p0, px, pz, py, -r0, -r0, dy);
            Cache.calc(arr[offset + 1], p0, px, pz, py, r0, -r0, dy);
            Cache.calc(arr[offset + 2], p0, px, pz, py, -r0, r0, dy);
            Cache.calc(arr[offset + 3], p0, px, pz, py, r0, r0, dy);
        }

        private static void calc(float[] arr, Vector4f p0, Vector4f px, Vector4f pz, Vector4f py, float sx, float sz, float dy) {
            arr[0] = p0.x + px.x * sx + pz.x * sz + py.x * dy;
            arr[1] = p0.y + px.y * sx + pz.y * sz + py.y * dy;
            arr[2] = p0.z + px.z * sx + pz.z * sz + py.z * dy;
        }

        private static void end(float[] arr, Vector4f p0, Vector4f py, float dy) {
            arr[0] = p0.x + py.x * dy;
            arr[1] = p0.y + py.y * dy;
            arr[2] = p0.z + py.z * dy;
        }
    }
}

