/*
 * Decompiled with CFR 0.152.
 */
package net.azurune.runiclib.common.integration.recipe;

import com.google.gson.JsonObject;
import net.azurune.runiclib.common.integration.recipe.EmptyRecipe;
import net.azurune.runiclib.core.platform.Services;
import net.minecraft.core.registries.BuiltInRegistries;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.item.crafting.Recipe;
import net.minecraft.world.item.crafting.RecipeSerializer;

public class ModLoadedConditionRecipeSerializer<T extends Recipe<?>>
implements RecipeSerializer<T> {
    public T m_6729_(ResourceLocation id, JsonObject json) {
        if (json.has("modid") && !Services.PLATFORM.isModLoaded(json.get("modid").getAsString())) {
            return (T)new EmptyRecipe(id);
        }
        if (!json.has("wrapped_type")) {
            throw new IllegalArgumentException("Conditional recipe JSON is missing required 'wrapped_type' property");
        }
        ResourceLocation wrappedTypeId = new ResourceLocation(json.get("wrapped_type").getAsString());
        RecipeSerializer wrappedSerializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(wrappedTypeId);
        if (wrappedSerializer == null) {
            throw new IllegalArgumentException("Unknown wrapped_type serializer: " + wrappedTypeId);
        }
        JsonObject copy = json.deepCopy();
        copy.remove("type");
        copy.remove("modid");
        copy.remove("wrapped_type");
        return (T)wrappedSerializer.m_6729_(id, json.deepCopy());
    }

    public T m_8005_(ResourceLocation id, FriendlyByteBuf buf) {
        String readUtf = buf.m_130136_(Short.MAX_VALUE);
        ResourceLocation resourceLocation = new ResourceLocation(readUtf);
        if (BuiltInRegistries.f_256769_.m_7745_(resourceLocation) == null) {
            throw new IllegalStateException("Unknown wrapped_type serializer in network: " + resourceLocation);
        }
        RecipeSerializer wrappedSerializer = (RecipeSerializer)BuiltInRegistries.f_256769_.m_7745_(resourceLocation);
        return (T)wrappedSerializer.m_8005_(id, buf);
    }

    public void m_6178_(FriendlyByteBuf buf, T recipe) {
        if (BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_()) == null) {
            throw new IllegalStateException("Wrapped serializer not registered in registry: " + recipe.m_7707_());
        }
        buf.m_130070_(BuiltInRegistries.f_256769_.m_7981_((Object)recipe.m_7707_()).toString());
        recipe.m_7707_().m_6178_(buf, recipe);
    }
}

