/*
 * Decompiled with CFR 0.152.
 */
package com.spaceagle17.iris_shader_folder.mixin.legacy;

import com.spaceagle17.iris_shader_folder.IrisShaderFolder;
import com.spaceagle17.iris_shader_folder.ShaderRecolorSystem;
import com.spaceagle17.iris_shader_folder.ShaderTooltipSystem;
import java.lang.reflect.Constructor;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.lang.reflect.Modifier;
import org.spongepowered.asm.mixin.Debug;
import org.spongepowered.asm.mixin.Mixin;
import org.spongepowered.asm.mixin.Pseudo;
import org.spongepowered.asm.mixin.Unique;
import org.spongepowered.asm.mixin.injection.At;
import org.spongepowered.asm.mixin.injection.Inject;
import org.spongepowered.asm.mixin.injection.ModifyVariable;
import org.spongepowered.asm.mixin.injection.callback.CallbackInfo;

@Debug(export=true)
@Pseudo
@Mixin(targets={"net.coderbot.iris.gui.element.ShaderPackSelectionList$ShaderPackEntry"}, remap=false)
public class IrisLegacyShaderEntryMixin {
    @Unique
    private String currentShaderName;
    @Unique
    private String currentShaderNameRecolored;
    @Unique
    private boolean isCurrentlyHovered;
    @Unique
    private static boolean componentMethodInitialized = false;
    @Unique
    private static Method cachedComponentMethod = null;
    @Unique
    private static Class<?> cachedComponentClass = null;
    @Unique
    private static boolean useConstructor = false;
    @Unique
    private static Constructor<?> cachedConstructor = null;
    @Unique
    private static boolean commentMethodInitialized = false;
    @Unique
    private static Method cachedCommentMethod = null;

    @Inject(method={"<init>"}, at={@At(value="TAIL")})
    private void onInit(CallbackInfo ci) {
        System.out.println("IrisLegacyShaderEntryMixin: Constructor called - mixin is active!");
    }

    @ModifyVariable(method={"render", "renderContent", "method_25343", "m_6311_", "func_230432_a_"}, at=@At(value="STORE", ordinal=0), ordinal=0, name={"name"}, remap=false, require=0)
    private String modifyNameVariable(String name) {
        String recoloredName = ShaderRecolorSystem.getInstance().recolorShaderName(name);
        this.currentShaderName = name;
        this.currentShaderNameRecolored = recoloredName;
        return recoloredName;
    }

    @ModifyVariable(method={"render", "renderContent", "method_25343", "m_6311_", "func_230432_a_"}, at=@At(value="HEAD"), ordinal=0, name={"isHovered"}, remap=false, require=0)
    private boolean captureIsHovered(boolean isHovered) {
        this.isCurrentlyHovered = isHovered;
        return isHovered;
    }

    @Inject(method={"render", "renderContent", "method_25343", "m_6311_", "func_230432_a_"}, at={@At(value="TAIL")}, require=0)
    private void afterRenderText(CallbackInfo ci) {
        block6: {
            try {
                if (!this.isCurrentlyHovered || this.currentShaderName == null) {
                    return;
                }
                String tooltip = ShaderTooltipSystem.getInstance().getTooltip(this.currentShaderName);
                if (tooltip != null && !tooltip.isEmpty()) {
                    Field listField = this.getClass().getDeclaredField("list");
                    listField.setAccessible(true);
                    Object listObj = listField.get(this);
                    Field screenField = listObj.getClass().getDeclaredField("screen");
                    screenField.setAccessible(true);
                    Object screen = screenField.get(listObj);
                    Object[] components = this.irisShaderFolder$createTextComponents(this.currentShaderNameRecolored, tooltip);
                    if (components == null) {
                        return;
                    }
                    boolean success = this.irisShaderFolder$setShaderPackComment(screen, components[0], components[1]);
                    if (!success && IrisShaderFolder.debugLoggingEnabled) {
                        System.out.println("Could not find an appropriate method to set shader pack comment");
                    }
                }
            }
            catch (Exception e) {
                if (!IrisShaderFolder.debugLoggingEnabled) break block6;
                System.out.println("Error in shader tooltip handling: " + e.getMessage());
                e.printStackTrace();
            }
        }
    }

    /*
     * WARNING - void declaration
     */
    @Unique
    private Object[] irisShaderFolder$createTextComponents(String title, String body) {
        if (componentMethodInitialized && cachedComponentClass != null) {
            try {
                if (useConstructor && cachedConstructor != null) {
                    Object titleComponent = cachedConstructor.newInstance(title);
                    Object bodyComponent = cachedConstructor.newInstance(body);
                    return new Object[]{titleComponent, bodyComponent};
                }
                if (cachedComponentMethod != null) {
                    Object titleComponent = cachedComponentMethod.invoke(null, title);
                    Object bodyComponent = cachedComponentMethod.invoke(null, body);
                    return new Object[]{titleComponent, bodyComponent};
                }
            }
            catch (Exception ignored) {
                componentMethodInitialized = false;
            }
        }
        String[][] approaches = new String[][]{{"net.minecraft.class_2561", "method_43470"}, {"net.minecraft.network.chat.Component", "literal"}, {"net.minecraft.network.chat.Component", "m_237113_"}, {"net.minecraft.network.chat.Component", "m_130674_"}};
        String[] constructorClasses = new String[]{"net.minecraft.class_2585", "net.minecraft.network.chat.TextComponent", "net.minecraft.util.text.StringTextComponent"};
        for (String[] stringArray : approaches) {
            try {
                Class<?> componentClass = Class.forName(stringArray[0]);
                Method method = componentClass.getMethod(stringArray[1], String.class);
                Object titleComponent = method.invoke(null, title);
                Object bodyComponent = method.invoke(null, body);
                cachedComponentClass = componentClass;
                cachedComponentMethod = method;
                useConstructor = false;
                componentMethodInitialized = true;
                return new Object[]{titleComponent, bodyComponent};
            }
            catch (Exception componentClass) {
            }
        }
        for (String[] stringArray : constructorClasses) {
            try {
                Class<?> componentClass = Class.forName((String)stringArray);
                Constructor<?> constructor = componentClass.getConstructor(String.class);
                Object titleComponent = constructor.newInstance(title);
                Object bodyComponent = constructor.newInstance(body);
                cachedComponentClass = componentClass;
                cachedConstructor = constructor;
                useConstructor = true;
                componentMethodInitialized = true;
                return new Object[]{titleComponent, bodyComponent};
            }
            catch (Exception componentClass) {
            }
        }
        try {
            void var8_19;
            Class<?> componentClass = null;
            Object[] objectArray = new String[]{"net.minecraft.network.chat.Component", "net.minecraft.text.Text", "net.minecraft.class_2561"};
            int n = objectArray.length;
            boolean bl = false;
            while (var8_19 < n) {
                String className = objectArray[var8_19];
                try {
                    componentClass = Class.forName(className);
                    break;
                }
                catch (ClassNotFoundException constructor) {
                    ++var8_19;
                }
            }
            if (componentClass != null) {
                void var8_21;
                objectArray = componentClass.getMethods();
                n = objectArray.length;
                boolean bl2 = false;
                while (var8_21 < n) {
                    Object m = objectArray[var8_21];
                    if (((Method)m).getParameterCount() == 1 && ((Method)m).getParameterTypes()[0] == String.class && Modifier.isStatic(((Method)m).getModifiers())) {
                        try {
                            Object titleComponent = ((Method)m).invoke(null, title);
                            Object bodyComponent = ((Method)m).invoke(null, body);
                            return new Object[]{titleComponent, bodyComponent};
                        }
                        catch (Exception exception) {
                            // empty catch block
                        }
                    }
                    ++var8_21;
                }
            }
        }
        catch (Exception exception) {
            // empty catch block
        }
        if (IrisShaderFolder.debugLoggingEnabled) {
            System.out.println("Failed to create text components - cannot set shader pack comment");
        }
        return null;
    }

    @Unique
    private boolean irisShaderFolder$setShaderPackComment(Object screen, Object title, Object body) {
        if (commentMethodInitialized && cachedCommentMethod != null) {
            try {
                cachedCommentMethod.invoke(screen, title, body);
                return true;
            }
            catch (Exception ignored) {
                commentMethodInitialized = false;
            }
        }
        try {
            Method method = screen.getClass().getDeclaredMethod("setShaderPackComment", title.getClass(), body.getClass());
            method.setAccessible(true);
            method.invoke(screen, title, body);
            cachedCommentMethod = method;
            commentMethodInitialized = true;
            return true;
        }
        catch (Exception ignored) {
            try {
                for (Method method : screen.getClass().getDeclaredMethods()) {
                    Class<?>[] paramTypes;
                    if (method.getParameterCount() != 2 || !(paramTypes = method.getParameterTypes())[0].getSimpleName().contains("Component") && !paramTypes[0].getName().contains("chat") && !paramTypes[0].getName().contains("text")) continue;
                    method.setAccessible(true);
                    try {
                        method.invoke(screen, title, body);
                        cachedCommentMethod = method;
                        commentMethodInitialized = true;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
                for (Method method : screen.getClass().getDeclaredMethods()) {
                    if (method.getParameterCount() != 2) continue;
                    method.setAccessible(true);
                    try {
                        method.invoke(screen, title, body);
                        cachedCommentMethod = method;
                        commentMethodInitialized = true;
                        return true;
                    }
                    catch (Exception exception) {
                        // empty catch block
                    }
                }
            }
            catch (Exception exception) {
                // empty catch block
            }
            return false;
        }
    }
}

