/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.utils;

import java.text.DecimalFormat;

public class EnergyFormattingUtil {
    private static final DecimalFormat COMPACT_FORMAT = new DecimalFormat("#.##");
    private static final String[] SUFFIXES = new String[]{"", "k", "M", "G"};

    public static String formatExtended(long number) {
        return String.format("%,d", number).replace(".", ",");
    }

    public static String formatCompact(long number) {
        if (number < 1000L) {
            return String.valueOf(number);
        }
        int exp = (int)(Math.log10(number) / 3.0);
        if (exp >= SUFFIXES.length) {
            exp = SUFFIXES.length - 1;
        }
        double value = (double)number / Math.pow(1000.0, exp);
        return COMPACT_FORMAT.format(value).replace(".", ",") + SUFFIXES[exp];
    }
}

