/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.rei;

import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.rei.IGui2Renderer;
import com.lowdragmc.lowdraglib.rei.ModularDisplay;
import com.lowdragmc.lowdraglib.rei.ModularUIDisplayCategory;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import java.util.Optional;
import java.util.function.Function;
import javax.annotation.Nonnull;
import me.shedaniel.rei.api.client.gui.Renderer;
import me.shedaniel.rei.api.client.registry.category.CategoryRegistry;
import me.shedaniel.rei.api.client.registry.display.DisplayRegistry;
import me.shedaniel.rei.api.common.category.CategoryIdentifier;
import me.shedaniel.rei.api.common.entry.EntryStack;
import me.shedaniel.rei.api.common.entry.type.EntryType;
import me.shedaniel.rei.api.common.entry.type.VanillaEntryTypes;
import net.minecraft.Util;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;

public class MBDRecipeTypeDisplayCategory
extends ModularUIDisplayCategory<MBDRecipeDisplay> {
    public static final Function<MBDRecipeType, CategoryIdentifier<MBDRecipeDisplay>> CATEGORIES = Util.m_143827_(recipeType -> CategoryIdentifier.of((ResourceLocation)recipeType.getRegistryName()));
    private final MBDRecipeType recipeType;
    private final Renderer icon;
    private final Size size;

    public MBDRecipeTypeDisplayCategory(MBDRecipeType recipeType) {
        this.recipeType = recipeType;
        Size size = recipeType.getUiSize();
        this.size = new Size(size.width + 8, size.height + 8);
        this.icon = IGui2Renderer.toDrawable((IGuiTexture)recipeType.getIcon());
    }

    public CategoryIdentifier<? extends MBDRecipeDisplay> getCategoryIdentifier() {
        return CATEGORIES.apply(this.recipeType);
    }

    public int getDisplayHeight() {
        return this.getSize().height;
    }

    public int getDisplayWidth(MBDRecipeDisplay display) {
        return this.getSize().width;
    }

    @Nonnull
    public Component getTitle() {
        return Component.m_237115_((String)this.recipeType.getRegistryName().m_214298_());
    }

    public static void registerDisplays(DisplayRegistry registry) {
        for (MBDRecipeType recipeType : MBDRegistries.RECIPE_TYPES) {
            if (!recipeType.isXEIVisible()) continue;
            registry.registerRecipeFiller(MBDRecipe.class, rt -> rt == recipeType, recipe -> !recipe.isFuel && !recipe.isXEIHidden, MBDRecipeDisplay::new);
        }
    }

    public static void registerWorkStations(CategoryRegistry registry) {
        for (MBDRecipeType mbdRecipeType : MBDRegistries.RECIPE_TYPES) {
            if (!mbdRecipeType.isXEIVisible()) continue;
            for (MBDMachineDefinition definition : MBDRegistries.MACHINE_DEFINITIONS) {
                MBDRecipeType recipeType = definition.recipeLogicSettings().getRecipeType();
                if (recipeType != mbdRecipeType) continue;
                registry.addWorkstations(CATEGORIES.apply(mbdRecipeType), new EntryStack[]{EntryStack.of((EntryType)VanillaEntryTypes.ITEM, (Object)definition.item().m_7968_())});
            }
        }
    }

    public Renderer getIcon() {
        return this.icon;
    }

    public Size getSize() {
        return this.size;
    }

    public static class MBDRecipeDisplay
    extends ModularDisplay<Widget> {
        private final MBDRecipe recipe;

        public MBDRecipeDisplay(MBDRecipe recipe) {
            super(() -> recipe.recipeType.createRecipeUI(recipe), CATEGORIES.apply(recipe.recipeType));
            this.recipe = recipe;
        }

        public Optional<ResourceLocation> getDisplayLocation() {
            return Optional.of(this.recipe.id);
        }
    }
}

