/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure;

import com.google.common.collect.Table;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCPressureAirRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.pressure.PNCPressureAirHandlerTrait;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;

public class PNCPressureCondition
extends RecipeCondition {
    public static final PNCPressureCondition INSTANCE = new PNCPressureCondition();
    @Configurable(name="config.recipe.condition.is_air", tips={"recipe.capability.pneumatic_pressure_air.type.tooltip"})
    private boolean isAir;
    @Configurable(name="config.recipe.condition.pressure.min")
    @NumberRange(range={1.0, 3.4028234663852886E38})
    private float minPressure;
    @Configurable(name="config.recipe.condition.pressure.max")
    @NumberRange(range={1.0, 3.4028234663852886E38})
    private float maxPressure;

    public PNCPressureCondition(boolean isAir, float minPressure, float maxPressure) {
        this.isAir = isAir;
        this.minPressure = minPressure;
        this.maxPressure = maxPressure;
    }

    @Override
    public String getType() {
        return "pneumatic_pressure";
    }

    @Override
    public Component getTooltips() {
        return this.isAir ? Component.m_237110_((String)"recipe.condition.pneumatic_pressure.air.tooltip", (Object[])new Object[]{Float.valueOf(this.minPressure), Float.valueOf(this.maxPressure)}) : Component.m_237110_((String)"recipe.condition.pneumatic_pressure.pressure.tooltip", (Object[])new Object[]{Float.valueOf(this.minPressure), Float.valueOf(this.maxPressure)});
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{(Item)ModItems.PRESSURE_GAUGE.get()});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> proxy = recipeLogic.machine.getRecipeCapabilitiesProxy();
        ArrayList toCheck = new ArrayList();
        if (recipe.inputs.containsKey(PNCPressureAirRecipeCapability.CAP) && proxy.contains((Object)IO.IN, (Object)PNCPressureAirRecipeCapability.CAP)) {
            List inputs = (List)proxy.get((Object)IO.IN, (Object)PNCPressureAirRecipeCapability.CAP);
            toCheck.addAll(inputs);
        }
        if (recipe.outputs.containsKey(PNCPressureAirRecipeCapability.CAP) && proxy.contains((Object)IO.OUT, (Object)PNCPressureAirRecipeCapability.CAP)) {
            List outputs = (List)proxy.get((Object)IO.OUT, (Object)PNCPressureAirRecipeCapability.CAP);
            toCheck.addAll(outputs);
        }
        if (proxy.contains((Object)IO.BOTH, (Object)PNCPressureAirRecipeCapability.CAP)) {
            toCheck.addAll((Collection)proxy.get((Object)IO.BOTH, (Object)PNCPressureAirRecipeCapability.CAP));
        }
        for (IRecipeHandler handler : toCheck) {
            if (!(handler instanceof PNCPressureAirHandlerTrait)) continue;
            PNCPressureAirHandlerTrait trait = (PNCPressureAirHandlerTrait)handler;
            if (this.isAir) {
                int air = trait.getHandler().getAir();
                return (float)air >= this.minPressure && (float)air <= this.maxPressure;
            }
            float pressure = trait.getHandler().getPressure();
            return pressure >= this.minPressure && pressure <= this.maxPressure;
        }
        return false;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("isAir", Boolean.valueOf(this.isAir));
        config.addProperty("minPressure", (Number)Float.valueOf(this.minPressure));
        config.addProperty("maxPressure", (Number)Float.valueOf(this.maxPressure));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.isAir = config.getAsJsonPrimitive("isAir").getAsBoolean();
        this.minPressure = GsonHelper.m_13820_((JsonObject)config, (String)"minPressure", (float)0.0f);
        this.maxPressure = GsonHelper.m_13820_((JsonObject)config, (String)"maxPressure", (float)1.0f);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.isAir = buf.readBoolean();
        this.minPressure = buf.readFloat();
        this.maxPressure = buf.readFloat();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeBoolean(this.isAir);
        buf.writeFloat(this.minPressure);
        buf.writeFloat(this.maxPressure);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128379_("isAir", this.isAir);
        tag.m_128350_("minPressure", this.minPressure);
        tag.m_128350_("maxPressure", this.maxPressure);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.isAir = tag.m_128471_("isAir");
        this.minPressure = tag.m_128457_("minPressure");
        this.maxPressure = tag.m_128457_("maxPressure");
        return this;
    }

    public boolean isAir() {
        return this.isAir;
    }

    public float getMinPressure() {
        return this.minPressure;
    }

    public float getMaxPressure() {
        return this.maxPressure;
    }

    public PNCPressureCondition() {
    }
}

