/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat;

import com.google.common.collect.Table;
import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandler;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PNCHeatRecipeCapability;
import com.lowdragmc.mbd2.integration.pneumaticcraft.trait.heat.PNCHeatExchangerTrait;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import javax.annotation.Nonnull;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.item.Item;

public class PNCTemperatureCondition
extends RecipeCondition {
    public static final PNCTemperatureCondition INSTANCE = new PNCTemperatureCondition();
    @Configurable(name="config.recipe.condition.temperature.min")
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    private float minTemperature;
    @Configurable(name="config.recipe.condition.temperature.max")
    @NumberRange(range={-3.4028234663852886E38, 3.4028234663852886E38})
    private float maxTemperature;

    public PNCTemperatureCondition(float minTemperature, float maxTemperature) {
        this.minTemperature = minTemperature;
        this.maxTemperature = maxTemperature;
    }

    @Override
    public String getType() {
        return "pneumatic_temperature";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.pneumatic_temperature.tooltip", (Object[])new Object[]{Float.valueOf(this.minTemperature), Float.valueOf(this.maxTemperature)});
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{(Item)ModItems.HEAT_FRAME.get()});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Table<IO, RecipeCapability<?>, List<IRecipeHandler<?>>> proxy = recipeLogic.machine.getRecipeCapabilitiesProxy();
        ArrayList toCheck = new ArrayList();
        if (recipe.inputs.containsKey(PNCHeatRecipeCapability.CAP) && proxy.contains((Object)IO.IN, (Object)PNCHeatRecipeCapability.CAP)) {
            List inputs = (List)proxy.get((Object)IO.IN, (Object)PNCHeatRecipeCapability.CAP);
            toCheck.addAll(inputs);
        }
        if (recipe.outputs.containsKey(PNCHeatRecipeCapability.CAP) && proxy.contains((Object)IO.OUT, (Object)PNCHeatRecipeCapability.CAP)) {
            List outputs = (List)proxy.get((Object)IO.OUT, (Object)PNCHeatRecipeCapability.CAP);
            toCheck.addAll(outputs);
        }
        if (proxy.contains((Object)IO.BOTH, (Object)PNCHeatRecipeCapability.CAP)) {
            toCheck.addAll((Collection)proxy.get((Object)IO.BOTH, (Object)PNCHeatRecipeCapability.CAP));
        }
        for (IRecipeHandler handler : toCheck) {
            if (!(handler instanceof PNCHeatExchangerTrait.HeatRecipeHandler)) continue;
            PNCHeatExchangerTrait.HeatRecipeHandler heatRecipeHandler = (PNCHeatExchangerTrait.HeatRecipeHandler)handler;
            double temp = ((PNCHeatExchangerTrait)heatRecipeHandler.trait).getHandler().getTemperature() - 273.0;
            if (!(temp >= (double)this.minTemperature) || !(temp <= (double)this.maxTemperature)) continue;
            return true;
        }
        return false;
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("minTemperature", (Number)Float.valueOf(this.minTemperature));
        config.addProperty("maxTemperature", (Number)Float.valueOf(this.maxTemperature));
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.minTemperature = GsonHelper.m_13820_((JsonObject)config, (String)"minTemperature", (float)0.0f);
        this.maxTemperature = GsonHelper.m_13820_((JsonObject)config, (String)"maxTemperature", (float)1.0f);
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.minTemperature = buf.readFloat();
        this.maxTemperature = buf.readFloat();
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.writeFloat(this.minTemperature);
        buf.writeFloat(this.maxTemperature);
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128350_("minTemperature", this.minTemperature);
        tag.m_128350_("maxTemperature", this.maxTemperature);
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.minTemperature = tag.m_128457_("minTemperature");
        this.maxTemperature = tag.m_128457_("maxTemperature");
        return this;
    }

    public float getMinTemperature() {
        return this.minTemperature;
    }

    public float getMaxTemperature() {
        return this.maxTemperature;
    }

    public PNCTemperatureCondition() {
    }
}

