/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.pneumaticcraft;

import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SelectorConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.common.gui.recipe.CornerNumberWidget;
import com.lowdragmc.mbd2.integration.pneumaticcraft.PressureAir;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import me.desht.pneumaticcraft.common.core.ModItems;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class PNCPressureAirRecipeCapability
extends RecipeCapability<PressureAir> {
    public static final PNCPressureAirRecipeCapability CAP = new PNCPressureAirRecipeCapability();
    public static final ResourceBorderTexture HUD_BACKGROUND = new ResourceBorderTexture("mbd2:textures/gui/progress_bar_boiler_empty_steel.png", 54, 10, 1, 1);
    public static final ResourceTexture HUD_BAR = new ResourceTexture("mbd2:textures/gui/pressure_air.png");

    protected PNCPressureAirRecipeCapability() {
        super("pneumatic_pressure_air", PressureAir.SerializerPressureAir.INSTANCE);
    }

    @Override
    public PressureAir createDefaultContent() {
        return new PressureAir(false, 100.0f);
    }

    @Override
    public Widget createPreviewWidget(PressureAir content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        previewGroup.addWidget((Widget)new ImageWidget(1, 1, 16, 16, (IGuiTexture)new ItemStackTexture(new Item[]{(Item)ModItems.PRESSURE_GAUGE.get()})));
        previewGroup.addWidget((Widget)new CornerNumberWidget(0, 0, 18, 18).setValue((long)content.value()));
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 15, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)HUD_BAR.copy()));
        energyBar.setBackground(new IGuiTexture[]{HUD_BACKGROUND});
        energyBar.setOverlay((IGuiTexture)new TextTexture("0 pressure"));
        return energyBar;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof ProgressWidget) {
            ProgressWidget energyBar = (ProgressWidget)widget;
            PressureAir pressureAir = (PressureAir)this.of(content.content);
            String unit = LocalizationUtils.format((String)(pressureAir.isAir() ? "recipe.capability.pneumatic_pressure_air.type.air" : "recipe.capability.pneumatic_pressure_air.type.pressure"), (Object[])new Object[0]);
            IGuiTexture iGuiTexture = energyBar.getOverlay();
            if (iGuiTexture instanceof TextTexture) {
                TextTexture textTexture = (TextTexture)iGuiTexture;
                if (content.perTick) {
                    textTexture.updateText(pressureAir.value() + " " + unit + "/t");
                } else {
                    textTexture.updateText(pressureAir.value() + " " + unit);
                }
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<PressureAir> supplier, Consumer<PressureAir> onUpdate) {
        SelectorConfigurator type = new SelectorConfigurator("recipe.capability.pneumatic_pressure_air.type", () -> ((PressureAir)supplier.get()).isAir(), isAir -> onUpdate.accept(new PressureAir((boolean)isAir, ((PressureAir)supplier.get()).value())), (Object)false, true, List.of(Boolean.valueOf(true), Boolean.valueOf(false)), isAir -> isAir != false ? "recipe.capability.pneumatic_pressure_air.type.air" : "recipe.capability.pneumatic_pressure_air.type.pressure");
        type.setTips(new String[]{"recipe.capability.pneumatic_pressure_air.type.tooltip"});
        father.addConfigurators(new Configurator[]{type, new NumberConfigurator("recipe.capability.pneumatic_pressure_air.value", () -> Float.valueOf(((PressureAir)supplier.get()).value()), number -> onUpdate.accept(new PressureAir(((PressureAir)supplier.get()).isAir(), number.floatValue())), (Number)1, true).setRange((Number)1, (Number)Float.valueOf(Float.MAX_VALUE))});
    }

    @Override
    public Component getLeftErrorInfo(List<PressureAir> left) {
        float airValue = 0.0f;
        float pressureValue = 0.0f;
        for (PressureAir pressureAir : left) {
            if (pressureAir.isAir()) {
                airValue += pressureAir.value();
                continue;
            }
            pressureValue += pressureAir.value();
        }
        return Component.m_237113_((String)"[").m_7220_((Component)Component.m_237115_((String)"recipe.capability.pneumatic_pressure_air.type.air")).m_7220_((Component)Component.m_237113_((String)(": " + airValue + "], ["))).m_7220_((Component)Component.m_237115_((String)"recipe.capability.pneumatic_pressure_air.type.pressure")).m_7220_((Component)Component.m_237113_((String)(": " + pressureValue + "]")));
    }
}

