/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.photon;

import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.photon.client.fx.FX;
import com.lowdragmc.photon.client.fx.FXEffect;
import com.lowdragmc.photon.client.fx.IEffect;
import com.lowdragmc.photon.client.gameobject.IFXObject;
import java.util.Map;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.BlockGetter;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Vector3f;

@OnlyIn(value=Dist.CLIENT)
public class MachineFX
extends FXEffect {
    public final String identifier;
    public final MBDMachine machine;
    public boolean replaceExisting = false;

    public MachineFX(FX fx, String identifier, MBDMachine machine) {
        super(fx, machine.getLevel());
        this.identifier = identifier;
        this.machine = machine;
    }

    public void kill(boolean forcedDeath) {
        if (this.runtime != null) {
            this.runtime.destroy(forcedDeath);
        }
    }

    public void start() {
        this.runtime = this.fx.createRuntime();
        IFXObject root = this.runtime.getRoot();
        Map<String, Object> fxs = this.machine.getPhotonFXs();
        Object previous = fxs.get(this.identifier);
        if (previous instanceof MachineFX) {
            MachineFX machineFX = (MachineFX)((Object)previous);
            if (this.replaceExisting || machineFX.runtime == null || !machineFX.runtime.isAlive()) {
                machineFX.kill(machineFX.forcedDeath);
            } else {
                return;
            }
        }
        fxs.put(this.identifier, (Object)this);
        BlockPos pos = this.machine.getPos();
        root.updatePos(new Vector3f((float)pos.m_123341_(), (float)pos.m_123342_(), (float)pos.m_123343_()).add(this.offset.x + 0.5f, this.offset.y + 0.5f, this.offset.z + 0.5f));
        root.updateRotation(this.rotation);
        root.updateScale(this.scale);
        this.runtime.emmit((IEffect)this);
    }

    public void updateFXObjectTick(IFXObject fxObject) {
        BlockPos pos = this.machine.getPos();
        if (this.runtime != null && !this.level.m_46749_(pos) || this.machine.getPhotonFXs().get(this.identifier) != this || this.machine.isInValid() || IMachine.ofMachine((BlockGetter)this.level, pos).stream().noneMatch(m -> m == this.machine)) {
            this.runtime.destroy(this.forcedDeath);
        }
    }

    public void setReplaceExisting(boolean replaceExisting) {
        this.replaceExisting = replaceExisting;
    }
}

