/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.naturesaura.trait;

import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTrait;
import com.lowdragmc.mbd2.integration.naturesaura.NaturesAuraRecipeCapability;
import com.lowdragmc.mbd2.integration.naturesaura.trait.AuraHandlerTraitDefinition;
import de.ellpeck.naturesaura.api.aura.chunk.IAuraChunk;
import java.util.List;
import net.minecraft.core.BlockPos;
import net.minecraft.world.level.Level;
import org.jetbrains.annotations.Nullable;

public class AuraHandlerTrait
extends RecipeCapabilityTrait
implements IRecipeHandlerTrait<Integer> {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(AuraHandlerTrait.class);

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public AuraHandlerTrait(MBDMachine machine, AuraHandlerTraitDefinition definition) {
        super(machine, definition);
    }

    @Override
    public AuraHandlerTraitDefinition getDefinition() {
        return (AuraHandlerTraitDefinition)super.getDefinition();
    }

    @Override
    public List<Integer> handleRecipeInner(IO io, MBDRecipe recipe, List<Integer> left, @Nullable String slotName, boolean simulate) {
        if (!this.compatibleWith(io)) {
            return left;
        }
        if (simulate) {
            return null;
        }
        Level world = this.getMachine().getLevel();
        BlockPos pos = this.getMachine().getPos();
        int sum = left.stream().reduce(0, Integer::sum);
        if (io == IO.IN) {
            BlockPos spot = IAuraChunk.getHighestSpot((Level)world, (BlockPos)pos, (int)this.getDefinition().getRadius(), (BlockPos)pos);
            int drained = IAuraChunk.getAuraChunk((Level)world, (BlockPos)spot).drainAura(spot, sum);
            sum -= drained;
        } else if (io == IO.OUT) {
            BlockPos spot = IAuraChunk.getLowestSpot((Level)world, (BlockPos)pos, (int)this.getDefinition().getRadius(), (BlockPos)pos);
            int stored = IAuraChunk.getAuraChunk((Level)world, (BlockPos)spot).storeAura(spot, sum);
            sum -= stored;
        }
        return sum > 0 ? List.of(Integer.valueOf(sum)) : null;
    }

    @Override
    public RecipeCapability<Integer> getRecipeCapability() {
        return NaturesAuraRecipeCapability.CAP;
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this);
    }
}

