/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.naturesaura;

import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerInteger;
import com.lowdragmc.mbd2.common.gui.recipe.CornerNumberWidget;
import de.ellpeck.naturesaura.blocks.ModBlocks;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;

public class NaturesAuraRecipeCapability
extends RecipeCapability<Integer> {
    public static final NaturesAuraRecipeCapability CAP = new NaturesAuraRecipeCapability();

    protected NaturesAuraRecipeCapability() {
        super("natures_aura", SerializerInteger.INSTANCE);
    }

    @Override
    public Integer createDefaultContent() {
        return 512;
    }

    @Override
    public Widget createPreviewWidget(Integer content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        previewGroup.addWidget((Widget)new ImageWidget(1, 1, 16, 16, (IGuiTexture)new ItemStackTexture(new Item[]{ModBlocks.NATURE_ALTAR.m_5456_()})));
        previewGroup.addWidget((Widget)new CornerNumberWidget(0, 0, 18, 18).setValue(content.intValue()));
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        return new TextTextureWidget(0, 0, 100, 10, LocalizationUtils.format((String)"recipe.capability.natures_aura.aura", (Object[])new Object[]{0})).textureStyle(t -> t.setType(TextTexture.TextType.LEFT));
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof TextTextureWidget) {
            TextTextureWidget textTexture = (TextTextureWidget)widget;
            Integer aura = (Integer)this.of(content.content);
            if (content.perTick) {
                textTexture.setText(LocalizationUtils.format((String)"recipe.capability.natures_aura.aura", (Object[])new Object[]{aura}) + "/t");
            } else {
                textTexture.setText(LocalizationUtils.format((String)"recipe.capability.natures_aura.aura", (Object[])new Object[]{aura}));
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<Integer> supplier, Consumer<Integer> onUpdate) {
        Configurator[] configuratorArray = new Configurator[1];
        configuratorArray[0] = new NumberConfigurator("recipe.capability.natures_aura.aura_name", supplier::get, number -> onUpdate.accept(number.intValue()), (Number)1, true).setRange((Number)1, (Number)Integer.MAX_VALUE);
        father.addConfigurators(configuratorArray);
    }

    @Override
    public Component getLeftErrorInfo(List<Integer> left) {
        return Component.m_237113_((String)(left.stream().mapToInt(Integer::intValue).sum() + " aura"));
    }
}

