/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism.trait.chemical;

import com.lowdragmc.lowdraglib.client.model.ModelFactory;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.mbd2.api.capability.MBDCapabilities;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.FancyRendererSettings;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalTankCapabilityTrait;
import com.lowdragmc.mbd2.integration.mekanism.trait.chemical.ChemicalTankCapabilityTraitDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.VertexConsumer;
import java.util.Optional;
import mekanism.api.chemical.ChemicalStack;
import mekanism.client.render.MekanismRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.Sheets;
import net.minecraft.client.renderer.texture.MissingTextureAtlasSprite;
import net.minecraft.client.renderer.texture.TextureAtlas;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.core.Direction;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.joml.Quaternionf;

public class ChemicalFancyRendererSettings
extends FancyRendererSettings {
    private final ChemicalTankCapabilityTraitDefinition<?, ?> definition;
    @Configurable(name="config.definition.trait.fancy_renderer.percent_height", tips={"config.definition.trait.fancy_renderer.percent_height.tooltip"})
    private boolean percentHeight = false;

    public ChemicalFancyRendererSettings(ChemicalTankCapabilityTraitDefinition<?, ?> definition) {
        this.definition = definition;
    }

    @Override
    public IRenderer createFancyRenderer() {
        return new Renderer();
    }

    public boolean isPercentHeight() {
        return this.percentHeight;
    }

    public void setPercentHeight(boolean percentHeight) {
        this.percentHeight = percentHeight;
    }

    private class Renderer
    implements IRenderer {
        private Renderer() {
        }

        @OnlyIn(value=Dist.CLIENT)
        public boolean hasTESR(BlockEntity blockEntity) {
            return true;
        }

        @OnlyIn(value=Dist.CLIENT)
        public void render(BlockEntity blockEntity, float partialTicks, PoseStack poseStack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
            MBDMachine machine;
            ITrait iTrait;
            Object t;
            Optional optional = blockEntity.getCapability(MBDCapabilities.CAPABILITY_MACHINE).resolve();
            if (optional.isPresent() && (t = optional.get()) instanceof MBDMachine && (iTrait = (machine = (MBDMachine)t).getTraitByDefinition(ChemicalFancyRendererSettings.this.definition)) instanceof ChemicalTankCapabilityTrait) {
                ChemicalTankCapabilityTrait trait = (ChemicalTankCapabilityTrait)iTrait;
                ChemicalStack stack = trait.storages[0].getStack();
                if (stack.isEmpty() || trait.storages[0].getCapacity() == 0L) {
                    return;
                }
                TextureAtlasSprite chemicalTexture = MekanismRenderer.getSprite((ResourceLocation)stack.getType().getIcon());
                if (chemicalTexture == null) {
                    chemicalTexture = (TextureAtlasSprite)Minecraft.m_91087_().m_91258_(TextureAtlas.f_118259_).apply(MissingTextureAtlasSprite.m_118071_());
                }
                poseStack.m_85836_();
                if (ChemicalFancyRendererSettings.this.rotateOrientation) {
                    poseStack.m_85837_(0.5, 0.5, 0.5);
                    poseStack.m_252781_(ModelFactory.getQuaternion((Direction)machine.getFrontFacing().orElse(Direction.NORTH)));
                    poseStack.m_85837_(-0.5, -0.5, -0.5);
                }
                poseStack.m_252880_(((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).position.x, ((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).position.y, ((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).position.z);
                poseStack.m_85837_(0.5, 0.5, 0.5);
                poseStack.m_252781_(new Quaternionf().rotateXYZ((float)Math.toRadians(((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).rotation.x), (float)Math.toRadians(((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).rotation.y), (float)Math.toRadians(((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).rotation.z)));
                poseStack.m_85841_(((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).scale.x, ((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).scale.y, ((ChemicalFancyRendererSettings)ChemicalFancyRendererSettings.this).scale.z);
                poseStack.m_85837_(-0.5, -0.5, -0.5);
                int color = stack.getType().getTint() | 0xFF000000;
                VertexConsumer builder = buffer.m_6299_(Sheets.m_110792_());
                RenderBufferUtils.renderCubeFace((PoseStack)poseStack, (VertexConsumer)builder, (float)0.0f, (float)0.0f, (float)0.0f, (float)1.0f, (float)(ChemicalFancyRendererSettings.this.percentHeight ? (float)stack.getAmount() * 1.0f / (float)trait.storages[0].getCapacity() : 1.0f), (float)1.0f, (int)color, (int)combinedLight, (TextureAtlasSprite)chemicalTexture);
                poseStack.m_85849_();
            }
        }
    }
}

