/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.mekanism;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.configurator.WrapperConfigurator;
import com.lowdragmc.lowdraglib.gui.ingredient.IRecipeIngredientSlot;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.util.DrawerHelper;
import com.lowdragmc.lowdraglib.gui.util.TextFormattingUtil;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.jei.ClickableIngredient;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.jei.JEIPlugin;
import com.lowdragmc.lowdraglib.side.fluid.FluidHelper;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.lowdraglib.utils.Position;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.integration.mekanism.MekanismChemicalRecipeCapability;
import com.mojang.blaze3d.systems.RenderSystem;
import dev.emi.emi.jemi.JemiStack;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Optional;
import java.util.function.BiConsumer;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import mekanism.api.Action;
import mekanism.api.chemical.Chemical;
import mekanism.api.chemical.ChemicalStack;
import mekanism.api.chemical.ChemicalTankBuilder;
import mekanism.api.chemical.ChemicalType;
import mekanism.api.chemical.IChemicalHandler;
import mekanism.api.chemical.IChemicalTank;
import mekanism.api.chemical.gas.GasStack;
import mekanism.api.chemical.gas.IGasHandler;
import mekanism.api.chemical.infuse.IInfusionHandler;
import mekanism.api.chemical.infuse.InfuseType;
import mekanism.api.chemical.infuse.InfusionStack;
import mekanism.api.chemical.pigment.IPigmentHandler;
import mekanism.api.chemical.pigment.PigmentStack;
import mekanism.api.chemical.slurry.ISlurryHandler;
import mekanism.api.chemical.slurry.SlurryStack;
import mekanism.api.math.MathUtils;
import mekanism.client.gui.GuiUtils;
import mekanism.client.render.MekanismRenderer;
import mekanism.common.capabilities.Capabilities;
import mezz.jei.api.ingredients.IIngredientHelper;
import mezz.jei.api.ingredients.IIngredientRenderer;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.sounds.SoundEvent;
import net.minecraft.sounds.SoundSource;
import net.minecraft.world.entity.player.Player;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.common.capabilities.Capability;

public abstract class ChemicalTankWidget<CHEMICAL extends Chemical<CHEMICAL>, STACK extends ChemicalStack<CHEMICAL>>
extends Widget
implements IRecipeIngredientSlot,
IConfigurableWidget {
    public static final ResourceBorderTexture FLUID_SLOT_TEXTURE = new ResourceBorderTexture("ldlib:textures/gui/fluid_slot.png", 18, 18, 1, 1);
    @Nullable
    protected IChemicalHandler<CHEMICAL, STACK> chemicalHandler;
    protected int tank;
    @Configurable(name="ldlib.gui.editor.name.showAmount")
    protected boolean showAmount;
    @Configurable(name="ldlib.gui.editor.name.allowClickFilled")
    protected boolean allowClickFilled;
    @Configurable(name="ldlib.gui.editor.name.allowClickDrained")
    protected boolean allowClickDrained;
    @Configurable(name="ldlib.gui.editor.name.drawHoverOverlay")
    public boolean drawHoverOverlay = true;
    @Configurable(name="ldlib.gui.editor.name.drawHoverTips")
    protected boolean drawHoverTips;
    @Configurable(name="ldlib.gui.editor.name.fillDirection")
    protected ProgressTexture.FillDirection fillDirection = ProgressTexture.FillDirection.ALWAYS_FULL;
    protected BiConsumer<ChemicalTankWidget<CHEMICAL, STACK>, List<Component>> onAddedTooltips;
    protected IngredientIO ingredientIO = IngredientIO.RENDER_ONLY;
    protected float XEIChance = 1.0f;
    protected ChemicalStack<CHEMICAL> lastChemicalInTank;
    protected long lastTankCapacity;
    protected Runnable changeListener;

    public ChemicalTankWidget() {
        this(null, 0, 0, true, true);
    }

    public ChemicalTankWidget(@Nullable IChemicalHandler<CHEMICAL, STACK> chemicalHandler, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(chemicalHandler, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public ChemicalTankWidget(@Nullable IChemicalHandler<CHEMICAL, STACK> chemicalHandler, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(chemicalHandler, 0, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public ChemicalTankWidget(@Nullable IChemicalHandler<CHEMICAL, STACK> chemicalHandler, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        this(chemicalHandler, tank, x, y, 18, 18, allowClickContainerFilling, allowClickContainerEmptying);
    }

    public ChemicalTankWidget(@Nullable IChemicalHandler<CHEMICAL, STACK> chemicalHandler, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
        super(new Position(x, y), new Size(width, height));
        this.chemicalHandler = chemicalHandler;
        this.tank = tank;
        this.showAmount = true;
        this.allowClickFilled = allowClickContainerFilling;
        this.allowClickDrained = allowClickContainerEmptying;
        this.drawHoverTips = true;
    }

    public void initTemplate() {
        this.setBackground((IGuiTexture)FLUID_SLOT_TEXTURE);
        this.setFillDirection(ProgressTexture.FillDirection.DOWN_TO_UP);
    }

    public abstract Capability<? extends IChemicalHandler<CHEMICAL, STACK>> getCapability();

    public abstract ChemicalStack<CHEMICAL> readStack(CompoundTag var1);

    public ChemicalTankWidget<CHEMICAL, STACK> setChemicalTank(IChemicalHandler<CHEMICAL, STACK> chemicalHandler) {
        this.chemicalHandler = chemicalHandler;
        this.tank = 0;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setChemicalTank(IChemicalHandler<CHEMICAL, STACK> chemicalHandler, int tank) {
        this.chemicalHandler = chemicalHandler;
        this.tank = tank;
        if (this.isClientSideWidget) {
            this.setClientSideWidget();
        }
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setClientSideWidget() {
        super.setClientSideWidget();
        this.lastChemicalInTank = this.chemicalHandler != null ? this.chemicalHandler.getChemicalInTank(this.tank).copy() : null;
        this.lastTankCapacity = this.chemicalHandler != null ? this.chemicalHandler.getTankCapacity(this.tank) : 0L;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setBackground(IGuiTexture background) {
        super.setBackground(new IGuiTexture[]{background});
        return this;
    }

    public List<Object> getXEIIngredients() {
        Optional<JemiStack> stack;
        if (this.lastChemicalInTank == null || this.lastChemicalInTank.isEmpty()) {
            return Collections.emptyList();
        }
        if (LDLib.isModLoaded((String)"jei")) {
            Position pos = this.getPosition();
            Size size = this.getSize();
            Optional<ClickableIngredient> jeiIngredient = JEIPlugin.jeiHelpers.getIngredientManager().createTypedIngredient(this.lastChemicalInTank).map(typedIngredient -> new ClickableIngredient(typedIngredient, pos.x, pos.y, size.width, size.height));
            if (jeiIngredient.isPresent()) {
                return List.of(jeiIngredient.get());
            }
        }
        if (LDLib.isEmiLoaded() && LDLib.isModLoaded((String)"jei") && (stack = JEIPlugin.jeiHelpers.getIngredientManager().createTypedIngredient(this.lastChemicalInTank).map(typedIngredient -> {
            IIngredientHelper ingredientHelper = JEIPlugin.jeiHelpers.getIngredientManager().getIngredientHelper(typedIngredient.getType());
            IIngredientRenderer ingredientRenderer = JEIPlugin.jeiHelpers.getIngredientManager().getIngredientRenderer(typedIngredient.getType());
            return new JemiStack(typedIngredient.getType(), ingredientHelper, ingredientRenderer, (Object)((ChemicalStack)typedIngredient.getIngredient()));
        })).isPresent()) {
            return List.of(stack.get());
        }
        return List.of();
    }

    @Nullable
    public Object getXEICurrentIngredient() {
        if (this.lastChemicalInTank == null || this.lastChemicalInTank.isEmpty()) {
            return null;
        }
        if (LDLib.isModLoaded((String)"jei")) {
            return JEIPlugin.jeiHelpers.getIngredientManager().createTypedIngredient(this.lastChemicalInTank).orElse(null);
        }
        return null;
    }

    public List<Component> getTooltipTexts() {
        List<Component> tooltips = this.getAdditionalToolTips(new ArrayList<Component>());
        tooltips.addAll(this.tooltipTexts);
        return tooltips;
    }

    public List<Component> getAdditionalToolTips(List<Component> list) {
        if (this.onAddedTooltips != null) {
            this.onAddedTooltips.accept(this, list);
        }
        return list;
    }

    public List<Component> getFullTooltipTexts() {
        ArrayList<Component> tooltips = new ArrayList<Component>();
        ChemicalStack<CHEMICAL> chemicalStack = this.lastChemicalInTank;
        if (chemicalStack != null && !chemicalStack.isEmpty()) {
            tooltips.add(chemicalStack.getTextComponent());
            tooltips.add((Component)Component.m_237110_((String)"recipe.capability.mek_chemical.type.format", (Object[])new Object[]{LocalizationUtils.format((String)("recipe.capability.mek_chemical.type." + ChemicalType.getTypeFor((Chemical)this.lastChemicalInTank.getType()).m_7912_()), (Object[])new Object[0])}));
            tooltips.add((Component)Component.m_237110_((String)"ldlib.fluid.amount", (Object[])new Object[]{this.lastChemicalInTank.getAmount(), this.lastTankCapacity}).m_130946_(" mB"));
        } else {
            tooltips.add((Component)Component.m_237115_((String)"ldlib.fluid.empty"));
            tooltips.add((Component)Component.m_237110_((String)"ldlib.fluid.amount", (Object[])new Object[]{0, this.lastTankCapacity}).m_130946_(" mB"));
        }
        tooltips.addAll(this.getTooltipTexts());
        return tooltips;
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInBackground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        super.drawInBackground(graphics, mouseX, mouseY, partialTicks);
        if (this.isClientSideWidget && this.chemicalHandler != null) {
            ChemicalStack chemicalStack = this.chemicalHandler.getChemicalInTank(this.tank);
            long capacity = this.chemicalHandler.getTankCapacity(this.tank);
            if (capacity != this.lastTankCapacity) {
                this.lastTankCapacity = capacity;
            }
            if (!chemicalStack.isStackIdentical(this.lastChemicalInTank)) {
                this.lastChemicalInTank = chemicalStack.copy();
            } else if (chemicalStack.getAmount() != this.lastChemicalInTank.getAmount()) {
                this.lastChemicalInTank.setAmount(chemicalStack.getAmount());
            }
        }
        Position pos = this.getPosition();
        Size size = this.getSize();
        if (this.lastChemicalInTank != null) {
            RenderSystem.disableBlend();
            if (!this.lastChemicalInTank.isEmpty()) {
                double progress = (double)this.lastChemicalInTank.getAmount() * 1.0 / (double)Math.max(Math.max(this.lastChemicalInTank.getAmount(), this.lastTankCapacity), 1L);
                float drawnU = (float)this.fillDirection.getDrawnU(progress);
                float drawnV = (float)this.fillDirection.getDrawnV(progress);
                float drawnWidth = (float)this.fillDirection.getDrawnWidth(progress);
                float drawnHeight = (float)this.fillDirection.getDrawnHeight(progress);
                int width = size.width - 2;
                int height = size.height - 2;
                int x = pos.x + 1;
                int y = pos.y + 1;
                ChemicalTankWidget.drawChemical(graphics, (int)((float)x + drawnU * (float)width), (int)((float)y + drawnV * (float)height), (int)((float)width * drawnWidth), (int)((float)height * drawnHeight), this.lastChemicalInTank);
            }
            if (this.showAmount && !this.lastChemicalInTank.isEmpty()) {
                graphics.m_280168_().m_85836_();
                graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
                String s = TextFormattingUtil.formatLongToCompactStringBuckets((long)this.lastChemicalInTank.getAmount(), (int)3) + "B";
                Font fontRenderer = Minecraft.m_91087_().f_91062_;
                graphics.m_280056_(fontRenderer, s, (int)(((float)pos.x + (float)size.width / 3.0f) * 2.0f - (float)fontRenderer.m_92895_(s) + 21.0f), (int)(((float)pos.y + (float)size.height / 3.0f + 6.0f) * 2.0f), 0xFFFFFF, true);
                graphics.m_280168_().m_85849_();
            }
            RenderSystem.enableBlend();
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        }
        this.drawOverlay(graphics, mouseX, mouseY, partialTicks);
        if (this.drawHoverOverlay && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)false);
            DrawerHelper.drawSolidRect((GuiGraphics)graphics, (int)(this.getPosition().x + 1), (int)(this.getPosition().y + 1), (int)(this.getSize().width - 2), (int)(this.getSize().height - 2), (int)-2130706433);
            RenderSystem.colorMask((boolean)true, (boolean)true, (boolean)true, (boolean)true);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public static <CHEMICAL extends Chemical<CHEMICAL>> void drawChemical(GuiGraphics graphics, int xPosition, int yPosition, int width, int height, @Nonnull ChemicalStack<CHEMICAL> stack) {
        int desiredHeight = MathUtils.clampToInt((long)height);
        if (desiredHeight < 1) {
            desiredHeight = 1;
        }
        if (desiredHeight > height) {
            desiredHeight = height;
        }
        Chemical chemical = stack.getType();
        MekanismRenderer.color((GuiGraphics)graphics, (Chemical)chemical);
        GuiUtils.drawTiledSprite((GuiGraphics)graphics, (int)xPosition, (int)yPosition, (int)height, (int)width, (int)desiredHeight, (TextureAtlasSprite)MekanismRenderer.getSprite((ResourceLocation)chemical.getIcon()), (int)16, (int)16, (int)100, (GuiUtils.TilingDirection)GuiUtils.TilingDirection.UP_RIGHT);
        MekanismRenderer.resetColor((GuiGraphics)graphics);
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawInForeground(@Nonnull GuiGraphics graphics, int mouseX, int mouseY, float partialTicks) {
        if (this.drawHoverTips && this.isMouseOverElement(mouseX, mouseY) && this.getHoverElement(mouseX, mouseY) == this) {
            if (this.gui != null) {
                this.gui.getModularUIGui().setHoverTooltip(this.getFullTooltipTexts(), ItemStack.f_41583_, null, null);
            }
            RenderSystem.setShaderColor((float)1.0f, (float)1.0f, (float)1.0f, (float)1.0f);
        } else {
            super.drawInForeground(graphics, mouseX, mouseY, partialTicks);
        }
    }

    public void detectAndSendChanges() {
        if (this.chemicalHandler != null) {
            ChemicalStack chemicalStack = this.chemicalHandler.getChemicalInTank(this.tank);
            long capacity = this.chemicalHandler.getTankCapacity(this.tank);
            if (capacity != this.lastTankCapacity) {
                this.lastTankCapacity = capacity;
                this.writeUpdateInfo(0, buffer -> buffer.m_130103_(this.lastTankCapacity));
            }
            if (!chemicalStack.isStackIdentical(this.lastChemicalInTank)) {
                this.lastChemicalInTank = chemicalStack.copy();
                CompoundTag chemicalStackTag = chemicalStack.write(new CompoundTag());
                this.writeUpdateInfo(2, buffer -> buffer.m_130079_(chemicalStackTag));
            } else if (chemicalStack.getAmount() != this.lastChemicalInTank.getAmount()) {
                this.lastChemicalInTank.setAmount(chemicalStack.getAmount());
                this.writeUpdateInfo(3, buffer -> buffer.m_130103_(this.lastChemicalInTank.getAmount()));
            } else {
                super.detectAndSendChanges();
                return;
            }
            if (this.changeListener != null) {
                this.changeListener.run();
            }
        }
    }

    public void writeInitialData(FriendlyByteBuf buffer) {
        buffer.writeBoolean(this.chemicalHandler != null);
        if (this.chemicalHandler != null) {
            this.lastTankCapacity = this.chemicalHandler.getTankCapacity(this.tank);
            buffer.m_130103_(this.lastTankCapacity);
            ChemicalStack chemicalStack = this.chemicalHandler.getChemicalInTank(this.tank);
            this.lastChemicalInTank = chemicalStack.copy();
            buffer.m_130079_(chemicalStack.write(new CompoundTag()));
        }
    }

    public void readInitialData(FriendlyByteBuf buffer) {
        if (buffer.readBoolean()) {
            this.lastTankCapacity = buffer.m_130258_();
            this.readUpdateInfo(2, buffer);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public void readUpdateInfo(int id, FriendlyByteBuf buffer) {
        if (id == 0) {
            this.lastTankCapacity = buffer.m_130258_();
        } else if (id == 1) {
            this.lastChemicalInTank = null;
        } else if (id == 2) {
            this.lastChemicalInTank = this.readStack(buffer.m_130260_());
        } else if (id == 3 && this.lastChemicalInTank != null) {
            this.lastChemicalInTank.setAmount(buffer.m_130258_());
        } else if (id == 4) {
            ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
            int newStackSize = buffer.m_130242_();
            currentStack.m_41764_(newStackSize);
            this.gui.getModularUIContainer().m_142503_(currentStack);
        } else {
            super.readUpdateInfo(id, buffer);
            return;
        }
        if (this.changeListener != null) {
            this.changeListener.run();
        }
    }

    public void handleClientAction(int id, FriendlyByteBuf buffer) {
        boolean tryMax;
        boolean isFill;
        int clickResult;
        super.handleClientAction(id, buffer);
        if (id == 1 && (clickResult = this.tryClickContainer(isFill = buffer.readBoolean(), tryMax = buffer.readBoolean())) >= 0) {
            this.writeUpdateInfo(4, buf -> buf.m_130130_(clickResult));
        }
    }

    private int tryClickContainer(boolean isFill, boolean tryMax) {
        if (this.chemicalHandler == null) {
            return -1;
        }
        Player player = this.gui.entityPlayer;
        ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
        Optional optional = currentStack.getCapability(this.getCapability()).resolve();
        if (optional.isEmpty()) {
            return -1;
        }
        IChemicalHandler handler = (IChemicalHandler)optional.get();
        if (isFill && this.allowClickFilled && this.chemicalHandler.getChemicalInTank(this.tank).getAmount() > 0L) {
            ChemicalStack remaining;
            boolean performedFill = false;
            while (!(remaining = handler.insertChemical(this.chemicalHandler.getChemicalInTank(this.tank), Action.SIMULATE)).isStackIdentical(this.chemicalHandler.getChemicalInTank(this.tank))) {
                currentStack.getCapability(this.getCapability()).ifPresent(cap -> {
                    ChemicalStack left = handler.insertChemical(this.chemicalHandler.getChemicalInTank(this.tank), Action.EXECUTE);
                    this.chemicalHandler.setChemicalInTank(this.tank, left);
                });
                performedFill = true;
                if (tryMax) continue;
                break;
            }
            if (performedFill) {
                SoundEvent soundevent = FluidHelper.getFillSound((FluidStack)FluidStack.create((Fluid)Fluids.f_76193_, (long)1000L));
                if (soundevent != null) {
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().m_142503_(currentStack);
                return currentStack.m_41613_();
            }
        } else if (!isFill && this.allowClickDrained) {
            boolean performedEmptying = false;
            do {
                ChemicalStack extracted;
                ChemicalStack available;
                if ((available = this.chemicalHandler.getChemicalInTank(this.tank).copy()).isEmpty()) {
                    extracted = handler.extractChemical(this.chemicalHandler.getTankCapacity(this.tank), Action.SIMULATE);
                } else {
                    available.setAmount(this.chemicalHandler.getTankCapacity(this.tank) - available.getAmount());
                    extracted = handler.extractChemical(available, Action.SIMULATE);
                }
                if (extracted.isEmpty()) break;
                currentStack.getCapability(this.getCapability()).ifPresent(cap -> {
                    ChemicalStack realExtracted = handler.extractChemical(extracted, Action.EXECUTE);
                    realExtracted.setAmount(realExtracted.getAmount() + this.chemicalHandler.getChemicalInTank(this.tank).getAmount());
                    this.chemicalHandler.setChemicalInTank(this.tank, realExtracted);
                });
                performedEmptying = true;
            } while (tryMax);
            if (performedEmptying) {
                SoundEvent soundevent = FluidHelper.getEmptySound((FluidStack)FluidStack.create((Fluid)Fluids.f_76193_, (long)1000L));
                if (soundevent != null) {
                    player.m_9236_().m_6263_(null, player.m_20182_().f_82479_, player.m_20182_().f_82480_ + 0.5, player.m_20182_().f_82481_, soundevent, SoundSource.BLOCKS, 1.0f, 1.0f);
                }
                this.gui.getModularUIContainer().m_142503_(currentStack);
                return currentStack.m_41613_();
            }
        }
        return -1;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if ((this.allowClickDrained || this.allowClickFilled) && this.isMouseOverElement(mouseX, mouseY) && (button == 0 || button == 1)) {
            ItemStack currentStack = this.gui.getModularUIContainer().m_142621_();
            Optional optional = currentStack.getCapability(this.getCapability()).resolve();
            boolean isFill = button == 0;
            boolean tryMax = ChemicalTankWidget.isShiftDown();
            if (optional.isPresent()) {
                this.writeClientAction(1, writer -> {
                    writer.writeBoolean(isFill);
                    writer.writeBoolean(tryMax);
                });
                ChemicalTankWidget.playButtonClickSound();
                return true;
            }
        }
        return false;
    }

    @Nullable
    public IChemicalHandler<CHEMICAL, STACK> getChemicalHandler() {
        return this.chemicalHandler;
    }

    public int getTank() {
        return this.tank;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setShowAmount(boolean showAmount) {
        this.showAmount = showAmount;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setAllowClickFilled(boolean allowClickFilled) {
        this.allowClickFilled = allowClickFilled;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setAllowClickDrained(boolean allowClickDrained) {
        this.allowClickDrained = allowClickDrained;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setDrawHoverOverlay(boolean drawHoverOverlay) {
        this.drawHoverOverlay = drawHoverOverlay;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setDrawHoverTips(boolean drawHoverTips) {
        this.drawHoverTips = drawHoverTips;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setFillDirection(ProgressTexture.FillDirection fillDirection) {
        this.fillDirection = fillDirection;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setOnAddedTooltips(BiConsumer<ChemicalTankWidget<CHEMICAL, STACK>, List<Component>> onAddedTooltips) {
        this.onAddedTooltips = onAddedTooltips;
        return this;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setIngredientIO(IngredientIO ingredientIO) {
        this.ingredientIO = ingredientIO;
        return this;
    }

    public IngredientIO getIngredientIO() {
        return this.ingredientIO;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setXEIChance(float XEIChance) {
        this.XEIChance = XEIChance;
        return this;
    }

    public float getXEIChance() {
        return this.XEIChance;
    }

    public ChemicalTankWidget<CHEMICAL, STACK> setChangeListener(Runnable changeListener) {
        this.changeListener = changeListener;
        return this;
    }

    @LDLRegister(name="chemical_slurry_slot", group="widget.container", modID="mekanism")
    public static class Slurry
    extends ChemicalTankWidget<mekanism.api.chemical.slurry.Slurry, SlurryStack> {
        public Slurry(@Nullable ISlurryHandler chemicalHandler, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Slurry(@Nullable ISlurryHandler chemicalHandler, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Slurry(@Nullable ISlurryHandler chemicalHandler, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Slurry(@Nullable ISlurryHandler chemicalHandler, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        @Override
        public Capability<ISlurryHandler> getCapability() {
            return Capabilities.SLURRY_HANDLER;
        }

        public SlurryStack readStack(CompoundTag tag) {
            return SlurryStack.readFromNBT((CompoundTag)tag);
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            IChemicalTank iChemicalTank = ChemicalTankBuilder.SLURRY.createAllValid(2000L, null);
            if (iChemicalTank instanceof ISlurryHandler) {
                ISlurryHandler handler = (ISlurryHandler)iChemicalTank;
                handler.insertChemical((ChemicalStack)MekanismChemicalRecipeCapability.CAP_SLURRY.createDefaultContent(), Action.EXECUTE);
                father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", new Slurry(){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setHoverTooltips(tooltipTexts);
                        this.backgroundTexture = backgroundTexture;
                        this.hoverTexture = hoverTexture;
                        this.showAmount = showAmount;
                        this.drawHoverTips = drawHoverTips;
                        this.fillDirection = fillDirection;
                        this.overlay = overlay;
                    }
                }.setAllowClickDrained(false).setAllowClickFilled(false).setChemicalTank(handler))});
            }
            super.buildConfigurator(father);
        }

        public Slurry() {
        }
    }

    @LDLRegister(name="chemical_pigment_slot", group="widget.container", modID="mekanism")
    public static class Pigment
    extends ChemicalTankWidget<mekanism.api.chemical.pigment.Pigment, PigmentStack> {
        public Pigment(@Nullable IPigmentHandler chemicalHandler, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Pigment(@Nullable IPigmentHandler chemicalHandler, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Pigment(@Nullable IPigmentHandler chemicalHandler, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Pigment(@Nullable IPigmentHandler chemicalHandler, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        @Override
        public Capability<IPigmentHandler> getCapability() {
            return Capabilities.PIGMENT_HANDLER;
        }

        public PigmentStack readStack(CompoundTag tag) {
            return PigmentStack.readFromNBT((CompoundTag)tag);
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            IChemicalTank iChemicalTank = ChemicalTankBuilder.PIGMENT.createAllValid(2000L, null);
            if (iChemicalTank instanceof IPigmentHandler) {
                IPigmentHandler handler = (IPigmentHandler)iChemicalTank;
                handler.insertChemical((ChemicalStack)MekanismChemicalRecipeCapability.CAP_PIGMENT.createDefaultContent(), Action.EXECUTE);
                father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", new Pigment(){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setHoverTooltips(tooltipTexts);
                        this.backgroundTexture = backgroundTexture;
                        this.hoverTexture = hoverTexture;
                        this.showAmount = showAmount;
                        this.drawHoverTips = drawHoverTips;
                        this.fillDirection = fillDirection;
                        this.overlay = overlay;
                    }
                }.setAllowClickDrained(false).setAllowClickFilled(false).setChemicalTank(handler))});
            }
            super.buildConfigurator(father);
        }

        public Pigment() {
        }
    }

    @LDLRegister(name="chemical_infuse_slot", group="widget.container", modID="mekanism")
    public static class Infuse
    extends ChemicalTankWidget<InfuseType, InfusionStack> {
        public Infuse(@Nullable IInfusionHandler chemicalHandler, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Infuse(@Nullable IInfusionHandler chemicalHandler, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Infuse(@Nullable IInfusionHandler chemicalHandler, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Infuse(@Nullable IInfusionHandler chemicalHandler, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        @Override
        public Capability<IInfusionHandler> getCapability() {
            return Capabilities.INFUSION_HANDLER;
        }

        public InfusionStack readStack(CompoundTag tag) {
            return InfusionStack.readFromNBT((CompoundTag)tag);
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            IChemicalTank iChemicalTank = ChemicalTankBuilder.INFUSION.createAllValid(2000L, null);
            if (iChemicalTank instanceof IInfusionHandler) {
                IInfusionHandler handler = (IInfusionHandler)iChemicalTank;
                handler.insertChemical((ChemicalStack)MekanismChemicalRecipeCapability.CAP_INFUSE.createDefaultContent(), Action.EXECUTE);
                father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", new Infuse(){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setHoverTooltips(tooltipTexts);
                        this.backgroundTexture = backgroundTexture;
                        this.hoverTexture = hoverTexture;
                        this.showAmount = showAmount;
                        this.drawHoverTips = drawHoverTips;
                        this.fillDirection = fillDirection;
                        this.overlay = overlay;
                    }
                }.setAllowClickDrained(false).setAllowClickFilled(false).setChemicalTank(handler))});
            }
            super.buildConfigurator(father);
        }

        public Infuse() {
        }
    }

    @LDLRegister(name="chemical_gas_slot", group="widget.container", modID="mekanism")
    public static class Gas
    extends ChemicalTankWidget<mekanism.api.chemical.gas.Gas, GasStack> {
        public Gas(@Nullable IGasHandler chemicalHandler, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Gas(@Nullable IGasHandler chemicalHandler, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Gas(@Nullable IGasHandler chemicalHandler, int tank, int x, int y, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, allowClickContainerFilling, allowClickContainerEmptying);
        }

        public Gas(@Nullable IGasHandler chemicalHandler, int tank, int x, int y, int width, int height, boolean allowClickContainerFilling, boolean allowClickContainerEmptying) {
            super(chemicalHandler, tank, x, y, width, height, allowClickContainerFilling, allowClickContainerEmptying);
        }

        @Override
        public Capability<IGasHandler> getCapability() {
            return Capabilities.GAS_HANDLER;
        }

        public GasStack readStack(CompoundTag tag) {
            return GasStack.readFromNBT((CompoundTag)tag);
        }

        public void buildConfigurator(ConfiguratorGroup father) {
            IChemicalTank iChemicalTank = ChemicalTankBuilder.GAS.createAllValid(2000L, null);
            if (iChemicalTank instanceof IGasHandler) {
                IGasHandler handler = (IGasHandler)iChemicalTank;
                handler.insertChemical((ChemicalStack)MekanismChemicalRecipeCapability.CAP_GAS.createDefaultContent(), Action.EXECUTE);
                father.addConfigurators(new Configurator[]{new WrapperConfigurator("ldlib.gui.editor.group.preview", new Gas(){

                    public void updateScreen() {
                        super.updateScreen();
                        this.setHoverTooltips(tooltipTexts);
                        this.backgroundTexture = backgroundTexture;
                        this.hoverTexture = hoverTexture;
                        this.showAmount = showAmount;
                        this.drawHoverTips = drawHoverTips;
                        this.fillDirection = fillDirection;
                        this.overlay = overlay;
                    }
                }.setAllowClickDrained(false).setAllowClickFilled(false).setChemicalTank(handler))});
            }
            super.buildConfigurator(father);
        }

        public Gas() {
        }
    }
}

