/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.gtm.trait;

import com.gregtechceu.gtceu.api.capability.IEnergyContainer;
import com.gregtechceu.gtceu.api.capability.forge.GTCapability;
import com.gregtechceu.gtceu.api.misc.EnergyContainerList;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.integration.gtm.GTMEnergyRecipeCapability;
import com.lowdragmc.mbd2.integration.gtm.trait.CopiableEnergyContainer;
import com.lowdragmc.mbd2.integration.gtm.trait.EnergyContainerWrapper;
import com.lowdragmc.mbd2.integration.gtm.trait.GTMEnergyCapabilityTraitDefinition;
import java.util.List;
import java.util.Optional;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class GTMEnergyCapabilityTrait
extends SimpleCapabilityTrait
implements IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(GTMEnergyCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final CopiableEnergyContainer container;
    private final EnergyRecipeHandler recipeHandler = new EnergyRecipeHandler();
    private final EnergyContainerCap energyContainerCap = new EnergyContainerCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public GTMEnergyCapabilityTrait(MBDMachine machine, GTMEnergyCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.container = this.createStorages(machine);
        this.container.setOnContentsChanged(this::notifyListeners);
    }

    @Override
    public GTMEnergyCapabilityTraitDefinition getDefinition() {
        return (GTMEnergyCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        this.container.setEnergyStored(this.getDefinition().getCapacity() / 2L);
    }

    protected CopiableEnergyContainer createStorages(MBDMachine machine) {
        return new CopiableEnergyContainer(machine, this.getDefinition().isExplosionMachine(), this.getDefinition().getCapacity(), this.getDefinition().getInputAmperage(), this.getDefinition().getInputVoltage(), this.getDefinition().getOutputAmperage(), this.getDefinition().getOutputVoltage());
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.recipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.energyContainerCap);
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return this.getDefinition().getAutoIO().isEnable() ? this.getDefinition().getAutoIO() : null;
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io.support(IO.IN)) {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, side.m_122424_()).resolve()).ifPresent(source -> this.container.changeEnergy(source.removeEnergy(this.container.getEnergyCanBeInserted())));
        }
        if (io.support(IO.OUT)) {
            Optional.ofNullable(this.getMachine().getLevel().m_7702_(port.m_121945_(side))).flatMap(be -> be.getCapability(GTCapability.CAPABILITY_ENERGY_CONTAINER, side.m_122424_()).resolve()).ifPresent(target -> {
                long outputVoltage = this.container.getOutputVoltage();
                long outputAmperes = Math.min(this.container.getEnergyStored() / outputVoltage, this.container.getOutputAmperage());
                if (outputAmperes == 0L) {
                    return;
                }
                long amperesUsed = 0L;
                if (target.inputsEnergy(side.m_122424_())) {
                    amperesUsed += target.acceptEnergyFromNetwork(side.m_122424_(), outputVoltage, outputAmperes - amperesUsed);
                }
                if (amperesUsed > 0L) {
                    this.container.setEnergyStored(this.container.getEnergyStored() - amperesUsed * outputVoltage);
                }
            });
        }
    }

    public CopiableEnergyContainer getContainer() {
        return this.container;
    }

    public EnergyRecipeHandler getRecipeHandler() {
        return this.recipeHandler;
    }

    public EnergyContainerCap getEnergyContainerCap() {
        return this.energyContainerCap;
    }

    public class EnergyRecipeHandler
    extends RecipeHandlerTrait<Long> {
        protected EnergyRecipeHandler() {
            super(GTMEnergyCapabilityTrait.this, GTMEnergyRecipeCapability.CAP);
        }

        @Override
        public List<Long> handleRecipeInner(IO io, MBDRecipe recipe, List<Long> left, @Nullable String slotName, boolean simulate) {
            CopiableEnergyContainer capability;
            if (!this.compatibleWith(io)) {
                return left;
            }
            long required = left.stream().reduce(0L, Long::sum);
            CopiableEnergyContainer copiableEnergyContainer = capability = simulate ? GTMEnergyCapabilityTrait.this.container.copy() : GTMEnergyCapabilityTrait.this.container;
            if (io == IO.IN) {
                long canOutput = capability.getEnergyStored();
                if (!simulate) {
                    capability.addEnergy(-Math.min(canOutput, required));
                }
                required -= canOutput;
            } else if (io == IO.OUT) {
                long canInput = capability.getEnergyCapacity() - capability.getEnergyStored();
                if (!simulate) {
                    capability.addEnergy(Math.min(canInput, required));
                }
                required -= canInput;
            }
            return required > 0L ? List.of(Long.valueOf(required)) : null;
        }
    }

    public class EnergyContainerCap
    implements ICapabilityProviderTrait<IEnergyContainer> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return GTMEnergyCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IEnergyContainer> getCapability() {
            return GTCapability.CAPABILITY_ENERGY_CONTAINER;
        }

        @Override
        public IEnergyContainer getCapContent(IO capbilityIO) {
            return new EnergyContainerWrapper(GTMEnergyCapabilityTrait.this.container, capbilityIO);
        }

        @Override
        public IEnergyContainer mergeContents(List<IEnergyContainer> contents) {
            return new EnergyContainerList(contents);
        }
    }
}

