/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.client.renderer.IItemRendererProvider;
import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.texture.IRendererSlotTexture;
import com.lowdragmc.mbd2.common.item.MBDMachineItem;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.machine.definition.MBDMachineDefinition;
import com.lowdragmc.mbd2.integration.create.machine.CraeteKinecticMachineProject;
import com.lowdragmc.mbd2.integration.create.machine.CreateKineticMachineDefinition;
import com.mojang.blaze3d.vertex.PoseStack;
import com.simibubi.create.content.kinetics.base.KineticBlockEntity;
import com.simibubi.create.content.kinetics.base.KineticBlockEntityRenderer;
import dev.engine_room.flywheel.api.visualization.VisualizationManager;
import java.util.List;
import java.util.Optional;
import net.createmod.catnip.animation.AnimationTickHolder;
import net.createmod.catnip.render.CachedBuffers;
import net.createmod.catnip.render.SuperBufferFactory;
import net.createmod.catnip.render.SuperByteBuffer;
import net.createmod.catnip.render.SuperByteBufferCache;
import net.minecraft.client.renderer.MultiBufferSource;
import net.minecraft.client.renderer.RenderType;
import net.minecraft.client.renderer.block.model.BakedQuad;
import net.minecraft.client.renderer.texture.TextureAtlasSprite;
import net.minecraft.client.resources.model.BakedModel;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.util.RandomSource;
import net.minecraft.world.item.BlockItem;
import net.minecraft.world.item.ItemDisplayContext;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.LevelAccessor;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.phys.Vec3;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import net.minecraftforge.client.ForgeHooksClient;
import net.minecraftforge.client.model.data.ModelData;
import org.apache.commons.lang3.tuple.Pair;
import org.jetbrains.annotations.NotNull;
import org.jetbrains.annotations.Nullable;

@OnlyIn(value=Dist.CLIENT)
public record KineticInstanceRenderer(IRenderer baseRenderer, BakedModel rotationModel) implements IRenderer
{
    public static final SuperByteBufferCache.Compartment<Pair<Direction, BakedModel>> DIRECTIONAL_PARTIAL = new SuperByteBufferCache.Compartment();

    public void renderItem(ItemStack stack, ItemDisplayContext transformType, boolean leftHand, PoseStack poseStack, MultiBufferSource bufferSource, int combinedLight, int combinedOverlay, BakedModel model) {
        Object createKineticMachineDefinition;
        MBDMachineItem item;
        IItemRendererProvider.disabled.set(true);
        this.baseRenderer.renderItem(stack, transformType, leftHand, poseStack, bufferSource, combinedLight, combinedOverlay, model);
        CreateKineticMachineDefinition definition = null;
        Object object = stack.m_41720_();
        if (object instanceof MBDMachineItem && (object = (item = (MBDMachineItem)((Object)object)).getDefinition()) instanceof CreateKineticMachineDefinition) {
            createKineticMachineDefinition = (CreateKineticMachineDefinition)object;
            definition = createKineticMachineDefinition;
        } else {
            object = IRendererSlotTexture.CURRENT_MACHINE_DEFINITION;
            if (object instanceof CreateKineticMachineDefinition) {
                CreateKineticMachineDefinition createKineticMachineDefinition2;
                definition = createKineticMachineDefinition2 = (CreateKineticMachineDefinition)object;
            }
        }
        if (definition != null && (createKineticMachineDefinition = stack.m_41720_()) instanceof BlockItem) {
            BlockItem blockItem = (BlockItem)createKineticMachineDefinition;
            poseStack.m_85836_();
            ForgeHooksClient.handleCameraTransforms((PoseStack)poseStack, (BakedModel)this.rotationModel, (ItemDisplayContext)transformType, (boolean)leftHand);
            poseStack.m_85837_(-0.5, -0.5, -0.5);
            Direction rotationFacing = definition.kineticMachineSettings().getRotationFacing(Direction.NORTH);
            Direction.Axis axis = rotationFacing.m_122434_();
            float angle = 0.9424779f;
            BlockState state = blockItem.m_40614_().m_49966_();
            SuperByteBuffer superByteBuffer = SuperByteBufferCache.getInstance().get(DIRECTIONAL_PARTIAL, (Object)Pair.of((Object)rotationFacing, (Object)this.rotationModel), () -> SuperBufferFactory.getInstance().createForBlock(this.rotationModel, state, (PoseStack)CachedBuffers.rotateToFaceVertical((Direction)rotationFacing).get()));
            superByteBuffer.light(combinedLight);
            superByteBuffer.rotateCentered(angle, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis));
            for (RenderType renderType : this.rotationModel.getRenderTypes(state, RandomSource.m_216335_((long)49L), ModelData.EMPTY)) {
                superByteBuffer.renderInto(poseStack, bufferSource.m_6299_(renderType));
            }
            poseStack.m_85849_();
        }
        IItemRendererProvider.disabled.set(false);
    }

    public List<BakedQuad> renderModel(@Nullable BlockAndTintGetter level, @Nullable BlockPos pos, @Nullable BlockState state, @Nullable Direction side, RandomSource rand) {
        return this.baseRenderer.renderModel(level, pos, state, side, rand);
    }

    private boolean isInvalid(BlockEntity te) {
        return !te.m_58898_() || te.m_58900_().m_60734_() == Blocks.f_50016_;
    }

    public boolean hasTESR(BlockEntity blockEntity) {
        return true;
    }

    public void render(BlockEntity blockEntity, float partialTicks, PoseStack stack, MultiBufferSource buffer, int combinedLight, int combinedOverlay) {
        this.baseRenderer.render(blockEntity, partialTicks, stack, buffer, combinedLight, combinedOverlay);
        if (this.isInvalid(blockEntity)) {
            return;
        }
        this.renderSafe(blockEntity, stack, buffer, combinedLight, combinedOverlay, partialTicks);
    }

    public void renderSafe(BlockEntity blockEntity, PoseStack poseStack, MultiBufferSource bufferSource, int light, int overlay, float partialTicks) {
        Optional<MBDMachine> machineOptional = IMachine.ofMachine(blockEntity).filter(MBDMachine.class::isInstance).map(MBDMachine.class::cast);
        if (machineOptional.isEmpty()) {
            return;
        }
        MBDMachine machine = machineOptional.get();
        MBDMachineDefinition mBDMachineDefinition = machine.getDefinition();
        if (mBDMachineDefinition instanceof CreateKineticMachineDefinition) {
            CreateKineticMachineDefinition definition = (CreateKineticMachineDefinition)mBDMachineDefinition;
            if (VisualizationManager.supportsVisualization((LevelAccessor)blockEntity.m_58904_()) && definition.kineticMachineSettings.useFlywheel()) {
                return;
            }
            BlockState state = blockEntity.m_58900_();
            Direction rotationFacing = definition.kineticMachineSettings().getRotationFacing(machine.getFrontFacing().orElse(Direction.NORTH));
            Direction.Axis axis = rotationFacing.m_122434_();
            float angle = 0.0f;
            SuperByteBuffer superByteBuffer = SuperByteBufferCache.getInstance().get(DIRECTIONAL_PARTIAL, (Object)Pair.of((Object)rotationFacing, (Object)this.rotationModel), () -> SuperBufferFactory.getInstance().createForBlock(this.rotationModel, state, (PoseStack)CachedBuffers.rotateToFaceVertical((Direction)rotationFacing).get()));
            float time = AnimationTickHolder.getRenderTime((LevelAccessor)blockEntity.m_58904_());
            if (blockEntity instanceof KineticBlockEntity) {
                KineticBlockEntity kineticBlockEntity = (KineticBlockEntity)blockEntity;
                BlockPos pos = blockEntity.m_58899_();
                float offset = KineticBlockEntityRenderer.getRotationOffsetForPosition((KineticBlockEntity)kineticBlockEntity, (BlockPos)pos, (Direction.Axis)axis);
                angle = time * kineticBlockEntity.getSpeed() * 3.0f / 10.0f % 360.0f;
                angle += offset;
                angle = angle / 180.0f * (float)Math.PI;
                KineticBlockEntityRenderer.kineticRotationTransform((SuperByteBuffer)superByteBuffer, (KineticBlockEntity)kineticBlockEntity, (Direction.Axis)axis, (float)angle, (int)light);
            } else {
                CraeteKinecticMachineProject project;
                MachineEditor editor;
                Editor editor2 = Editor.INSTANCE;
                if (editor2 instanceof MachineEditor && (editor2 = (editor = (MachineEditor)editor2).getCurrentProject()) instanceof CraeteKinecticMachineProject && (project = (CraeteKinecticMachineProject)editor2).isRotating()) {
                    angle = time * project.getSpeed() * 3.0f / 10.0f % 360.0f;
                    angle = angle / 180.0f * (float)Math.PI;
                }
                superByteBuffer.light(light);
                superByteBuffer.rotateCentered(angle, Direction.m_122390_((Direction.AxisDirection)Direction.AxisDirection.POSITIVE, (Direction.Axis)axis));
            }
            for (RenderType renderType : this.rotationModel.getRenderTypes(state, blockEntity.m_58904_().m_213780_(), ModelData.EMPTY)) {
                superByteBuffer.renderInto(poseStack, bufferSource.m_6299_(renderType));
            }
        }
    }

    public boolean isGlobalRenderer(BlockEntity blockEntity) {
        return this.baseRenderer.isGlobalRenderer(blockEntity);
    }

    public int getViewDistance() {
        return this.baseRenderer.getViewDistance();
    }

    public boolean shouldRender(BlockEntity blockEntity, Vec3 cameraPos) {
        return this.baseRenderer.shouldRender(blockEntity, cameraPos);
    }

    @NotNull
    public TextureAtlasSprite getParticleTexture() {
        return this.baseRenderer.getParticleTexture();
    }

    public boolean useAO() {
        return this.baseRenderer.useAO();
    }

    public boolean useAO(BlockState state) {
        return this.baseRenderer.useAO(state);
    }

    public boolean useBlockLight(ItemStack stack) {
        return this.baseRenderer.useBlockLight(stack);
    }

    public boolean reBakeCustomQuads() {
        return this.baseRenderer.reBakeCustomQuads();
    }

    public float reBakeCustomQuadsOffset() {
        return this.baseRenderer.reBakeCustomQuadsOffset();
    }

    public boolean isGui3d() {
        return this.baseRenderer.isGui3d();
    }
}

