/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.create.machine;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import net.minecraft.core.Direction;

public class ConfigKineticMachineSettings
implements IConfigurable,
IPersistedSerializable {
    @Configurable(name="config.kinetic_machine.is_generator", tips={"config.kinetic_machine.is_generator.tooltip"})
    public boolean isGenerator;
    @Configurable(name="config.kinetic_machine.torque", tips={"config.kinetic_machine.torque.tooltip.0", "config.kinetic_machine.torque.tooltip.1"})
    @NumberRange(range={0.0, 3.4028234663852886E38})
    public float torque;
    @Configurable(name="config.kinetic_machine.front_rotation", tips={"config.kinetic_machine.front_rotation.tooltip"})
    public RotationFacing frontRotation;
    @Configurable(name="config.kinetic_machine.has_back_rotation", tips={"config.kinetic_machine.has_back_rotation.tooltip.0", "config.kinetic_machine.has_back_rotation.tooltip.1"})
    public boolean hasBackRotation;
    @Configurable(name="config.kinetic_machine.max_rpm", tips={"config.kinetic_machine.max_rpm.tooltip.0", "config.kinetic_machine.max_rpm.tooltip.1"})
    @NumberRange(range={0.0, 2.147483647E9})
    public int maxRPM;
    @Configurable(name="config.kinetic_machine.use_flywheel", tips={"config.kinetic_machine.use_flywheel.tooltip"})
    public boolean useFlywheel;

    public Direction getRotationFacing(Direction frontFacing) {
        return this.frontRotation.getDirection(frontFacing);
    }

    public boolean hasShaftTowards(Direction towardFace, Direction rotationFacing) {
        if (towardFace.m_122434_() == rotationFacing.m_122434_()) {
            if (!this.hasBackRotation) {
                return towardFace == rotationFacing;
            }
            return true;
        }
        return false;
    }

    public float getCapacity() {
        return this.isGenerator ? Math.max(this.torque, Float.MIN_VALUE) : 0.0f;
    }

    public float getImpact() {
        return this.isGenerator ? 0.0f : this.torque;
    }

    private static boolean $default$isGenerator() {
        return false;
    }

    private static float $default$torque() {
        return 4.0f;
    }

    private static RotationFacing $default$frontRotation() {
        return RotationFacing.FRONT;
    }

    private static boolean $default$hasBackRotation() {
        return true;
    }

    private static int $default$maxRPM() {
        return 256;
    }

    private static boolean $default$useFlywheel() {
        return true;
    }

    ConfigKineticMachineSettings(boolean isGenerator, float torque, RotationFacing frontRotation, boolean hasBackRotation, int maxRPM, boolean useFlywheel) {
        this.isGenerator = isGenerator;
        this.torque = torque;
        this.frontRotation = frontRotation;
        this.hasBackRotation = hasBackRotation;
        this.maxRPM = maxRPM;
        this.useFlywheel = useFlywheel;
    }

    public static ConfigKineticMachineSettingsBuilder builder() {
        return new ConfigKineticMachineSettingsBuilder();
    }

    public boolean isGenerator() {
        return this.isGenerator;
    }

    public float torque() {
        return this.torque;
    }

    public RotationFacing frontRotation() {
        return this.frontRotation;
    }

    public boolean hasBackRotation() {
        return this.hasBackRotation;
    }

    public int maxRPM() {
        return this.maxRPM;
    }

    public boolean useFlywheel() {
        return this.useFlywheel;
    }

    public static enum RotationFacing {
        FRONT,
        BACK,
        LEFT,
        RIGHT,
        UP,
        DOWN;


        public Direction getDirection(Direction frontFacing) {
            if (frontFacing.m_122434_() == Direction.Axis.Y) {
                return switch (this) {
                    default -> throw new IncompatibleClassChangeError();
                    case FRONT -> frontFacing;
                    case BACK -> frontFacing.m_122424_();
                    case LEFT -> Direction.WEST;
                    case RIGHT -> Direction.EAST;
                    case UP -> Direction.NORTH;
                    case DOWN -> Direction.SOUTH;
                };
            }
            return switch (this) {
                default -> throw new IncompatibleClassChangeError();
                case FRONT -> frontFacing;
                case BACK -> frontFacing.m_122424_();
                case LEFT -> frontFacing.m_122427_();
                case RIGHT -> frontFacing.m_122428_();
                case UP -> Direction.UP;
                case DOWN -> Direction.DOWN;
            };
        }
    }

    public static class ConfigKineticMachineSettingsBuilder {
        private boolean isGenerator$set;
        private boolean isGenerator$value;
        private boolean torque$set;
        private float torque$value;
        private boolean frontRotation$set;
        private RotationFacing frontRotation$value;
        private boolean hasBackRotation$set;
        private boolean hasBackRotation$value;
        private boolean maxRPM$set;
        private int maxRPM$value;
        private boolean useFlywheel$set;
        private boolean useFlywheel$value;

        ConfigKineticMachineSettingsBuilder() {
        }

        public ConfigKineticMachineSettingsBuilder isGenerator(boolean isGenerator) {
            this.isGenerator$value = isGenerator;
            this.isGenerator$set = true;
            return this;
        }

        public ConfigKineticMachineSettingsBuilder torque(float torque) {
            this.torque$value = torque;
            this.torque$set = true;
            return this;
        }

        public ConfigKineticMachineSettingsBuilder frontRotation(RotationFacing frontRotation) {
            this.frontRotation$value = frontRotation;
            this.frontRotation$set = true;
            return this;
        }

        public ConfigKineticMachineSettingsBuilder hasBackRotation(boolean hasBackRotation) {
            this.hasBackRotation$value = hasBackRotation;
            this.hasBackRotation$set = true;
            return this;
        }

        public ConfigKineticMachineSettingsBuilder maxRPM(int maxRPM) {
            this.maxRPM$value = maxRPM;
            this.maxRPM$set = true;
            return this;
        }

        public ConfigKineticMachineSettingsBuilder useFlywheel(boolean useFlywheel) {
            this.useFlywheel$value = useFlywheel;
            this.useFlywheel$set = true;
            return this;
        }

        public ConfigKineticMachineSettings build() {
            boolean isGenerator$value = this.isGenerator$value;
            if (!this.isGenerator$set) {
                isGenerator$value = ConfigKineticMachineSettings.$default$isGenerator();
            }
            float torque$value = this.torque$value;
            if (!this.torque$set) {
                torque$value = ConfigKineticMachineSettings.$default$torque();
            }
            RotationFacing frontRotation$value = this.frontRotation$value;
            if (!this.frontRotation$set) {
                frontRotation$value = ConfigKineticMachineSettings.$default$frontRotation();
            }
            boolean hasBackRotation$value = this.hasBackRotation$value;
            if (!this.hasBackRotation$set) {
                hasBackRotation$value = ConfigKineticMachineSettings.$default$hasBackRotation();
            }
            int maxRPM$value = this.maxRPM$value;
            if (!this.maxRPM$set) {
                maxRPM$value = ConfigKineticMachineSettings.$default$maxRPM();
            }
            boolean useFlywheel$value = this.useFlywheel$value;
            if (!this.useFlywheel$set) {
                useFlywheel$value = ConfigKineticMachineSettings.$default$useFlywheel();
            }
            return new ConfigKineticMachineSettings(isGenerator$value, torque$value, frontRotation$value, hasBackRotation$value, maxRPM$value, useFlywheel$value);
        }

        public String toString() {
            return "ConfigKineticMachineSettings.ConfigKineticMachineSettingsBuilder(isGenerator$value=" + this.isGenerator$value + ", torque$value=" + this.torque$value + ", frontRotation$value=" + String.valueOf((Object)this.frontRotation$value) + ", hasBackRotation$value=" + this.hasBackRotation$value + ", maxRPM$value=" + this.maxRPM$value + ", useFlywheel$value=" + this.useFlywheel$value + ")";
        }
    }

    public static enum RenderLayer {
        SOLID,
        CUTOUT,
        TRANSPARENT;

    }
}

