/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania.trait;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.TextTextureWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.machine.IMachine;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.ToggleAutoIO;
import com.lowdragmc.mbd2.integration.botania.BotaniaManaRecipeCapability;
import com.lowdragmc.mbd2.integration.botania.trait.BotaniaManaCapabilityTrait;
import com.lowdragmc.mbd2.integration.botania.trait.BotaniaManaFancyRendererSettings;
import com.lowdragmc.mbd2.utils.WidgetUtils;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import vazkii.botania.common.block.BotaniaBlocks;

@LDLRegister(name="botania_mana_storage", group="trait", modID="botania")
public class BotaniaManaCapabilityTraitDefinition
extends SimpleCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.botania_mana_storage.capacity")
    @NumberRange(range={1.0, 2.147483647E9})
    private int capacity = 5000;
    @Configurable(name="config.definition.trait.botania_mana_storage.can_attach_spark", tips={"config.definition.trait.botania_mana_storage.can_attach_spark.tooltip"})
    private boolean canAttachSpark = true;
    @Configurable(name="config.definition.trait.auto_io", subConfigurable=true, tips={"config.definition.trait.botania_mana_storage.auto_io.tooltip"})
    private final ToggleAutoIO autoIO = new ToggleAutoIO();
    @Configurable(name="config.definition.trait.botania_mana_storage.fancy_renderer", subConfigurable=true, tips={"config.definition.trait.botania_mana_storage.fancy_renderer.tooltip"})
    private final BotaniaManaFancyRendererSettings fancyRendererSettings = new BotaniaManaFancyRendererSettings(this);

    @Override
    public SimpleCapabilityTrait createTrait(MBDMachine machine) {
        return new BotaniaManaCapabilityTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{BotaniaBlocks.manaPool.m_5456_()});
    }

    @Override
    public IRenderer getBESRenderer(IMachine machine) {
        return this.fancyRendererSettings.getFancyRenderer(machine);
    }

    @Override
    public void createTraitUITemplate(WidgetGroup ui) {
        String prefix = this.uiPrefixName();
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 5, 100, 5, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)BotaniaManaRecipeCapability.HUD_BAR.copy().setColor(ColorPattern.LIGHT_BLUE.color)));
        energyBar.setBackground(new IGuiTexture[]{BotaniaManaRecipeCapability.HUD_BACKGROUND});
        energyBar.setId(prefix);
        TextTextureWidget energyBarText = new TextTextureWidget(5, 3, 90, 10).setText("0/0 mana").textureStyle(textTexture -> textTexture.setDropShadow(true));
        energyBarText.setId(prefix + "_text");
        ui.addWidget((Widget)energyBar);
        ui.addWidget((Widget)energyBarText);
    }

    @Override
    public void initTraitUI(ITrait trait, WidgetGroup group) {
        if (trait instanceof BotaniaManaCapabilityTrait) {
            BotaniaManaCapabilityTrait manaTrait = (BotaniaManaCapabilityTrait)trait;
            String prefix = this.uiPrefixName();
            WidgetUtils.widgetByIdForEach(group, "^%s$".formatted(prefix), ProgressWidget.class, energyBar -> {
                energyBar.setProgressSupplier(() -> (double)manaTrait.storage.getCurrentMana() * 1.0 / (double)manaTrait.storage.getMaxMana());
                energyBar.setDynamicHoverTips(progress -> LocalizationUtils.format((String)"config.definition.trait.botania_mana_storage.ui_container_hover", (Object[])new Object[]{Math.round((double)manaTrait.storage.getMaxMana() * progress), manaTrait.storage.getMaxMana()}));
            });
            WidgetUtils.widgetByIdForEach(group, "^%s_text$".formatted(prefix), TextTextureWidget.class, energyBarText -> energyBarText.setText(() -> Component.m_237113_((String)(manaTrait.storage.getCurrentMana() + "/" + manaTrait.storage.getMaxMana() + " mana"))));
        }
    }

    public int getCapacity() {
        return this.capacity;
    }

    public void setCapacity(int capacity) {
        this.capacity = capacity;
    }

    public boolean isCanAttachSpark() {
        return this.canAttachSpark;
    }

    public void setCanAttachSpark(boolean canAttachSpark) {
        this.canAttachSpark = canAttachSpark;
    }

    public ToggleAutoIO getAutoIO() {
        return this.autoIO;
    }
}

