/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.botania;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.NumberConfigurator;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.gui.texture.ProgressTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.ProgressWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.Content;
import com.lowdragmc.mbd2.api.recipe.content.SerializerInteger;
import com.lowdragmc.mbd2.common.gui.recipe.CornerNumberWidget;
import java.util.List;
import java.util.function.Consumer;
import java.util.function.Supplier;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import vazkii.botania.common.block.BotaniaBlocks;

public class BotaniaManaRecipeCapability
extends RecipeCapability<Integer> {
    public static final BotaniaManaRecipeCapability CAP = new BotaniaManaRecipeCapability();
    public static final ResourceTexture HUD_BACKGROUND = new ResourceTexture("mbd2:textures/gui/mana_hud.png").getSubTexture(0.0, 0.0, 1.0, 0.5);
    public static final ResourceTexture HUD_BAR = new ResourceTexture("mbd2:textures/gui/mana_hud.png").getSubTexture(0.0, 0.5, 1.0, 0.5);

    protected BotaniaManaRecipeCapability() {
        super("botania_mana", SerializerInteger.INSTANCE);
    }

    @Override
    public Integer createDefaultContent() {
        return 512;
    }

    @Override
    public Widget createPreviewWidget(Integer content) {
        WidgetGroup previewGroup = new WidgetGroup(0, 0, 18, 18);
        previewGroup.addWidget((Widget)new ImageWidget(1, 1, 16, 16, (IGuiTexture)new ItemStackTexture(new Item[]{BotaniaBlocks.manaPool.m_5456_()})));
        previewGroup.addWidget((Widget)new CornerNumberWidget(0, 0, 18, 18).setValue(content.intValue()));
        return previewGroup;
    }

    @Override
    public Widget createXEITemplate() {
        ProgressWidget energyBar = new ProgressWidget(ProgressWidget.JEIProgress, 0, 0, 100, 5, new ProgressTexture(IGuiTexture.EMPTY, (IGuiTexture)HUD_BAR.copy().setColor(ColorPattern.LIGHT_BLUE.color)));
        energyBar.setBackground(new IGuiTexture[]{HUD_BACKGROUND});
        energyBar.setOverlay((IGuiTexture)new TextTexture("0 mana"));
        return energyBar;
    }

    @Override
    public void bindXEIWidget(Widget widget, Content content, IngredientIO ingredientIO) {
        if (widget instanceof ProgressWidget) {
            ProgressWidget energyBar = (ProgressWidget)widget;
            Integer energy = (Integer)this.of(content.content);
            IGuiTexture iGuiTexture = energyBar.getOverlay();
            if (iGuiTexture instanceof TextTexture) {
                TextTexture textTexture = (TextTexture)iGuiTexture;
                if (content.perTick) {
                    textTexture.updateText(energy + " mana/t");
                } else {
                    textTexture.updateText(energy + " mana");
                }
            }
        }
    }

    @Override
    public void createContentConfigurator(ConfiguratorGroup father, Supplier<Integer> supplier, Consumer<Integer> onUpdate) {
        Configurator[] configuratorArray = new Configurator[1];
        configuratorArray[0] = new NumberConfigurator("recipe.capability.botania_mana.mana", supplier::get, number -> onUpdate.accept(number.intValue()), (Number)1, true).setRange((Number)1, (Number)Integer.MAX_VALUE);
        father.addConfigurators(configuratorArray);
    }

    @Override
    public Component getLeftErrorInfo(List<Integer> left) {
        return Component.m_237113_((String)(left.stream().mapToInt(Integer::intValue).sum() + " mana"));
    }
}

