/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.ae2.trait;

import appeng.api.behaviors.GenericInternalInventory;
import appeng.api.networking.IGridNodeListener;
import appeng.api.networking.IInWorldGridNodeHost;
import appeng.api.networking.IManagedGridNode;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.api.storage.MEStorage;
import appeng.api.util.AECableType;
import appeng.capabilities.Capabilities;
import appeng.helpers.InterfaceLogicHost;
import appeng.me.helpers.IGridConnectedBlockEntity;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.misc.ItemStackTransfer;
import com.lowdragmc.lowdraglib.misc.ItemTransferList;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.mbd2.common.capability.recipe.FluidRecipeCapability;
import com.lowdragmc.mbd2.common.capability.recipe.ItemRecipeCapability;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.integration.ae2.trait.AEInterfaceSlotWidget;
import com.lowdragmc.mbd2.integration.ae2.trait.MEInterfaceTraitDefinition;
import com.lowdragmc.mbd2.integration.ae2.trait.SerializableInterfaceLogic;
import com.lowdragmc.mbd2.integration.ae2.trait.SerializableManagedGridNode;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import net.minecraft.core.Direction;
import net.minecraft.server.TickTask;
import net.minecraft.server.level.ServerLevel;
import net.minecraft.world.entity.Entity;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.crafting.Ingredient;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.entity.BlockEntity;
import net.minecraftforge.common.capabilities.Capability;
import org.jetbrains.annotations.Nullable;

public class MEInterfaceTrait
extends SimpleCapabilityTrait
implements IGridConnectedBlockEntity,
InterfaceLogicHost {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(MEInterfaceTrait.class);
    private final Random random = new Random();
    @Persisted
    private final SerializableManagedGridNode mainNode;
    @Persisted
    private final SerializableInterfaceLogic interfaceLogic;
    private final ItemRecipeHandler itemRecipeHandler = new ItemRecipeHandler();
    private final FluidRecipeHandler fluidRecipeHandler = new FluidRecipeHandler();
    private final ManagedGridNodeCap managedGridNodeCap = new ManagedGridNodeCap();
    private final GenericInternalInventoryCap genericInternalInventoryCap = new GenericInternalInventoryCap();
    private final StorageCap storageCap = new StorageCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public MEInterfaceTrait(MBDMachine machine, MEInterfaceTraitDefinition definition) {
        super(machine, definition);
        this.mainNode = this.createMainNode();
        this.interfaceLogic = this.createLogic();
    }

    protected SerializableManagedGridNode createMainNode() {
        return (SerializableManagedGridNode)new SerializableManagedGridNode(this, (nodeOwner, node) -> nodeOwner.interfaceLogic.gridChanged()).setVisualRepresentation(this.getMachine().getDropItem()).setInWorldNode(true).setTagName("proxy");
    }

    protected SerializableInterfaceLogic createLogic() {
        return new SerializableInterfaceLogic((IManagedGridNode)this.getMainNode(), this, this.getMachine().getDropItem().m_41720_(), this.getDefinition().getSlotSize() * 2);
    }

    @Override
    public MEInterfaceTraitDefinition getDefinition() {
        return (MEInterfaceTraitDefinition)super.getDefinition();
    }

    public BlockEntity getBlockEntity() {
        return this.getMachine().getHolder();
    }

    public void saveChanges() {
        this.onChanged();
    }

    public void onMainNodeStateChanged(IGridNodeListener.State reason) {
        if (this.getMainNode().hasGridBooted()) {
            this.interfaceLogic.notifyNeighbors();
        }
    }

    public ItemStack getMainMenuIcon() {
        return this.getMachine().getDropItem();
    }

    @Override
    public void onMachineDrop(Entity entity, List<ItemStack> drops) {
        this.interfaceLogic.addDrops(drops);
        this.interfaceLogic.clearContent();
    }

    public AECableType getCableConnectionType(Direction dir) {
        return this.interfaceLogic.getCableConnectionType(dir);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.managedGridNodeCap, this.genericInternalInventoryCap, this.storageCap);
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.itemRecipeHandler, this.fluidRecipeHandler);
    }

    @Override
    public void onChunkUnloaded() {
        super.onChunkUnloaded();
        this.getMainNode().destroy();
    }

    @Override
    public void onMachineLoad() {
        super.onMachineLoad();
        Level level = this.getMachine().getLevel();
        if (level instanceof ServerLevel) {
            ServerLevel serverLevel = (ServerLevel)level;
            serverLevel.m_7654_().m_6937_((Runnable)new TickTask(0, () -> this.getMainNode().create((Level)serverLevel, this.getBlockEntity().m_58899_())));
        }
    }

    @Override
    public void onMachineUnLoad() {
        super.onMachineUnLoad();
        this.getMainNode().destroy();
    }

    public Random getRandom() {
        return this.random;
    }

    public SerializableManagedGridNode getMainNode() {
        return this.mainNode;
    }

    public SerializableInterfaceLogic getInterfaceLogic() {
        return this.interfaceLogic;
    }

    public ItemRecipeHandler getItemRecipeHandler() {
        return this.itemRecipeHandler;
    }

    public FluidRecipeHandler getFluidRecipeHandler() {
        return this.fluidRecipeHandler;
    }

    public ManagedGridNodeCap getManagedGridNodeCap() {
        return this.managedGridNodeCap;
    }

    public GenericInternalInventoryCap getGenericInternalInventoryCap() {
        return this.genericInternalInventoryCap;
    }

    public StorageCap getStorageCap() {
        return this.storageCap;
    }

    public class ItemRecipeHandler
    extends RecipeHandlerTrait<Ingredient> {
        protected ItemRecipeHandler() {
            super(MEInterfaceTrait.this, ItemRecipeCapability.CAP);
        }

        protected IItemTransfer getSafeStorage() {
            ItemStackTransfer transfer = new ItemStackTransfer(MEInterfaceTrait.this.interfaceLogic.getStorage().size() / 2);
            for (int i = 0; i < transfer.getSlots(); ++i) {
                AEKey aEKey;
                GenericStack stack = MEInterfaceTrait.this.interfaceLogic.getStorage().getStack(i * 2);
                if (stack == null || !((aEKey = stack.what()) instanceof AEItemKey)) continue;
                AEItemKey itemKey = (AEItemKey)aEKey;
                transfer.setStackInSlot(i, itemKey.toStack((int)stack.amount()));
            }
            return transfer;
        }

        protected IItemTransfer getStorage() {
            ArrayList<IItemTransfer> transfers = new ArrayList<IItemTransfer>();
            for (int i = 0; i < MEInterfaceTrait.this.interfaceLogic.getStorage().size() / 2; ++i) {
                transfers.add(AEInterfaceSlotWidget.createAEItemTransfer(MEInterfaceTrait.this.interfaceLogic.getStorage(), i * 2));
            }
            return new ItemTransferList(transfers);
        }

        @Override
        public List<Ingredient> handleRecipeInner(IO io, MBDRecipe recipe, List<Ingredient> left, @Nullable String slotName, boolean simulate) {
            block15: {
                Iterator<Ingredient> iterator;
                IItemTransfer capability;
                block14: {
                    if (!this.compatibleWith(io)) {
                        return left;
                    }
                    capability = simulate ? this.getSafeStorage() : this.getStorage();
                    iterator = left.iterator();
                    if (io != IO.IN) break block14;
                    block0: while (iterator.hasNext()) {
                        Ingredient ingredient = iterator.next();
                        for (int i = 0; i < capability.getSlots(); ++i) {
                            ItemStack[] ingredientStacks;
                            ItemStack itemStack = capability.getStackInSlot(i);
                            if (!ingredient.test(itemStack)) continue;
                            for (ItemStack ingredientStack : ingredientStacks = ingredient.m_43908_()) {
                                if (!ingredientStack.m_150930_(itemStack.m_41720_())) continue;
                                ItemStack extracted = capability.extractItem(i, ingredientStack.m_41613_(), false);
                                ingredientStack.m_41764_(ingredientStack.m_41613_() - extracted.m_41613_());
                                if (!ingredientStack.m_41619_()) continue;
                                iterator.remove();
                                continue block0;
                            }
                        }
                    }
                    break block15;
                }
                if (io != IO.OUT) break block15;
                while (iterator.hasNext()) {
                    Ingredient ingredient = iterator.next();
                    ItemStack[] items = ingredient.m_43908_();
                    if (items.length == 0) {
                        iterator.remove();
                        continue;
                    }
                    if (items.length == 1) {
                        ItemStack output = items[0];
                        if (!output.m_41619_()) {
                            for (int i = 0; i < capability.getSlots(); ++i) {
                                ItemStack leftStack = capability.insertItem(i, output.m_41777_(), false);
                                output.m_41764_(leftStack.m_41613_());
                                if (output.m_41619_()) break;
                            }
                        }
                        if (!output.m_41619_()) continue;
                        iterator.remove();
                        continue;
                    }
                    List<ItemStack> shuffledItems = Arrays.asList(Arrays.copyOf(items, items.length));
                    MEInterfaceTrait.this.random.setSeed(MEInterfaceTrait.this.getMachine().getOffsetTimer());
                    Collections.shuffle(shuffledItems, MEInterfaceTrait.this.random);
                    int index = -1;
                    for (int i = 0; i < shuffledItems.size(); ++i) {
                        ItemStack output = shuffledItems.get(i).m_41777_();
                        if (!output.m_41619_()) {
                            for (int slot = 0; slot < capability.getSlots(); ++slot) {
                                ItemStack leftStack = capability.insertItem(slot, output.m_41777_(), true);
                                output.m_41764_(leftStack.m_41613_());
                                if (output.m_41619_()) break;
                            }
                        }
                        if (!output.m_41619_()) continue;
                        index = i;
                        break;
                    }
                    if (index == -1) continue;
                    if (!simulate) {
                        ItemStack output = shuffledItems.get(index);
                        for (int slot = 0; slot < capability.getSlots(); ++slot) {
                            ItemStack leftStack = capability.insertItem(slot, output.m_41777_(), true);
                            if (leftStack.m_41613_() >= output.m_41613_()) continue;
                            leftStack = capability.insertItem(slot, output.m_41777_(), false);
                            output.m_41764_(leftStack.m_41613_());
                            if (output.m_41619_()) break;
                        }
                    }
                    iterator.remove();
                }
            }
            return left.isEmpty() ? null : left;
        }
    }

    public class FluidRecipeHandler
    extends RecipeHandlerTrait<FluidIngredient> {
        protected FluidRecipeHandler() {
            super(MEInterfaceTrait.this, FluidRecipeCapability.CAP);
        }

        protected List<IFluidTransfer> getSafeStorage() {
            ArrayList<IFluidTransfer> storages = new ArrayList<IFluidTransfer>();
            for (int i = 0; i < MEInterfaceTrait.this.interfaceLogic.getStorage().size() / 2; ++i) {
                AEKey aEKey;
                FluidStorage transfer = new FluidStorage(MEInterfaceTrait.this.interfaceLogic.getStorage().getCapacity(AEKeyType.fluids()));
                GenericStack stack = MEInterfaceTrait.this.interfaceLogic.getStorage().getStack(i * 2 + 1);
                if (stack != null && (aEKey = stack.what()) instanceof AEFluidKey) {
                    AEFluidKey fluidKey = (AEFluidKey)aEKey;
                    transfer.setFluidInTank(0, FluidHelperImpl.toFluidStack((net.minecraftforge.fluids.FluidStack)fluidKey.toStack((int)stack.amount())));
                }
                storages.add((IFluidTransfer)transfer);
            }
            return storages;
        }

        protected List<IFluidTransfer> getStorage() {
            ArrayList<IFluidTransfer> storages = new ArrayList<IFluidTransfer>();
            for (int i = 0; i < MEInterfaceTrait.this.interfaceLogic.getStorage().size() / 2; ++i) {
                storages.add(AEInterfaceSlotWidget.createAEFluidTransfer(MEInterfaceTrait.this.interfaceLogic.getStorage(), i * 2 + 1));
            }
            return storages;
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, MBDRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
            if (!this.compatibleWith(io)) {
                return left;
            }
            List<IFluidTransfer> capabilities = simulate ? this.getSafeStorage() : this.getStorage();
            for (IFluidTransfer capability : capabilities) {
                Iterator<FluidIngredient> iterator = left.iterator();
                if (io == IO.IN) {
                    while (iterator.hasNext()) {
                        fluidStack = iterator.next();
                        if (fluidStack.isEmpty()) {
                            iterator.remove();
                            continue;
                        }
                        boolean found = false;
                        FluidStack foundStack = null;
                        for (int i = 0; i < capability.getTanks(); ++i) {
                            FluidStack stored = capability.getFluidInTank(i);
                            if (!fluidStack.test(stored)) continue;
                            found = true;
                            foundStack = stored;
                        }
                        if (!found) continue;
                        FluidStack drained = capability.drain(foundStack.copy(fluidStack.getAmount()), false);
                        fluidStack.setAmount(fluidStack.getAmount() - drained.getAmount());
                        if (fluidStack.getAmount() > 0L) continue;
                        iterator.remove();
                    }
                } else if (io == IO.OUT) {
                    while (iterator.hasNext()) {
                        fluidStack = iterator.next();
                        if (fluidStack.isEmpty()) {
                            iterator.remove();
                            continue;
                        }
                        FluidStack[] fluids = fluidStack.getStacks();
                        if (fluids.length == 0) {
                            iterator.remove();
                            continue;
                        }
                        FluidStack output = fluids[0];
                        long filled = capability.fill(output.copy(), false);
                        if (!fluidStack.isEmpty()) {
                            fluidStack.setAmount(fluidStack.getAmount() - filled);
                        }
                        if (fluidStack.getAmount() > 0L) continue;
                        iterator.remove();
                    }
                }
                if (!left.isEmpty()) continue;
                break;
            }
            return left.isEmpty() ? null : left;
        }
    }

    public class ManagedGridNodeCap
    implements ICapabilityProviderTrait<IInWorldGridNodeHost> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return MEInterfaceTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IInWorldGridNodeHost> getCapability() {
            return Capabilities.IN_WORLD_GRID_NODE_HOST;
        }

        @Override
        public IInWorldGridNodeHost getCapContent(IO capabilityIO) {
            return capabilityIO != IO.NONE ? MEInterfaceTrait.this : null;
        }
    }

    public class GenericInternalInventoryCap
    implements ICapabilityProviderTrait<GenericInternalInventory> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return MEInterfaceTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<GenericInternalInventory> getCapability() {
            return Capabilities.GENERIC_INTERNAL_INV;
        }

        @Override
        public GenericInternalInventory getCapContent(IO capabilityIO) {
            return capabilityIO != IO.NONE ? MEInterfaceTrait.this.interfaceLogic.getStorage() : null;
        }
    }

    public class StorageCap
    implements ICapabilityProviderTrait<MEStorage> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return MEInterfaceTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<MEStorage> getCapability() {
            return Capabilities.STORAGE;
        }

        @Override
        public MEStorage getCapContent(IO capabilityIO) {
            return capabilityIO != IO.NONE ? MEInterfaceTrait.this.interfaceLogic.getInventory() : null;
        }
    }
}

