/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.integration.ae2.trait;

import appeng.api.config.Actionable;
import appeng.api.stacks.AEFluidKey;
import appeng.api.stacks.AEItemKey;
import appeng.api.stacks.AEKey;
import appeng.api.stacks.AEKeyType;
import appeng.api.stacks.GenericStack;
import appeng.util.ConfigInventory;
import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.PhantomSlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.PhantomTankWidget;
import com.lowdragmc.lowdraglib.gui.widget.SlotWidget;
import com.lowdragmc.lowdraglib.gui.widget.TankWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.jei.IngredientIO;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.side.item.IItemTransfer;
import com.lowdragmc.mbd2.integration.ae2.trait.SerializableInterfaceLogic;
import java.util.Optional;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.minecraft.world.level.ItemLike;
import net.minecraft.world.level.material.Fluid;
import org.jetbrains.annotations.NotNull;

@LDLRegister(name="ae_interface_slot", group="widget.container", modID="ae2")
public class AEInterfaceSlotWidget
extends WidgetGroup {
    private PhantomSlotWidget phantomSlot = new PhantomSlotWidget();
    private SlotWidget slot = new SlotWidget();
    private PhantomTankWidget phantomTank = new PhantomTankWidget();
    private TankWidget tank = new TankWidget();
    @Nullable
    private SerializableInterfaceLogic interfaceLogic;
    private int slotIndex;

    public AEInterfaceSlotWidget() {
        super(0, 0, 20, 74);
        this.phantomSlot.setSelfPosition(1, 1);
        this.slot.setSelfPosition(1, 19);
        this.phantomSlot.setId("phantom_slot");
        this.slot.setId("slot");
        this.phantomTank.setSelfPosition(1, 37);
        this.tank.setSelfPosition(1, 55);
        this.phantomTank.setId("phantom_tank");
        this.tank.setId("tank");
        this.addWidget((Widget)this.phantomSlot);
        this.addWidget((Widget)this.slot);
        this.addWidget((Widget)this.phantomTank);
        this.addWidget((Widget)this.tank);
    }

    public void initTemplate() {
        this.phantomSlot.initTemplate();
        this.slot.initTemplate();
        this.phantomSlot.setBackgroundTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{SlotWidget.ITEM_SLOT_TEXTURE, Icons.DOWN.copy().setColor(ColorPattern.GRAY.color).scale(0.8f)}));
        this.phantomTank.setBackground((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{TankWidget.FLUID_SLOT_TEXTURE, Icons.DOWN.copy().setColor(ColorPattern.GRAY.color).scale(0.8f)}));
    }

    public void setItemInterfaceLogic(SerializableInterfaceLogic interfaceLogic, int slotIndex) {
        this.interfaceLogic = interfaceLogic;
        this.slotIndex = slotIndex;
        this.slot.setHandlerSlot(AEInterfaceSlotWidget.createAEItemTransfer(interfaceLogic.getStorage(), slotIndex * 2), 0);
        this.phantomSlot.setHandlerSlot(AEInterfaceSlotWidget.createAEItemTransfer(interfaceLogic.getConfig(), slotIndex * 2), 0);
        this.tank.setFluidTank(AEInterfaceSlotWidget.createAEFluidTransfer(interfaceLogic.getStorage(), slotIndex * 2 + 1), 0);
        this.phantomTank.setFluidTank(AEInterfaceSlotWidget.createAEFluidTransfer(interfaceLogic.getConfig(), slotIndex * 2 + 1), 0);
    }

    public void setIngredientIO(IngredientIO ingredientIO) {
        this.slot.setIngredientIO(ingredientIO);
        this.tank.setIngredientIO(ingredientIO);
    }

    public void setCanTakeItems(boolean support) {
        this.slot.setCanTakeItems(support);
        this.tank.setAllowClickFilled(support);
    }

    public void setCanPutItems(boolean support) {
        this.slot.setCanPutItems(support);
        this.tank.setAllowClickDrained(support);
    }

    @NotNull
    public static IItemTransfer createAEItemTransfer(final ConfigInventory inventory, final int slotIndex) {
        return new IItemTransfer(){

            public int getSlots() {
                return 1;
            }

            @NotNull
            public ItemStack getStackInSlot(int slot) {
                return Optional.ofNullable(inventory.getStack(slotIndex)).map(stack -> {
                    AEKey patt4147$temp = stack.what();
                    if (patt4147$temp instanceof AEItemKey) {
                        AEItemKey itemKey = (AEItemKey)patt4147$temp;
                        return new ItemStack((ItemLike)itemKey.getItem(), (int)stack.amount());
                    }
                    return ItemStack.f_41583_;
                }).orElse(ItemStack.f_41583_);
            }

            public void setStackInSlot(int index, ItemStack stack) {
                if (index != 0) {
                    return;
                }
                if (stack.m_41619_()) {
                    inventory.setStack(slotIndex, null);
                } else {
                    inventory.setStack(slotIndex, new GenericStack((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_()));
                }
            }

            @NotNull
            public ItemStack insertItem(int slot, @NotNull ItemStack stack, boolean simulate, boolean notifyChanges) {
                if (!inventory.canInsert()) {
                    return stack;
                }
                long inserted = inventory.insert(slotIndex, (AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_(), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
                return stack.m_255036_((int)((long)stack.m_41613_() - inserted));
            }

            @NotNull
            public ItemStack extractItem(int slot, int amount, boolean simulate, boolean notifyChanges) {
                AEItemKey itemKey;
                AEKey aEKey;
                if (!inventory.canExtract() || !((aEKey = inventory.getKey(slotIndex)) instanceof AEItemKey) || (itemKey = (AEItemKey)aEKey).getItem() == Items.f_41852_) {
                    return ItemStack.f_41583_;
                }
                long extracted = inventory.extract(slotIndex, (AEKey)itemKey, (long)amount, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
                return new ItemStack((ItemLike)itemKey.getItem(), (int)extracted);
            }

            public int getSlotLimit(int slot) {
                return (int)inventory.getCapacity(AEKeyType.items());
            }

            public boolean isItemValid(int slot, @NotNull ItemStack stack) {
                return inventory.isAllowed(new GenericStack((AEKey)AEItemKey.of((ItemStack)stack), (long)stack.m_41613_()));
            }

            @NotNull
            public Object createSnapshot() {
                return new Object();
            }

            public void restoreFromSnapshot(Object snapshot) {
            }
        };
    }

    @NotNull
    public static IFluidTransfer createAEFluidTransfer(final ConfigInventory inventory, final int slotIndex) {
        return new IFluidTransfer(){

            public int getTanks() {
                return 1;
            }

            @NotNull
            public FluidStack getFluidInTank(int tank) {
                return Optional.ofNullable(inventory.getStack(slotIndex)).map(stack -> {
                    AEKey patt6862$temp = stack.what();
                    if (patt6862$temp instanceof AEFluidKey) {
                        AEFluidKey fluidKey = (AEFluidKey)patt6862$temp;
                        return FluidStack.create((Fluid)fluidKey.getFluid(), (long)stack.amount(), (CompoundTag)fluidKey.copyTag());
                    }
                    return FluidStack.empty();
                }).orElse(FluidStack.empty());
            }

            public void setFluidInTank(int tank, @NotNull FluidStack fluidStack) {
                if (tank != 0) {
                    return;
                }
                if (fluidStack.isEmpty()) {
                    inventory.setStack(slotIndex, null);
                } else {
                    inventory.setStack(slotIndex, new GenericStack((AEKey)AEFluidKey.of((net.minecraftforge.fluids.FluidStack)FluidHelperImpl.toFluidStack((FluidStack)fluidStack)), fluidStack.getAmount()));
                }
            }

            public long getTankCapacity(int tank) {
                return inventory.getCapacity(AEKeyType.fluids());
            }

            public boolean isFluidValid(int tank, @NotNull FluidStack stack) {
                return inventory.isAllowed(new GenericStack((AEKey)AEFluidKey.of((net.minecraftforge.fluids.FluidStack)FluidHelperImpl.toFluidStack((FluidStack)stack)), stack.getAmount()));
            }

            public long fill(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
                if (!inventory.canInsert()) {
                    return 0L;
                }
                return inventory.insert(slotIndex, (AEKey)AEFluidKey.of((net.minecraftforge.fluids.FluidStack)FluidHelperImpl.toFluidStack((FluidStack)resource)), resource.getAmount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
            }

            public boolean supportsFill(int tank) {
                return inventory.canInsert();
            }

            @NotNull
            public FluidStack drain(int tank, FluidStack resource, boolean simulate, boolean notifyChanges) {
                AEFluidKey fluidKey;
                block3: {
                    block2: {
                        AEKey aEKey;
                        if (!inventory.canExtract() || !((aEKey = inventory.getKey(slotIndex)) instanceof AEFluidKey)) break block2;
                        fluidKey = (AEFluidKey)aEKey;
                        if (!FluidHelperImpl.toFluidStack((FluidStack)resource).isEmpty() && fluidKey.getFluid().m_6212_(FluidHelperImpl.toFluidStack((FluidStack)resource).getFluid())) break block3;
                    }
                    return FluidStack.empty();
                }
                long drained = inventory.extract(slotIndex, (AEKey)fluidKey, resource.getAmount(), simulate ? Actionable.SIMULATE : Actionable.MODULATE);
                return FluidStack.create((Fluid)fluidKey.getFluid(), (long)drained, (CompoundTag)fluidKey.copyTag());
            }

            @NotNull
            public FluidStack drain(long maxDrain, boolean simulate, boolean notifyChanges) {
                AEKey aEKey;
                if (!inventory.canExtract() || !((aEKey = inventory.getKey(slotIndex)) instanceof AEFluidKey)) {
                    return FluidStack.empty();
                }
                AEFluidKey fluidKey = (AEFluidKey)aEKey;
                long extracted = inventory.extract(slotIndex, (AEKey)fluidKey, maxDrain, simulate ? Actionable.SIMULATE : Actionable.MODULATE);
                return FluidStack.create((Fluid)fluidKey.getFluid(), (long)extracted, (CompoundTag)fluidKey.copyTag());
            }

            public boolean supportsDrain(int tank) {
                return inventory.canExtract();
            }

            @NotNull
            public Object createSnapshot() {
                return new Object();
            }

            public void restoreFromSnapshot(Object snapshot) {
            }
        };
    }

    public void deserializeInnerNBT(CompoundTag nbt) {
        super.deserializeInnerNBT(nbt);
        for (Widget widget : this.widgets) {
            TankWidget tankWidget;
            PhantomTankWidget phantomTankWidget;
            SlotWidget slotWidget;
            PhantomSlotWidget phantomSlotWidget;
            if (widget instanceof PhantomSlotWidget && (phantomSlotWidget = (PhantomSlotWidget)widget).getId().equals("phantom_slot")) {
                this.phantomSlot = phantomSlotWidget;
                continue;
            }
            if (widget instanceof SlotWidget && (slotWidget = (SlotWidget)widget).getId().equals("slot")) {
                this.slot = slotWidget;
                continue;
            }
            if (widget instanceof PhantomTankWidget && (phantomTankWidget = (PhantomTankWidget)widget).getId().equals("phantom_tank")) {
                this.phantomTank = phantomTankWidget;
                continue;
            }
            if (!(widget instanceof TankWidget) || !(tankWidget = (TankWidget)widget).getId().equals("tank")) continue;
            this.tank = tankWidget;
        }
    }

    @Nullable
    public SerializableInterfaceLogic getInterfaceLogic() {
        return this.interfaceLogic;
    }

    public int getSlotIndex() {
        return this.slotIndex;
    }
}

