/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.forgeenergy;

import com.lowdragmc.lowdraglib.syncdata.IContentChangeAware;
import com.lowdragmc.lowdraglib.syncdata.ITagSerializable;
import net.minecraft.nbt.Tag;
import net.minecraftforge.energy.EnergyStorage;

public class CopiableEnergyStorage
extends EnergyStorage
implements ITagSerializable<Tag>,
IContentChangeAware {
    public Runnable onContentsChanged;

    public CopiableEnergyStorage(int capacity) {
        super(capacity);
        this.onContentsChanged = () -> {};
    }

    public CopiableEnergyStorage(int capacity, int energy) {
        super(capacity, capacity, capacity, energy);
        this.onContentsChanged = () -> {};
    }

    public int receiveEnergy(int maxReceive, boolean simulate) {
        int received = super.receiveEnergy(maxReceive, simulate);
        if (received > 0) {
            this.onContentsChanged.run();
        }
        return received;
    }

    public int extractEnergy(int maxExtract, boolean simulate) {
        int extracted = super.extractEnergy(maxExtract, simulate);
        if (extracted > 0) {
            this.onContentsChanged.run();
        }
        return extracted;
    }

    public CopiableEnergyStorage copy() {
        return new CopiableEnergyStorage(this.capacity, this.energy);
    }

    public void deserializeNBT(Tag tag) {
        super.deserializeNBT(tag);
    }

    public Tag serializeNBT() {
        return super.serializeNBT();
    }

    public Runnable getOnContentsChanged() {
        return this.onContentsChanged;
    }

    public void setOnContentsChanged(Runnable onContentsChanged) {
        this.onContentsChanged = onContentsChanged;
    }
}

