/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.fluid;

import com.google.common.base.Predicates;
import com.lowdragmc.lowdraglib.misc.FluidStorage;
import com.lowdragmc.lowdraglib.misc.FluidTransferList;
import com.lowdragmc.lowdraglib.side.fluid.FluidStack;
import com.lowdragmc.lowdraglib.side.fluid.FluidTransferHelper;
import com.lowdragmc.lowdraglib.side.fluid.IFluidTransfer;
import com.lowdragmc.lowdraglib.side.fluid.forge.FluidHelperImpl;
import com.lowdragmc.lowdraglib.syncdata.annotation.DescSynced;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.syncdata.field.ManagedFieldHolder;
import com.lowdragmc.mbd2.api.capability.recipe.IO;
import com.lowdragmc.mbd2.api.capability.recipe.IRecipeHandlerTrait;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.ingredient.FluidIngredient;
import com.lowdragmc.mbd2.common.capability.recipe.FluidRecipeCapability;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.AutoIO;
import com.lowdragmc.mbd2.common.trait.AutoWorldIO;
import com.lowdragmc.mbd2.common.trait.IAutoIOTrait;
import com.lowdragmc.mbd2.common.trait.ICapabilityProviderTrait;
import com.lowdragmc.mbd2.common.trait.RecipeHandlerTrait;
import com.lowdragmc.mbd2.common.trait.SimpleCapabilityTrait;
import com.lowdragmc.mbd2.common.trait.fluid.FluidHandlerList;
import com.lowdragmc.mbd2.common.trait.fluid.FluidHandlerWrapper;
import com.lowdragmc.mbd2.common.trait.fluid.FluidTankCapabilityTraitDefinition;
import java.util.Arrays;
import java.util.Iterator;
import java.util.List;
import java.util.function.Predicate;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.world.level.BlockAndTintGetter;
import net.minecraft.world.level.Level;
import net.minecraft.world.level.block.Block;
import net.minecraft.world.level.block.Blocks;
import net.minecraft.world.level.block.LiquidBlock;
import net.minecraft.world.level.block.state.BlockState;
import net.minecraft.world.level.material.Fluid;
import net.minecraft.world.level.material.Fluids;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.common.capabilities.Capability;
import net.minecraftforge.common.capabilities.ForgeCapabilities;
import net.minecraftforge.fluids.capability.IFluidHandler;
import org.jetbrains.annotations.Nullable;

public class FluidTankCapabilityTrait
extends SimpleCapabilityTrait
implements IAutoIOTrait {
    public static final ManagedFieldHolder MANAGED_FIELD_HOLDER = new ManagedFieldHolder(FluidTankCapabilityTrait.class);
    @Persisted
    @DescSynced
    public final FluidStorage[] storages;
    protected boolean allowSameFluids;
    private Boolean isEmpty;
    private final FluidRecipeHandler recipeHandler = new FluidRecipeHandler();
    private final FluidHandlerCap fluidHandlerCap = new FluidHandlerCap();

    public ManagedFieldHolder getFieldHolder() {
        return MANAGED_FIELD_HOLDER;
    }

    public FluidTankCapabilityTrait(MBDMachine machine, FluidTankCapabilityTraitDefinition definition) {
        super(machine, definition);
        this.storages = this.createStorages();
    }

    @Override
    public FluidTankCapabilityTraitDefinition getDefinition() {
        return (FluidTankCapabilityTraitDefinition)super.getDefinition();
    }

    @Override
    public void onLoadingTraitInPreview() {
        if (this.storages.length > 0) {
            this.storages[0].setFluid(FluidStack.create((Fluid)Fluids.f_76193_, (long)Math.max(this.getDefinition().getCapacity() / 2, 1)));
        }
    }

    protected FluidStorage[] createStorages() {
        FluidStorage[] storages = new FluidStorage[this.getDefinition().getTankSize()];
        for (int i = 0; i < storages.length; ++i) {
            storages[i] = new FluidStorage((long)this.getDefinition().getCapacity());
            storages[i].setOnContentsChanged(this::onContentsChanged);
            if (!this.getDefinition().getFluidFilterSettings().isEnable()) continue;
            storages[i].setValidator((Predicate)this.getDefinition().getFluidFilterSettings());
        }
        return storages;
    }

    public void onContentsChanged() {
        this.isEmpty = null;
        this.notifyListeners();
    }

    public boolean isEmpty() {
        if (this.isEmpty == null) {
            this.isEmpty = true;
            for (FluidStorage storage : this.storages) {
                if (storage.getFluid().isEmpty()) continue;
                this.isEmpty = false;
                break;
            }
        }
        return this.isEmpty;
    }

    @Override
    public void serverTick() {
        BlockState state;
        BlockPos pos;
        int z;
        int y;
        int x;
        AABB range;
        int leftBlocks;
        IAutoIOTrait.super.serverTick();
        long timer = this.getMachine().getOffsetTimer();
        AutoWorldIO autoInput = this.getDefinition().getAutoInput();
        AutoWorldIO autoOutput = this.getDefinition().getAutoOutput();
        Level level = this.getMachine().getLevel();
        if (autoInput.isEnable() && timer % (long)autoInput.getInterval() == 0L) {
            leftBlocks = autoInput.getSpeed();
            range = autoOutput.getRotatedRange(this.getMachine().getFrontFacing().orElse(Direction.NORTH)).m_82338_(this.getMachine().getPos());
            for (x = (int)Math.round(range.f_82288_); x < (int)Math.round(range.f_82291_) && leftBlocks > 0; ++x) {
                for (y = (int)Math.round(range.f_82289_); y < (int)Math.round(range.f_82292_) && leftBlocks > 0; ++y) {
                    block2: for (z = (int)Math.round(range.f_82290_); z < (int)Math.round(range.f_82293_) && leftBlocks > 0; ++z) {
                        pos = new BlockPos(x, y, z);
                        state = level.m_8055_(pos);
                        Block block = state.m_60734_();
                        if (!(block instanceof LiquidBlock)) continue;
                        LiquidBlock liquidBlock = (LiquidBlock)block;
                        if (!state.m_60819_().m_76170_()) continue;
                        FluidStack toFilled = FluidStack.create((Fluid)liquidBlock.getFluid().m_5613_(), (long)1000L);
                        for (FluidStorage storage : this.storages) {
                            if (storage.fill(toFilled, true) != 1000L) continue;
                            storage.fill(toFilled, false);
                            --leftBlocks;
                            level.m_46597_(pos, Blocks.f_50016_.m_49966_());
                            continue block2;
                        }
                    }
                }
            }
        }
        if (autoOutput.isEnable() && timer % (long)autoOutput.getInterval() == 0L) {
            leftBlocks = autoOutput.getSpeed();
            range = autoOutput.getRotatedRange(this.getMachine().getFrontFacing().orElse(Direction.NORTH)).m_82338_(this.getMachine().getPos());
            for (x = (int)Math.round(range.f_82288_); x < (int)Math.round(range.f_82291_) && leftBlocks > 0 && !this.isEmpty(); ++x) {
                for (y = (int)Math.round(range.f_82289_); y < (int)Math.round(range.f_82292_) && leftBlocks > 0 && !this.isEmpty(); ++y) {
                    block6: for (z = (int)Math.round(range.f_82290_); z < (int)Math.round(range.f_82293_) && leftBlocks > 0 && !this.isEmpty(); ++z) {
                        pos = new BlockPos(x, y, z);
                        state = level.m_8055_(pos);
                        for (FluidStorage storage : this.storages) {
                            FluidStack drained = storage.drain(1000L, true);
                            if (drained.getAmount() != 1000L || !drained.getFluid().getFluidType().canBePlacedInLevel((BlockAndTintGetter)level, pos, FluidHelperImpl.toFluidStack((FluidStack)drained)) || state.m_60819_().m_76170_() || !state.m_60722_(drained.getFluid())) continue;
                            if (!level.f_46443_) {
                                level.m_46961_(pos, true);
                            }
                            level.m_46597_(pos, drained.getFluid().m_76145_().m_76188_());
                            --leftBlocks;
                            storage.drain(1000L, false);
                            continue block6;
                        }
                    }
                }
            }
        }
    }

    @Override
    public List<IRecipeHandlerTrait<?>> getRecipeHandlerTraits() {
        return List.of(this.recipeHandler);
    }

    @Override
    public List<ICapabilityProviderTrait<?>> getCapabilityProviderTraits() {
        return List.of(this.fluidHandlerCap);
    }

    @Override
    @Nullable
    public AutoIO getAutoIO() {
        return this.getDefinition().getAutoIO().isEnable() ? this.getDefinition().getAutoIO() : null;
    }

    @Override
    public void handleAutoIO(BlockPos port, Direction side, IO io) {
        if (io.support(IO.IN)) {
            FluidTransferHelper.importToTarget((IFluidTransfer)new FluidTransferList((IFluidTransfer[])this.storages), (int)Integer.MAX_VALUE, (Predicate)(this.getDefinition().getFluidFilterSettings().isEnable() ? this.getDefinition().getFluidFilterSettings() : Predicates.alwaysTrue()), (Level)this.getMachine().getLevel(), (BlockPos)port.m_121945_(side), (Direction)side.m_122424_());
        }
        if (io.support(IO.OUT)) {
            FluidTransferHelper.exportToTarget((IFluidTransfer)new FluidTransferList((IFluidTransfer[])this.storages), (int)Integer.MAX_VALUE, (Predicate)Predicates.alwaysTrue(), (Level)this.getMachine().getLevel(), (BlockPos)port.m_121945_(side), (Direction)side.m_122424_());
        }
    }

    public void setAllowSameFluids(boolean allowSameFluids) {
        this.allowSameFluids = allowSameFluids;
    }

    public class FluidRecipeHandler
    extends RecipeHandlerTrait<FluidIngredient> {
        protected FluidRecipeHandler() {
            super(FluidTankCapabilityTrait.this, FluidRecipeCapability.CAP);
        }

        @Override
        public List<FluidIngredient> handleRecipeInner(IO io, MBDRecipe recipe, List<FluidIngredient> left, @Nullable String slotName, boolean simulate) {
            FluidStorage[] capabilities;
            if (!this.compatibleWith(io)) {
                return left;
            }
            for (FluidStorage capability : capabilities = simulate ? (FluidStorage[])Arrays.stream(FluidTankCapabilityTrait.this.storages).map(FluidStorage::copy).toArray(FluidStorage[]::new) : FluidTankCapabilityTrait.this.storages) {
                Iterator<FluidIngredient> iterator = left.iterator();
                if (io == IO.IN) {
                    while (iterator.hasNext()) {
                        fluidStack = iterator.next();
                        if (fluidStack.isEmpty()) {
                            iterator.remove();
                            continue;
                        }
                        boolean found = false;
                        FluidStack foundStack = null;
                        for (int i = 0; i < capability.getTanks(); ++i) {
                            FluidStack stored = capability.getFluidInTank(i);
                            if (!fluidStack.test(stored)) continue;
                            found = true;
                            foundStack = stored;
                        }
                        if (!found) continue;
                        FluidStack drained = capability.drain(foundStack.copy(fluidStack.getAmount()), false);
                        fluidStack.setAmount(fluidStack.getAmount() - drained.getAmount());
                        if (fluidStack.getAmount() > 0L) continue;
                        iterator.remove();
                    }
                } else if (io == IO.OUT) {
                    while (iterator.hasNext()) {
                        fluidStack = iterator.next();
                        if (fluidStack.isEmpty()) {
                            iterator.remove();
                            continue;
                        }
                        FluidStack[] fluids = fluidStack.getStacks();
                        if (fluids.length == 0) {
                            iterator.remove();
                            continue;
                        }
                        FluidStack output = fluids[0];
                        long filled = capability.fill(output.copy(), false);
                        if (!fluidStack.isEmpty()) {
                            fluidStack.setAmount(fluidStack.getAmount() - filled);
                        }
                        if (fluidStack.getAmount() > 0L) continue;
                        iterator.remove();
                    }
                }
                if (left.isEmpty()) break;
            }
            return left.isEmpty() ? null : left;
        }
    }

    public class FluidHandlerCap
    implements ICapabilityProviderTrait<IFluidHandler> {
        @Override
        public IO getCapabilityIO(@Nullable Direction side) {
            return FluidTankCapabilityTrait.this.getCapabilityIO(side);
        }

        @Override
        public Capability<IFluidHandler> getCapability() {
            return ForgeCapabilities.FLUID_HANDLER;
        }

        @Override
        public IFluidHandler getCapContent(IO capbilityIO) {
            return new FluidHandlerWrapper(FluidTankCapabilityTrait.this.storages, capbilityIO, FluidTankCapabilityTrait.this.getDefinition().isAllowSameFluids());
        }

        @Override
        public IFluidHandler mergeContents(List<IFluidHandler> contents) {
            return new FluidHandlerList(contents.toArray(new IFluidHandler[0]));
        }
    }
}

