/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait.entity;

import com.lowdragmc.lowdraglib.client.utils.RenderBufferUtils;
import com.lowdragmc.lowdraglib.gui.editor.annotation.ConfigSetter;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ItemStackTexture;
import com.lowdragmc.lowdraglib.utils.ColorUtils;
import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import com.lowdragmc.mbd2.common.gui.editor.machine.MachineTraitPanel;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import com.lowdragmc.mbd2.common.trait.ITrait;
import com.lowdragmc.mbd2.common.trait.RecipeCapabilityTraitDefinition;
import com.lowdragmc.mbd2.common.trait.entity.EntityHandlerTrait;
import com.mojang.blaze3d.systems.RenderSystem;
import com.mojang.blaze3d.vertex.BufferBuilder;
import com.mojang.blaze3d.vertex.DefaultVertexFormat;
import com.mojang.blaze3d.vertex.PoseStack;
import com.mojang.blaze3d.vertex.Tesselator;
import com.mojang.blaze3d.vertex.VertexConsumer;
import com.mojang.blaze3d.vertex.VertexFormat;
import java.util.EnumMap;
import java.util.Map;
import javax.annotation.Nullable;
import net.minecraft.client.renderer.GameRenderer;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.Items;
import net.minecraft.world.phys.AABB;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegister(name="entity_handler", group="trait", priority=-99)
public class EntityHandlerTraitDefinition
extends RecipeCapabilityTraitDefinition {
    @Configurable(name="config.definition.trait.entity_handler.area", tips={"config.definition.trait.entity_handler.area.tooltip.0", "config.definition.trait.entity_handler.area.tooltip.1"})
    @DefaultValue(numberValue={-1.0, -1.0, -1.0, 2.0, 2.0, 2.0})
    private AABB area = new AABB(-1.0, -1.0, -1.0, 2.0, 2.0, 2.0);
    private final Map<Direction, AABB> areaCache = new EnumMap<Direction, AABB>(Direction.class);

    @Override
    public ITrait createTrait(MBDMachine machine) {
        return new EntityHandlerTrait(machine, this);
    }

    @Override
    public IGuiTexture getIcon() {
        return new ItemStackTexture(new Item[]{Items.f_42630_});
    }

    @ConfigSetter(field="area")
    public void setArea(AABB area) {
        this.area = area;
        this.areaCache.clear();
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        this.areaCache.clear();
    }

    public AABB getArea(@Nullable Direction direction) {
        return direction == Direction.NORTH || direction == null ? this.area : this.areaCache.computeIfAbsent(direction, dir -> ShapeUtils.rotate((AABB)this.area, (Direction)dir));
    }

    @Override
    @OnlyIn(value=Dist.CLIENT)
    public void renderAfterWorldInTraitPanel(MachineTraitPanel panel) {
        super.renderAfterWorldInTraitPanel(panel);
        PoseStack poseStack = new PoseStack();
        Tesselator tessellator = Tesselator.m_85913_();
        BufferBuilder buffer = tessellator.m_85915_();
        RenderSystem.enableBlend();
        RenderSystem.disableDepthTest();
        RenderSystem.blendFunc((int)770, (int)771);
        poseStack.m_85836_();
        RenderSystem.disableCull();
        RenderSystem.setShader(GameRenderer::m_172757_);
        buffer.m_166779_(VertexFormat.Mode.LINES, DefaultVertexFormat.f_166851_);
        RenderSystem.lineWidth((float)5.0f);
        int color = -15619346;
        RenderBufferUtils.drawCubeFrame((PoseStack)poseStack, (VertexConsumer)buffer, (float)((float)this.area.f_82288_), (float)((float)this.area.f_82289_), (float)((float)this.area.f_82290_), (float)((float)this.area.f_82291_), (float)((float)this.area.f_82292_), (float)((float)this.area.f_82293_), (float)ColorUtils.red((int)color), (float)ColorUtils.green((int)color), (float)ColorUtils.blue((int)color), (float)ColorUtils.alpha((int)color));
        tessellator.m_85914_();
        poseStack.m_85849_();
        RenderSystem.enableDepthTest();
        RenderSystem.enableCull();
    }

    public AABB getArea() {
        return this.area;
    }
}

