/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.trait;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.DefaultValue;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IToggleConfigurable;
import com.lowdragmc.lowdraglib.syncdata.annotation.Persisted;
import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import java.util.EnumMap;
import java.util.Map;
import net.minecraft.core.Direction;
import net.minecraft.world.phys.AABB;

public class AutoWorldIO
implements IToggleConfigurable {
    @Persisted
    public boolean enable;
    @Configurable(name="config.definition.trait.auto_world_io.range", tips={"config.definition.trait.auto_world_io.range.tooltip"})
    @DefaultValue(numberValue={-1.0, -1.0, -1.0, 2.0, 2.0, 2.0})
    public AABB range = new AABB(-1.0, -1.0, -1.0, 2.0, 2.0, 2.0);
    @Configurable(name="config.definition.trait.auto_world_io.interval", tips={"config.definition.trait.auto_world_io.interval.tooltip"})
    @NumberRange(range={1.0, 2.147483647E9})
    public int interval = 20;
    @Configurable(name="config.definition.trait.auto_world_io.speed", tips={"config.definition.trait.auto_world_io.speed.tooltip"})
    @NumberRange(range={1.0, 2.147483647E9})
    public int speed = 64;
    private final Map<Direction, AABB> rangeCache = new EnumMap<Direction, AABB>(Direction.class);

    public AABB getRotatedRange(Direction direction) {
        return direction == Direction.NORTH || direction == null ? this.range : this.rangeCache.computeIfAbsent(direction, dir -> ShapeUtils.rotate((AABB)this.range, (Direction)dir));
    }

    public void setEnable(boolean enable) {
        this.enable = enable;
    }

    public AutoWorldIO setRange(AABB range) {
        this.range = range;
        return this;
    }

    public AutoWorldIO setInterval(int interval) {
        this.interval = interval;
        return this;
    }

    public AutoWorldIO setSpeed(int speed) {
        this.speed = speed;
        return this;
    }

    public boolean isEnable() {
        return this.enable;
    }

    public AABB getRange() {
        return this.range;
    }

    public int getInterval() {
        return this.interval;
    }

    public int getSpeed() {
        return this.speed;
    }

    public Map<Direction, AABB> getRangeCache() {
        return this.rangeCache;
    }
}

