/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.configurator.Configurator;
import com.lowdragmc.lowdraglib.gui.editor.configurator.ConfiguratorGroup;
import com.lowdragmc.lowdraglib.gui.editor.configurator.SearchComponentConfigurator;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import java.util.function.Consumer;
import javax.annotation.Nonnull;
import net.minecraft.client.Minecraft;
import net.minecraft.core.Registry;
import net.minecraft.core.registries.Registries;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.util.GsonHelper;
import net.minecraft.world.level.Level;

public class DimensionCondition
extends RecipeCondition {
    public static final DimensionCondition INSTANCE = new DimensionCondition();
    private ResourceLocation dimension = new ResourceLocation("dummy");

    public DimensionCondition(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    @Override
    public String getType() {
        return "dimension";
    }

    @Override
    public Component getTooltips() {
        return Component.m_237110_((String)"recipe.condition.dimension.tooltip", (Object[])new Object[]{this.dimension});
    }

    @Override
    public boolean test(@Nonnull MBDRecipe recipe, @Nonnull RecipeLogic recipeLogic) {
        Level level = recipeLogic.machine.getLevel();
        return level != null && this.dimension.equals((Object)level.m_46472_().m_135782_());
    }

    @Override
    @Nonnull
    public JsonObject serialize() {
        JsonObject config = super.serialize();
        config.addProperty("dim", this.dimension.toString());
        return config;
    }

    @Override
    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        super.deserialize(config);
        this.dimension = new ResourceLocation(GsonHelper.m_13851_((JsonObject)config, (String)"dim", (String)"dummy"));
        return this;
    }

    @Override
    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        super.fromNetwork(buf);
        this.dimension = new ResourceLocation(buf.m_130277_());
        return this;
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf) {
        super.toNetwork(buf);
        buf.m_130070_(this.dimension.toString());
    }

    @Override
    public CompoundTag toNBT() {
        CompoundTag tag = super.toNBT();
        tag.m_128359_("dim", this.dimension.toString());
        return tag;
    }

    @Override
    public RecipeCondition fromNBT(CompoundTag tag) {
        super.fromNBT(tag);
        this.dimension = new ResourceLocation(tag.m_128461_("dim"));
        return this;
    }

    public void buildConfigurator(ConfiguratorGroup father) {
        super.buildConfigurator(father);
        SearchComponentConfigurator selector = new SearchComponentConfigurator(this.getTranslationKey(), () -> this.dimension, d -> {
            this.dimension = d;
        }, (Object)new ResourceLocation("dummy"), true, this::search, ResourceLocation::toString);
        selector.setUp(false);
        selector.setTips(new String[]{"config.recipe.condition.dimension.tooltip"});
        father.addConfigurators(new Configurator[]{selector});
    }

    protected void search(String word, Consumer<ResourceLocation> find) {
        String wordLower = word.toLowerCase();
        for (ResourceLocation biomeEntry : ((Registry)Minecraft.m_91087_().f_91073_.m_9598_().m_6632_(Registries.f_256787_).get()).m_6566_()) {
            if (Thread.currentThread().isInterrupted()) {
                return;
            }
            if (!biomeEntry.toString().contains(wordLower)) continue;
            find.accept(biomeEntry);
        }
    }

    public ResourceLocation getDimension() {
        return this.dimension;
    }

    public void setDimension(ResourceLocation dimension) {
        this.dimension = dimension;
    }

    public DimensionCondition() {
    }
}

