/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.machine.definition.config;

import com.lowdragmc.lowdraglib.client.renderer.IRenderer;
import com.lowdragmc.lowdraglib.client.renderer.impl.IModelRenderer;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.syncdata.IPersistedSerializable;
import com.lowdragmc.lowdraglib.utils.ShapeUtils;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.client.MachineSound;
import com.lowdragmc.mbd2.common.machine.definition.config.StateMachine;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleAABB;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleLightValue;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleMachineSound;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleRenderer;
import com.lowdragmc.mbd2.common.machine.definition.config.toggle.ToggleShape;
import com.lowdragmc.mbd2.integration.geckolib.GeckolibRenderer;
import dev.latvian.mods.rhino.util.HideFromJS;
import java.util.ArrayList;
import java.util.EnumMap;
import java.util.List;
import java.util.Map;
import java.util.function.BooleanSupplier;
import javax.annotation.Nullable;
import lombok.NonNull;
import net.minecraft.core.BlockPos;
import net.minecraft.core.Direction;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.Tag;
import net.minecraft.resources.ResourceLocation;
import net.minecraft.world.phys.AABB;
import net.minecraft.world.phys.shapes.Shapes;
import net.minecraft.world.phys.shapes.VoxelShape;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;
import org.jetbrains.annotations.NotNull;

public class MachineState
implements IConfigurable,
IPersistedSerializable,
Comparable<MachineState> {
    protected final String name;
    @NonNull
    protected List<MachineState> children;
    @Nullable
    protected MachineState parent;
    @Configurable(name="config.machine_state.renderer", subConfigurable=true, tips={"config.machine_state.renderer.tooltip.0", "config.machine_state.renderer.tooltip.1"})
    protected final ToggleRenderer renderer;
    @Configurable(name="config.machine_state.shape", subConfigurable=true, tips={"config.machine_state.shape.tooltip.0", "config.machine_state.shape.tooltip.1", "config.machine_state.shape.tooltip.2", "config.machine_state.shape.tooltip.3", "config.require_restart"})
    protected final ToggleShape shape;
    @Configurable(name="config.machine_state.light", subConfigurable=true, tips={"config.machine_state.light.tooltip.0", "config.machine_state.light.tooltip.1"})
    protected final ToggleLightValue lightLevel;
    @Configurable(name="config.machine_state.rendering_box", subConfigurable=true, tips={"config.machine_state.rendering_box.tooltip.0", "config.machine_state.rendering_box.tooltip.1", "config.machine_state.rendering_box.tooltip.2"})
    protected final ToggleAABB renderingBox;
    @Configurable(name="config.machine_state.is_global_visible", tips={"config.machine_state.is_global_visible.tooltip"})
    protected boolean isGlobalVisible = false;
    @Configurable(name="config.machine_state.rendering_radius", tips={"config.machine_state.rendering_radius.tooltip"})
    @NumberRange(range={1.0, 2.147483647E9})
    protected int renderingRadius = 64;
    @Configurable(name="config.machine_state.machine_sound", subConfigurable=true, tips={"config.machine_state.machine_sound.tooltip.0", "config.machine_state.machine_sound.tooltip.1", "config.machine_state.machine_sound.tooltip.2"})
    protected final ToggleMachineSound machineSound = new ToggleMachineSound();
    @Nullable
    private StateMachine<?> stateMachine;
    private final Map<Direction, VoxelShape> shapeCache = new EnumMap<Direction, VoxelShape>(Direction.class);
    private final Map<Direction, AABB> renderingBoxCache = new EnumMap<Direction, AABB>(Direction.class);

    public MachineState(String name, @NonNull List<MachineState> children, @Nullable IRenderer renderer, @Nullable VoxelShape shape, @Nullable Integer lightLevel, @Nullable AABB renderingBox) {
        if (children == null) {
            throw new NullPointerException("children is marked non-null but is null");
        }
        this.name = name;
        this.children = children;
        this.renderer = renderer == null ? new ToggleRenderer() : new ToggleRenderer(renderer);
        this.shape = shape == null ? new ToggleShape() : new ToggleShape(shape);
        this.lightLevel = lightLevel == null ? new ToggleLightValue() : new ToggleLightValue(lightLevel);
        this.renderingBox = renderingBox == null ? new ToggleAABB() : new ToggleAABB(renderingBox);
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = super.serializeNBT();
        tag.m_128359_("name", this.name);
        ListTag childrenList = new ListTag();
        for (MachineState child : this.children) {
            childrenList.add((Object)child.serializeNBT());
        }
        tag.m_128365_("children", (Tag)childrenList);
        return tag;
    }

    public void deserializeNBT(CompoundTag tag) {
        super.deserializeNBT(tag);
        ListTag childrenList = tag.m_128437_("children", 10);
        this.children = new ArrayList<MachineState>();
        for (int i = 0; i < childrenList.size(); ++i) {
            CompoundTag child = childrenList.m_128728_(i);
            this.children.add(this.createFromTag(child));
        }
        if (this.stateMachine != null) {
            this.stateMachine.initStateMachine();
        }
    }

    public boolean isRoot() {
        return this.parent == null;
    }

    public MachineState addChild(String name) {
        return this.addChild(this.newBuilder().name(name).build());
    }

    protected MachineState addChild(MachineState state) {
        this.children = new ArrayList<MachineState>(this.children);
        this.children.add(state);
        if (this.stateMachine != null) {
            state.parent = this;
            state.init(this.stateMachine);
        }
        return state;
    }

    public void removeChild(MachineState state) {
        this.children = this.children.stream().filter(s -> s != state).toList();
        if (this.stateMachine != null) {
            this.stateMachine.initStateMachine();
        }
        state.onRemoved();
    }

    private void onRemoved() {
        this.stateMachine = null;
        this.parent = null;
        this.children.forEach(MachineState::onRemoved);
    }

    protected void init(StateMachine stateMachine) {
        this.stateMachine = stateMachine;
        stateMachine.addState(this);
        for (MachineState child : this.children) {
            child.parent = this;
            child.init(stateMachine);
        }
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderer getRealRenderer() {
        return this.getRenderer();
    }

    @OnlyIn(value=Dist.CLIENT)
    public IRenderer getRenderer() {
        if (!this.renderer.isEnable() || this.renderer.getValue() == null) {
            if (this.parent != null) {
                return this.parent.getRenderer();
            }
            return IRenderer.EMPTY;
        }
        return this.renderer.getValue();
    }

    public VoxelShape getShape(@Nullable Direction direction) {
        if (!this.shape.isEnable() || this.shape.getValue() == null) {
            if (this.parent != null) {
                return this.parent.getShape(direction);
            }
            return Shapes.m_83144_();
        }
        VoxelShape value = this.shape.getValue();
        if (value.m_83281_() || value == Shapes.m_83144_() || direction == Direction.NORTH || direction == null) {
            return value;
        }
        return this.shapeCache.computeIfAbsent(direction, dir -> ShapeUtils.rotate((VoxelShape)value, (Direction)dir));
    }

    public int getLightLevel() {
        if (!this.lightLevel.isEnable() || this.lightLevel.getValue() == null) {
            if (this.parent != null) {
                return this.parent.getLightLevel();
            }
            return 0;
        }
        return this.lightLevel.getValue();
    }

    @Nullable
    public AABB getRenderingBox(@Nullable Direction direction) {
        if (!this.renderingBox.isEnable() || this.renderingBox.getValue() == null) {
            if (this.parent != null) {
                return this.parent.getRenderingBox(direction);
            }
            return null;
        }
        AABB value = this.renderingBox.getValue();
        return direction == Direction.NORTH || direction == null ? value : this.renderingBoxCache.computeIfAbsent(direction, dir -> ShapeUtils.rotate((AABB)value, (Direction)dir));
    }

    @OnlyIn(value=Dist.CLIENT)
    @Nullable
    public MachineSound createMachineSound(BlockPos pos, BooleanSupplier predicate) {
        if (!this.machineSound.isEnable()) {
            if (this.parent != null) {
                return this.parent.createMachineSound(pos, predicate);
            }
            return null;
        }
        return this.machineSound.createMachineSound(pos, predicate);
    }

    public int getDepth() {
        if (this.parent == null) {
            return 0;
        }
        return this.parent.getDepth() + 1;
    }

    @Override
    public int compareTo(@NotNull MachineState o) {
        return Integer.compare(this.getDepth(), o.getDepth());
    }

    protected MachineState createFromTag(CompoundTag tag) {
        String name = tag.m_128461_("name");
        MachineState state = this.newBuilder().name(name).build();
        state.deserializeNBT(tag);
        return state;
    }

    protected Builder<? extends MachineState> newBuilder() {
        return MachineState.builder();
    }

    public static Builder<? extends MachineState> builder() {
        return new Builder();
    }

    public String name() {
        return this.name;
    }

    @NonNull
    public List<MachineState> children() {
        return this.children;
    }

    @Nullable
    public MachineState parent() {
        return this.parent;
    }

    public ToggleRenderer renderer() {
        return this.renderer;
    }

    public ToggleShape shape() {
        return this.shape;
    }

    public ToggleLightValue lightLevel() {
        return this.lightLevel;
    }

    public ToggleAABB renderingBox() {
        return this.renderingBox;
    }

    public boolean isGlobalVisible() {
        return this.isGlobalVisible;
    }

    public int renderingRadius() {
        return this.renderingRadius;
    }

    public ToggleMachineSound machineSound() {
        return this.machineSound;
    }

    @Nullable
    public StateMachine<?> stateMachine() {
        return this.stateMachine;
    }

    public Map<Direction, VoxelShape> shapeCache() {
        return this.shapeCache;
    }

    public Map<Direction, AABB> renderingBoxCache() {
        return this.renderingBoxCache;
    }

    public MachineState isGlobalVisible(boolean isGlobalVisible) {
        this.isGlobalVisible = isGlobalVisible;
        return this;
    }

    public MachineState renderingRadius(int renderingRadius) {
        this.renderingRadius = renderingRadius;
        return this;
    }

    public static class Builder<T extends MachineState> {
        protected String name;
        protected List<MachineState> children = new ArrayList<MachineState>();
        @Nullable
        protected IRenderer renderer;
        @Nullable
        protected VoxelShape shape;
        @Nullable
        protected Integer lightLevel;
        @Nullable
        protected AABB renderingBox;

        protected Builder() {
        }

        public Builder<T> child(MachineState child) {
            this.children.add(child);
            return this;
        }

        public Builder<T> modelRenderer(ResourceLocation modelPath) {
            return this.renderer((IRenderer)new IModelRenderer(modelPath));
        }

        @HideFromJS
        public Builder<T> geckolibRenderer(ResourceLocation modelPath, ResourceLocation texturePath, ResourceLocation animationPath) {
            if (MBD2.isGeckolibLoaded()) {
                return this.renderer((IRenderer)new GeckolibRenderer(modelPath, texturePath, animationPath));
            }
            return this;
        }

        public T build() {
            return (T)new MachineState(this.name, this.children, this.renderer, this.shape, this.lightLevel, this.renderingBox);
        }

        public Builder<T> name(String name) {
            this.name = name;
            return this;
        }

        public Builder<T> children(List<MachineState> children) {
            this.children = children;
            return this;
        }

        public Builder<T> renderer(@Nullable IRenderer renderer) {
            this.renderer = renderer;
            return this;
        }

        public Builder<T> shape(@Nullable VoxelShape shape) {
            this.shape = shape;
            return this;
        }

        public Builder<T> lightLevel(@Nullable Integer lightLevel) {
            this.lightLevel = lightLevel;
            return this;
        }

        public Builder<T> renderingBox(@Nullable AABB renderingBox) {
            this.renderingBox = renderingBox;
            return this;
        }
    }
}

