/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.recipe;

import com.lowdragmc.lowdraglib.gui.animation.Transform;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.Size;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.recipe.RecipeList;
import com.lowdragmc.mbd2.common.gui.editor.recipe.widget.RecipeXEIPreviewFloatView;
import java.util.concurrent.atomic.AtomicReference;

public class RecipeTypePanel
extends WidgetGroup {
    protected final MachineEditor editor;
    protected MBDRecipeType recipeType;
    protected WidgetGroup contentGroup;
    private final RecipeXEIPreviewFloatView floatView = new RecipeXEIPreviewFloatView();

    public RecipeTypePanel(MBDRecipeType recipeType, MachineEditor editor) {
        super(0, 16, editor.getSize().getWidth() - 252, editor.getSize().height - 16 - 16);
        this.recipeType = recipeType;
        this.editor = editor;
        this.contentGroup = new WidgetGroup(20, 20, this.getSizeWidth() - 40, this.getSizeHeight() - 20);
        if (this.getSizeWidth() - editor.getToolPanel().getSizeWidth() - 40 > 400) {
            this.contentGroup.setSizeWidth(this.getSizeWidth() - editor.getToolPanel().getSizeWidth() - 40);
            this.contentGroup.setSelfPositionX(editor.getToolPanel().getSizeWidth() + 20);
        }
        this.addWidget((Widget)this.contentGroup);
    }

    public void onPanelSelected() {
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getToolPanel().setTitle("editor.machine.recipe_type.recipes");
        this.contentGroup.clearAllWidgets();
        AtomicReference common = new AtomicReference();
        AtomicReference fuel = new AtomicReference();
        this.editor.getToolPanel().addNewToolBox("editor.machine.recipe_type.recipes.common", Icons.WIDGET_CUSTOM, size -> {
            common.set(new RecipeList(this, (Size)size, false));
            ((RecipeList)((Object)((Object)common.get()))).setOnSelected(() -> {
                if (fuel.get() != null) {
                    ((RecipeList)((Object)((Object)((Object)fuel.get())))).setSelected(null);
                }
            });
            return (WidgetGroup)common.get();
        });
        this.editor.getToolPanel().addNewToolBox("editor.machine.recipe_type.recipes.fuel", Icons.WIDGET_CUSTOM, size -> {
            fuel.set(new RecipeList(this, (Size)size, true));
            ((RecipeList)((Object)((Object)fuel.get()))).setOnSelected(() -> {
                if (common.get() != null) {
                    ((RecipeList)((Object)((Object)((Object)common.get())))).setSelected(null);
                }
            });
            return (WidgetGroup)fuel.get();
        });
        if (this.editor.getToolPanel().inAnimate()) {
            this.editor.getToolPanel().getAnimation().appendOnFinish(() -> this.editor.getToolPanel().show());
        } else {
            this.editor.getToolPanel().show();
        }
        this.editor.getFloatView().addWidgetAnima((Widget)this.floatView, new Transform().duration(200L).scale(0.2f));
        this.floatView.clearRecipe();
        this.editor.getConfigPanel().openConfigurator(MachineEditor.BASIC, (IConfigurable)this.recipeType);
    }

    public void onPanelDeselected() {
        this.editor.getToolPanel().setTitle("ldlib.gui.editor.group.tool_box");
        this.editor.getToolPanel().hide();
        this.editor.getToolPanel().clearAllWidgets();
        this.editor.getConfigPanel().clearAllConfigurators();
        this.editor.getFloatView().removeWidget((Widget)this.floatView);
    }

    public MachineEditor getEditor() {
        return this.editor;
    }

    public RecipeXEIPreviewFloatView getFloatView() {
        return this.floatView;
    }
}

