/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor.recipe;

import com.lowdragmc.lowdraglib.gui.editor.ColorPattern;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.texture.GuiTextureGroup;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.TextTexture;
import com.lowdragmc.lowdraglib.gui.util.TreeBuilder;
import com.lowdragmc.lowdraglib.gui.widget.DraggableScrollableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.SelectableWidgetGroup;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.api.recipe.RecipeCondition;
import com.lowdragmc.mbd2.api.registry.MBDRegistries;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import java.util.List;
import javax.annotation.Nullable;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class ConditionContainer
extends WidgetGroup {
    private final List<RecipeCondition> conditions;
    private final DraggableScrollableWidgetGroup container;
    @Nullable
    private RecipeCondition selected;

    public ConditionContainer(int x, int y, int width, int height, List<RecipeCondition> conditions) {
        super(x, y, width, height);
        this.conditions = conditions;
        this.container = new DraggableScrollableWidgetGroup(0, 0, width, height);
        this.container.setYScrollBarWidth(4).setYBarStyle(null, (IGuiTexture)ColorPattern.T_WHITE.rectTexture().setRadius(2.0f).transform(-0.5f, 0.0f));
        this.container.setBackground((IGuiTexture)ColorPattern.T_WHITE.borderTexture(1));
        this.addWidget((Widget)this.container);
        this.reloadConditions();
    }

    private void reloadConditions() {
        this.container.clearAllWidgets();
        for (RecipeCondition condition : this.conditions) {
            SelectableWidgetGroup conditionLine = this.createConditionLine(condition);
            conditionLine.setSelfPosition(0, this.container.getAllWidgetSize() * 20);
            conditionLine.setSelectedTexture((IGuiTexture)new GuiTextureGroup(new IGuiTexture[]{ColorPattern.T_GRAY.rectTexture()}));
            conditionLine.setOnSelected(group -> {
                this.selected = condition;
                if (Editor.INSTANCE != null) {
                    Editor.INSTANCE.getConfigPanel().openConfigurator(MachineEditor.SECOND, (IConfigurable)condition);
                }
            });
            conditionLine.setOnUnSelected(group -> {
                this.selected = null;
                if (Editor.INSTANCE != null) {
                    Editor.INSTANCE.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
                }
            });
            this.container.addWidget((Widget)conditionLine);
        }
    }

    private SelectableWidgetGroup createConditionLine(RecipeCondition condition) {
        int width = this.container.getSizeWidth() - 5;
        SelectableWidgetGroup conditionLine = new SelectableWidgetGroup(0, 0, width, 20);
        conditionLine.addWidget((Widget)new ImageWidget(1, 1, 18, 18, condition.getIcon()));
        conditionLine.addWidget((Widget)new ImageWidget(25, 1, width - 25, 18, (IGuiTexture)new TextTexture().setWidth(width - 20).setType(TextTexture.TextType.LEFT_HIDE).setSupplier(() -> condition.getTooltips().getString())));
        return conditionLine;
    }

    @OnlyIn(value=Dist.CLIENT)
    public boolean mouseClicked(double mouseX, double mouseY, int button) {
        if (this.container.isMouseOverElement(mouseX, mouseY) && button == 1 && Editor.INSTANCE != null) {
            TreeBuilder.Menu menu = TreeBuilder.Menu.start().branch((IGuiTexture)Icons.ADD_FILE, "editor.machine.recipe_type.add_condition", m -> {
                for (Class clazz : MBDRegistries.RECIPE_CONDITIONS.values()) {
                    RecipeCondition condition = RecipeCondition.create(clazz);
                    if (condition == null) continue;
                    m.leaf(condition.getIcon(), condition.getTranslationKey(), () -> {
                        this.conditions.add(condition);
                        this.reloadConditions();
                    });
                }
            });
            if (this.selected != null) {
                menu.crossLine();
                menu.leaf((IGuiTexture)Icons.COPY, "ldlib.gui.editor.menu.copy", () -> {
                    RecipeCondition copied = this.selected.copy();
                    this.conditions.add(copied);
                    this.reloadConditions();
                });
                menu.leaf((IGuiTexture)Icons.REMOVE_FILE, "editor.machine.recipe_type.remove_condition", () -> {
                    this.conditions.remove(this.selected);
                    this.selected = null;
                    Editor.INSTANCE.getConfigPanel().clearAllConfigurators(MachineEditor.SECOND);
                    this.reloadConditions();
                });
            }
            Editor.INSTANCE.openMenu(mouseX, mouseY, menu);
            return true;
        }
        return super.mouseClicked(mouseX, mouseY, button);
    }

    @Nullable
    public RecipeCondition getSelected() {
        return this.selected;
    }
}

