/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurableWidget;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.Resources;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.ColorsResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.EntriesResource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.TexturesResource;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceBorderTexture;
import com.lowdragmc.lowdraglib.gui.texture.UIResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.recipe.MBDRecipeType;
import com.lowdragmc.mbd2.common.gui.editor.MachineEditor;
import com.lowdragmc.mbd2.common.gui.editor.recipe.RecipeTypePanel;
import com.lowdragmc.mbd2.common.gui.editor.recipe.RecipeXEIUIPanel;
import java.io.File;
import java.io.IOException;
import java.util.LinkedHashMap;
import java.util.Map;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.NbtIo;
import net.minecraft.nbt.Tag;
import net.minecraft.world.item.crafting.RecipeType;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="rt", group="editor.machine")
public class RecipeTypeProject
implements IProject {
    protected Resources resources;
    protected MBDRecipeType recipeType;
    protected WidgetGroup ui;
    protected WidgetGroup fuelUI;

    public RecipeTypeProject(Resources resources, MBDRecipeType recipeType, WidgetGroup ui, WidgetGroup fuelUI) {
        this.resources = resources;
        this.recipeType = recipeType;
        this.ui = ui;
        this.fuelUI = fuelUI;
    }

    protected Map<String, Resource<?>> createResources() {
        LinkedHashMap resources = new LinkedHashMap();
        EntriesResource entries = new EntriesResource();
        entries.buildDefault();
        resources.put("ldlib.gui.editor.group.entries", (Resource<?>)entries);
        TexturesResource texture = new TexturesResource();
        resources.put("ldlib.gui.editor.group.textures", (Resource<?>)texture);
        ColorsResource color = new ColorsResource();
        color.buildDefault();
        resources.put("ldlib.gui.editor.group.colors", (Resource<?>)color);
        return resources;
    }

    protected WidgetGroup createDefaultUI() {
        WidgetGroup group = new WidgetGroup(200, 50, 176, 100);
        group.setBackground(new IGuiTexture[]{ResourceBorderTexture.BORDERED_BACKGROUND});
        return group;
    }

    protected MBDRecipeType createDefaultRecipeType() {
        return new MBDRecipeType(MBD2.id("recipe_type"), new RecipeType[0]);
    }

    public RecipeTypeProject newEmptyProject() {
        return new RecipeTypeProject(new Resources(this.createResources()), this.createDefaultRecipeType(), this.createDefaultUI(), this.createDefaultUI());
    }

    public CompoundTag serializeNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128365_("resources", (Tag)this.resources.serializeNBT());
        tag.m_128365_("ui", (Tag)IConfigurableWidget.serializeNBT((IConfigurableWidget)this.ui, (Resources)this.resources, (boolean)true));
        tag.m_128365_("fuelUI", (Tag)IConfigurableWidget.serializeNBT((IConfigurableWidget)this.fuelUI, (Resources)this.resources, (boolean)true));
        tag.m_128365_("recipe_type", (Tag)this.recipeType.serializeNBT());
        return tag;
    }

    public Resources loadResources(CompoundTag tag) {
        Resources resources = new Resources(this.createResources());
        resources.deserializeNBT(tag);
        return resources;
    }

    public void deserializeNBT(CompoundTag tag) {
        this.resources = this.loadResources(tag.m_128469_("resources"));
        this.ui = new WidgetGroup();
        IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.ui, (CompoundTag)tag.m_128469_("ui"), (Resources)this.resources, (boolean)true);
        if (tag.m_128441_("fuelUI")) {
            this.fuelUI = new WidgetGroup();
            IConfigurableWidget.deserializeNBT((IConfigurableWidget)this.fuelUI, (CompoundTag)tag.m_128469_("fuelUI"), (Resources)this.resources, (boolean)true);
            if (this.fuelUI.getBackgroundTexture() == null) {
                this.fuelUI.setBackground(new IGuiTexture[]{ResourceBorderTexture.BORDERED_BACKGROUND});
            }
        } else {
            this.fuelUI = this.createDefaultUI();
        }
        this.recipeType = this.createDefaultRecipeType();
        UIResourceTexture.setCurrentResource((Resource)((Resource)this.resources.resources.get("ldlib.gui.editor.group.textures")), (boolean)true);
        this.recipeType.deserializeNBT(tag.m_128469_("recipe_type"));
        UIResourceTexture.clearCurrentResource();
    }

    public File getProjectWorkSpace(Editor editor) {
        return new File(editor.getWorkSpace(), "recipe_type");
    }

    public void saveProject(File file) {
        try {
            NbtIo.m_128955_((CompoundTag)this.serializeNBT(), (File)file);
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    @Nullable
    public IProject loadProject(File file) {
        try {
            CompoundTag tag = NbtIo.m_128953_((File)file);
            if (tag != null) {
                RecipeTypeProject proj = new RecipeTypeProject();
                proj.deserializeNBT(tag);
                return proj;
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
        return null;
    }

    public void onLoad(Editor editor) {
        if (editor instanceof MachineEditor) {
            MachineEditor machineEditor = (MachineEditor)editor;
            super.onLoad(editor);
            StringTabContainer tabContainer = machineEditor.getTabPages();
            RecipeTypePanel recipeTypePanel = new RecipeTypePanel(this.recipeType, machineEditor);
            RecipeXEIUIPanel recipeXEIUIPanel = new RecipeXEIUIPanel(machineEditor, this.getUi(), false);
            RecipeXEIUIPanel fuelRecipeXEIUIPanel = new RecipeXEIUIPanel(machineEditor, this.getFuelUI(), true);
            tabContainer.addTab("editor.machine.recipe_type", (WidgetGroup)recipeTypePanel, recipeTypePanel::onPanelSelected, recipeTypePanel::onPanelDeselected);
            tabContainer.addTab("editor.machine.recipe_xei_ui", (WidgetGroup)recipeXEIUIPanel, recipeXEIUIPanel::onPanelSelected, recipeXEIUIPanel::onPanelDeselected);
            tabContainer.addTab("editor.machine.recipe_xei_fuel_ui", (WidgetGroup)fuelRecipeXEIUIPanel, fuelRecipeXEIUIPanel::onPanelSelected, fuelRecipeXEIUIPanel::onPanelDeselected);
        }
    }

    public Resources getResources() {
        return this.resources;
    }

    public MBDRecipeType getRecipeType() {
        return this.recipeType;
    }

    public WidgetGroup getUi() {
        return this.ui;
    }

    public WidgetGroup getFuelUI() {
        return this.fuelUI;
    }

    public RecipeTypeProject() {
    }
}

