/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.runtime.AnnotationDetector;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.widget.DialogWidget;
import com.lowdragmc.lowdraglib.gui.widget.ImageWidget;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.mbd2.common.gui.editor.MultiblockMachineProject;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.BlockPlaceholder;
import com.lowdragmc.mbd2.common.gui.editor.multiblock.MultiblockPatternPanel;
import com.lowdragmc.mbd2.integration.ldlib.MBDLDLibPlugin;
import com.mojang.datafixers.util.Either;
import java.io.File;
import java.util.Map;

public class PredicateResourceContainer
extends ResourceContainer<SimplePredicate, Widget> {
    public PredicateResourceContainer(Resource<SimplePredicate> resource, ResourcePanel panel) {
        super(resource, panel);
        this.setWidgetSupplier(k -> this.createPreview((SimplePredicate)this.getResource().getResource(k)));
        this.setDragging(key -> key, (k, o, p) -> ((SimplePredicate)this.getResource().getResource(k)).getPreviewTexture());
        this.setOnEdit(key -> {
            SimplePredicate predicate = (SimplePredicate)this.getResource().getResource(key);
            if (predicate == SimplePredicate.ANY || predicate == SimplePredicate.AIR) {
                return;
            }
            this.getPanel().getEditor().getConfigPanel().openConfigurator(ConfigPanel.Tab.RESOURCE, (IConfigurable)predicate);
        });
        this.setCanGlobalChange(key -> (Boolean)key.map(left -> !left.equals("any") && !left.equals("air"), right -> true));
        this.setCanRemove(key -> (Boolean)key.map(left -> !left.equals("any") && !left.equals("air"), right -> true));
        this.setOnGlobalChange(key -> {
            IProject patt1902$temp = Editor.INSTANCE.getCurrentProject();
            if (patt1902$temp instanceof MultiblockMachineProject) {
                MultiblockMachineProject project = (MultiblockMachineProject)patt1902$temp;
                Either newKey = (Either)key.map(l -> Either.right((Object)resource.getStaticResourceFile(l)), r -> Either.left((Object)resource.getStaticResourceName(r)));
                boolean changed = false;
                BlockPlaceholder[][][] blockPlaceholderArray = project.getBlockPlaceholders();
                int n = blockPlaceholderArray.length;
                for (int i = 0; i < n; ++i) {
                    BlockPlaceholder[][] x;
                    BlockPlaceholder[][] blockPlaceholderArray2 = x = blockPlaceholderArray[i];
                    int n2 = blockPlaceholderArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        BlockPlaceholder[] y;
                        for (BlockPlaceholder z : y = blockPlaceholderArray2[j]) {
                            if (!z.getPredicates().remove(key)) continue;
                            z.getPredicates().add((Either<String, File>)newKey);
                            changed = true;
                        }
                    }
                }
                if (changed) {
                    Editor.INSTANCE.getTabPages().tabs.values().stream().filter(MultiblockPatternPanel.class::isInstance).map(MultiblockPatternPanel.class::cast).findAny().ifPresent(MultiblockPatternPanel::onBlockPlaceholdersChanged);
                }
            }
        });
        this.setOnRemove(key -> {
            IProject patt3090$temp = Editor.INSTANCE.getCurrentProject();
            if (patt3090$temp instanceof MultiblockMachineProject) {
                MultiblockMachineProject project = (MultiblockMachineProject)patt3090$temp;
                boolean changed = false;
                BlockPlaceholder[][][] blockPlaceholderArray = project.getBlockPlaceholders();
                int n = blockPlaceholderArray.length;
                for (int i = 0; i < n; ++i) {
                    BlockPlaceholder[][] x;
                    BlockPlaceholder[][] blockPlaceholderArray2 = x = blockPlaceholderArray[i];
                    int n2 = blockPlaceholderArray2.length;
                    for (int j = 0; j < n2; ++j) {
                        BlockPlaceholder[] y;
                        for (BlockPlaceholder z : y = blockPlaceholderArray2[j]) {
                            changed |= z.getPredicates().remove(key);
                        }
                    }
                }
                if (changed) {
                    Editor.INSTANCE.getTabPages().tabs.values().stream().filter(MultiblockPatternPanel.class::isInstance).map(MultiblockPatternPanel.class::cast).findAny().ifPresent(MultiblockPatternPanel::onBlockPlaceholdersChanged);
                }
            }
        });
        this.setOnMenu((selected, m) -> m.branch((IGuiTexture)Icons.ADD_FILE, "config.predicate.add_predicate", menu -> {
            for (Map.Entry<String, AnnotationDetector.Wrapper<LDLRegister, ? extends SimplePredicate>> entry : MBDLDLibPlugin.REGISTER_PREDICATES.entrySet()) {
                menu.leaf("config.predicate.%s".formatted(entry.getKey()), () -> {
                    SimplePredicate predicate = ((SimplePredicate)((AnnotationDetector.Wrapper)entry.getValue()).creator().get()).buildPredicate();
                    predicate.buildPredicate();
                    resource.addBuiltinResource(this.genNewFileName(), (Object)predicate);
                    this.reBuild();
                });
            }
        }));
    }

    protected ImageWidget createPreview(SimplePredicate predicate) {
        return new ImageWidget(0, 0, 33, 33, predicate::getPreviewTexture);
    }

    protected void renameResource() {
        if (this.selected != null) {
            DialogWidget.showStringEditorDialog((WidgetGroup)Editor.INSTANCE, (String)(LocalizationUtils.format((String)"ldlib.gui.editor.tips.rename", (Object[])new Object[0]) + " " + LocalizationUtils.format((String)this.resource.name(), (Object[])new Object[0])), (String)this.resource.getResourceName(this.selected), s -> {
                if (!((Boolean)this.selected.map(l -> this.resource.hasBuiltinResource(s), r -> this.resource.hasStaticResource(this.resource.getStaticResourceFile(s)))).booleanValue()) {
                    return false;
                }
                if (this.renamePredicate != null) {
                    return this.renamePredicate.test(s);
                }
                return true;
            }, s -> {
                IProject patt5639$temp;
                if (s == null) {
                    return;
                }
                SimplePredicate stored = (SimplePredicate)this.resource.removeResource(this.selected);
                if (stored != null) {
                    Either name = this.selected.mapBoth(l -> s, r -> this.resource.getStaticResourceFile(s));
                    this.resource.addResource(name, (Object)stored);
                }
                if ((patt5639$temp = Editor.INSTANCE.getCurrentProject()) instanceof MultiblockMachineProject) {
                    MultiblockMachineProject project = (MultiblockMachineProject)patt5639$temp;
                    boolean changed = false;
                    BlockPlaceholder[][][] blockPlaceholderArray = project.getBlockPlaceholders();
                    int n = blockPlaceholderArray.length;
                    for (int i = 0; i < n; ++i) {
                        BlockPlaceholder[][] x;
                        BlockPlaceholder[][] blockPlaceholderArray2 = x = blockPlaceholderArray[i];
                        int n2 = blockPlaceholderArray2.length;
                        for (int j = 0; j < n2; ++j) {
                            BlockPlaceholder[] y;
                            for (BlockPlaceholder z : y = blockPlaceholderArray2[j]) {
                                if (!z.getPredicates().remove(this.selected)) continue;
                                z.getPredicates().add((Either<String, File>)Either.left((Object)s));
                                changed = true;
                            }
                        }
                    }
                    if (changed) {
                        Editor.INSTANCE.getTabPages().tabs.values().stream().filter(MultiblockPatternPanel.class::isInstance).map(MultiblockPatternPanel.class::cast).findAny().ifPresent(MultiblockPatternPanel::onBlockPlaceholdersChanged);
                    }
                }
                this.reBuild();
            });
        }
    }
}

