/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor;

import com.lowdragmc.lowdraglib.LDLib;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.editor.data.resource.Resource;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.resource.ResourceContainer;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.mbd2.api.pattern.predicates.SimplePredicate;
import com.lowdragmc.mbd2.common.gui.editor.PredicateResourceContainer;
import java.io.File;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.Tag;
import org.jetbrains.annotations.Nullable;

@LDLRegister(name="mbd2.gui.editor.group.predicate", group="resource")
public class PredicateResource
extends Resource<SimplePredicate> {
    public static final String RESOURCE_NAME = "mbd2.gui.editor.group.predicate";

    public PredicateResource() {
        super(new File(LDLib.getLDLibDir(), "assets/resources/predicates"));
        this.addBuiltinResource("any", SimplePredicate.ANY);
        this.addBuiltinResource("air", SimplePredicate.AIR);
    }

    public String name() {
        return RESOURCE_NAME;
    }

    public ResourceContainer<SimplePredicate, ? extends Widget> createContainer(ResourcePanel resourcePanel) {
        return new PredicateResourceContainer(this, resourcePanel);
    }

    @Nullable
    public Tag serialize(SimplePredicate predicate) {
        return SimplePredicate.serializeWrapper(predicate);
    }

    public SimplePredicate deserialize(Tag tag) {
        if (tag instanceof CompoundTag) {
            CompoundTag compoundTag = (CompoundTag)tag;
            return SimplePredicate.deserializeWrapper(compoundTag);
        }
        return SimplePredicate.ANY;
    }

    public void deserializeNBT(CompoundTag nbt) {
        this.getBuiltinResources().clear();
        this.addBuiltinResource("any", SimplePredicate.ANY);
        this.addBuiltinResource("air", SimplePredicate.AIR);
        for (String key : nbt.m_128431_()) {
            this.addBuiltinResource(key, this.deserialize(nbt.m_128423_(key)));
        }
    }
}

