/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.gui.editor;

import com.lowdragmc.lowdraglib.gui.editor.ILDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.Icons;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegisterClient;
import com.lowdragmc.lowdraglib.gui.editor.data.IProject;
import com.lowdragmc.lowdraglib.gui.editor.ui.ConfigPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.Editor;
import com.lowdragmc.lowdraglib.gui.editor.ui.MenuPanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.ResourcePanel;
import com.lowdragmc.lowdraglib.gui.editor.ui.StringTabContainer;
import com.lowdragmc.lowdraglib.gui.editor.ui.ToolPanel;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.lowdraglib.gui.widget.Widget;
import com.lowdragmc.lowdraglib.gui.widget.WidgetGroup;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.common.gui.editor.MachineProject;
import com.lowdragmc.mbd2.common.gui.editor.RecipeTypeProject;
import java.util.List;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

@LDLRegisterClient(name="editor.machine", group="editor")
@OnlyIn(value=Dist.CLIENT)
public class MachineEditor
extends Editor
implements ILDLRegisterClient {
    public static final ConfigPanel.Tab BASIC = ConfigPanel.Tab.WIDGET;
    public static final ConfigPanel.Tab SECOND = ConfigPanel.Tab.createTab((ResourceTexture)Icons.FILE, (Component)Component.m_237115_((String)"editor.config_panel.other_configurator"));
    public static final ConfigPanel.Tab RESOURCE = ConfigPanel.Tab.RESOURCE;

    public MachineEditor() {
        super(MBD2.getLocation());
    }

    public void initEditorViews() {
        this.toolPanel = new ToolPanel((Editor)this);
        this.toolPanel.setSizeWidth(150);
        this.configPanel = new ConfigPanel((Editor)this, List.of(BASIC, SECOND, RESOURCE));
        this.tabPages = new StringTabContainer((Editor)this);
        this.resourcePanel = new ResourcePanel((Editor)this);
        this.menuPanel = new MenuPanel((Editor)this);
        this.floatView = new WidgetGroup(0, 0, this.getSize().width, this.getSize().height);
        this.addWidget((Widget)this.tabPages);
        this.addWidget((Widget)this.toolPanel);
        this.addWidget((Widget)this.configPanel);
        this.addWidget((Widget)this.resourcePanel);
        this.addWidget((Widget)this.menuPanel);
        this.addWidget((Widget)this.floatView);
    }

    public void loadProject(IProject project) {
        if (project != null && !(project instanceof MachineProject) && !(project instanceof RecipeTypeProject)) {
            throw new IllegalArgumentException("Invalid project type");
        }
        super.loadProject(project);
    }
}

