/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.common.graphprocessor.node;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.LDLRegister;
import com.lowdragmc.lowdraglib.gui.graphprocessor.annotation.InputPort;
import com.lowdragmc.lowdraglib.gui.graphprocessor.data.trigger.LinearTriggerNode;
import com.lowdragmc.mbd2.common.machine.MBDMachine;
import net.minecraft.core.Direction;

@LDLRegister(name="set machine signal", group="graph_processor.node.mbd2.machine")
public class SetSignalNode
extends LinearTriggerNode {
    @InputPort
    public MBDMachine machine;
    @InputPort
    public Direction side;
    @InputPort
    public int signal;
    @Configurable
    public Mode mode = Mode.SIGNAL;

    protected void process() {
        if (this.machine != null && (this.side != null || this.mode == Mode.ANALOG)) {
            switch (this.mode) {
                case ANALOG: {
                    this.machine.setAnalogOutputSignal(this.signal);
                    break;
                }
                case SIGNAL: {
                    this.machine.setOutputSignal(this.signal, this.side);
                    break;
                }
                case DIRECT_SIGNAL: {
                    this.machine.setOutputDirectSignal(this.signal, this.side);
                }
            }
        }
    }

    public static enum Mode {
        SIGNAL,
        DIRECT_SIGNAL,
        ANALOG;

    }
}

