/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.google.gson.JsonElement;
import com.google.gson.JsonPrimitive;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.lowdragmc.mbd2.api.recipe.content.IContentSerializer;
import net.minecraft.nbt.LongTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.FriendlyByteBuf;
import org.apache.commons.lang3.math.NumberUtils;

public class SerializerLong
implements IContentSerializer<Long> {
    public static SerializerLong INSTANCE = new SerializerLong();

    private SerializerLong() {
    }

    @Override
    public void toNetwork(FriendlyByteBuf buf, Long content) {
        buf.m_130103_(content.longValue());
    }

    @Override
    public Long fromNetwork(FriendlyByteBuf buf) {
        return buf.m_130258_();
    }

    @Override
    public Tag toNBT(Long content) {
        return LongTag.m_128882_((long)content);
    }

    @Override
    public Long fromNBT(Tag nbt) {
        if (nbt instanceof LongTag) {
            LongTag longTag = (LongTag)nbt;
            return longTag.m_7046_();
        }
        return 0L;
    }

    @Override
    public Long fromJson(JsonElement json) {
        return json.getAsLong();
    }

    @Override
    public JsonElement toJson(Long content) {
        return new JsonPrimitive((Number)content);
    }

    @Override
    public Long of(Object o) {
        if (o instanceof Long) {
            return (Long)o;
        }
        if (o instanceof Number) {
            return ((Number)o).longValue();
        }
        if (o instanceof CharSequence) {
            return NumberUtils.toLong((String)o.toString(), (long)1L);
        }
        return 0L;
    }

    @Override
    public Long copyWithModifier(Long content, ContentModifier modifier) {
        return modifier.apply(content).longValue();
    }

    @Override
    public Long copyInner(Long content) {
        return content;
    }

    @Override
    public Long deepCopyInner(Long content) {
        return content;
    }
}

