/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe.content;

import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.annotation.NumberRange;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.utils.LocalizationUtils;
import com.lowdragmc.mbd2.api.capability.recipe.RecipeCapability;
import com.lowdragmc.mbd2.api.recipe.content.ContentModifier;
import com.mojang.blaze3d.vertex.PoseStack;
import java.util.List;
import java.util.Objects;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.client.Minecraft;
import net.minecraft.client.gui.Font;
import net.minecraft.client.gui.GuiGraphics;
import net.minecraft.network.chat.Component;
import net.minecraftforge.api.distmarker.Dist;
import net.minecraftforge.api.distmarker.OnlyIn;

public class Content {
    public Object content;
    @Configurable(name="editor.machine.recipe_type.content.per_tick", tips={"editor.machine.recipe_type.content.per_tick.tooltip"})
    public boolean perTick;
    @Configurable(name="editor.machine.recipe_type.content.chance", tips={"editor.machine.recipe_type.content.chance.tooltip"})
    @NumberRange(range={0.0, 1.0})
    public float chance;
    @Configurable(name="editor.machine.recipe_type.content.tier_chance_boost", tips={"editor.machine.recipe_type.content.tier_chance_boost.tooltip.0", "editor.machine.recipe_type.content.tier_chance_boost.tooltip.1"})
    @NumberRange(range={0.0, 1.0})
    public float tierChanceBoost;
    @Configurable(name="editor.machine.recipe_type.content.slot_name", tips={"editor.machine.recipe_type.content.slot_name.tooltip"})
    @Nonnull
    public String slotName;
    @Configurable(name="editor.machine.recipe_type.content.ui_name", tips={"editor.machine.recipe_type.content.ui_name.tooltip"})
    @Nonnull
    public String uiName;

    public Content(Object content, boolean perTick, float chance, float tierChanceBoost, @Nullable String slotName, @Nullable String uiName) {
        this.content = content;
        this.perTick = perTick;
        this.chance = chance;
        this.tierChanceBoost = tierChanceBoost;
        this.slotName = slotName == null ? "" : slotName;
        this.uiName = uiName == null ? "" : uiName;
    }

    public Content(Object content, boolean perTick, float chance, float tierChanceBoost) {
        this(content, perTick, chance, tierChanceBoost, "", "");
    }

    public Content copy(RecipeCapability<?> capability, @Nullable ContentModifier modifier) {
        if (modifier == null || this.chance == 0.0f) {
            return new Content(capability.copyContent(this.content), this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName);
        }
        return new Content(capability.copyContent(this.content, modifier), this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName);
    }

    public Content deepCopy(RecipeCapability<?> capability, @Nullable ContentModifier modifier) {
        if (modifier == null || this.chance == 0.0f) {
            return new Content(capability.deepCopyContent(this.content), this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName);
        }
        return new Content(capability.deepCopyContent(this.content, modifier), this.perTick, this.chance, this.tierChanceBoost, this.slotName, this.uiName);
    }

    public IGuiTexture createOverlay() {
        return new IGuiTexture(){

            @OnlyIn(value=Dist.CLIENT)
            public void draw(GuiGraphics graphics, int mouseX, int mouseY, float x, float y, int width, int height) {
                int row = 0;
                if (Content.this.chance < 1.0f) {
                    String s = Content.this.chance == 0.0f ? LocalizationUtils.format((String)"mbd2.gui.content.chance_0_short", (Object[])new Object[0]) : String.format("%.1f", Float.valueOf(Content.this.chance * 100.0f)) + "%";
                    int color = Content.this.chance == 0.0f ? 0xFF0000 : 0xFFFF00;
                    Content.this.drawSmallString(graphics, x, y, width, height, row++, s, color);
                }
                if (Content.this.perTick) {
                    Content.this.drawSmallString(graphics, x, y, width, height, row++, LocalizationUtils.format((String)"mbd2.gui.content.tips.per_tick_short", (Object[])new Object[0]), 0xFFFF00);
                }
            }
        };
    }

    @OnlyIn(value=Dist.CLIENT)
    public void drawSmallString(GuiGraphics graphics, float x, float y, int width, int height, int row, String text, int color) {
        Font font = Minecraft.m_91087_().f_91062_;
        int textWidth = font.m_92895_(text);
        float posX = x + (float)(width - textWidth);
        Objects.requireNonNull(font);
        float posY = y + (float)(row * 9) / 2.0f;
        graphics.m_280168_().m_85836_();
        PoseStack poseStack = graphics.m_280168_();
        float f = posX + (float)textWidth;
        Objects.requireNonNull(font);
        poseStack.m_252880_(f, posY + 9.0f / 2.0f, 0.0f);
        graphics.m_280168_().m_85841_(0.5f, 0.5f, 1.0f);
        PoseStack poseStack2 = graphics.m_280168_();
        float f2 = -posX - (float)textWidth;
        float f3 = -posY;
        Objects.requireNonNull(font);
        poseStack2.m_252880_(f2, f3 - 9.0f / 2.0f, 0.0f);
        graphics.m_280488_(font, text, (int)posX, (int)posY, color);
        graphics.m_280168_().m_85849_();
    }

    public void appendTooltip(List<Component> tooltips) {
        if (this.chance != 1.0f) {
            if (this.chance == 0.0f) {
                tooltips.add((Component)Component.m_237115_((String)"mbd2.gui.content.chance_0"));
            } else {
                tooltips.add((Component)Component.m_237110_((String)"mbd2.gui.content.chance_1", (Object[])new Object[]{(int)(this.chance * 100.0f) + "%"}));
            }
        }
        if (this.tierChanceBoost != 0.0f) {
            tooltips.add((Component)Component.m_237110_((String)"mbd2.gui.content.tier_boost", (Object[])new Object[]{(int)(this.tierChanceBoost * 100.0f) + "%"}));
        }
        if (this.perTick) {
            tooltips.add((Component)Component.m_237115_((String)"mbd2.gui.content.per_tick"));
        }
    }

    public Object getContent() {
        return this.content;
    }
}

