/*
 * Decompiled with CFR 0.152.
 */
package com.lowdragmc.mbd2.api.recipe;

import com.google.gson.JsonObject;
import com.lowdragmc.lowdraglib.gui.editor.annotation.Configurable;
import com.lowdragmc.lowdraglib.gui.editor.configurator.IConfigurable;
import com.lowdragmc.lowdraglib.gui.texture.IGuiTexture;
import com.lowdragmc.lowdraglib.gui.texture.ResourceTexture;
import com.lowdragmc.mbd2.MBD2;
import com.lowdragmc.mbd2.api.recipe.MBDRecipe;
import com.lowdragmc.mbd2.api.recipe.RecipeLogic;
import javax.annotation.Nonnull;
import javax.annotation.Nullable;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.network.FriendlyByteBuf;
import net.minecraft.network.chat.Component;
import net.minecraft.util.GsonHelper;

public abstract class RecipeCondition
implements IConfigurable {
    @Configurable(name="config.recipe.condition.reverse", tips={"config.recipe.condition.reverse.tooltip"})
    protected boolean isReverse;

    @Nullable
    public static RecipeCondition create(Class<? extends RecipeCondition> clazz) {
        if (clazz == null) {
            return null;
        }
        try {
            return clazz.newInstance();
        }
        catch (Exception ignored) {
            MBD2.LOGGER.error("condition {} has no NonArgsConstructor", clazz);
            return null;
        }
    }

    public abstract String getType();

    public String getTranslationKey() {
        return "recipe.condition." + this.getType();
    }

    public boolean isOr() {
        return true;
    }

    public abstract Component getTooltips();

    public abstract boolean test(@Nonnull MBDRecipe var1, @Nonnull RecipeLogic var2);

    public IGuiTexture getIcon() {
        return new ResourceTexture("mbd2:textures/gui/condition/" + this.getType() + ".png");
    }

    public RecipeCondition copy() {
        return RecipeCondition.create(this.getClass()).deserialize(this.serialize());
    }

    @Nonnull
    public JsonObject serialize() {
        JsonObject jsonObject = new JsonObject();
        if (this.isReverse) {
            jsonObject.addProperty("reverse", Boolean.valueOf(true));
        }
        return jsonObject;
    }

    public RecipeCondition deserialize(@Nonnull JsonObject config) {
        this.isReverse = GsonHelper.m_13855_((JsonObject)config, (String)"reverse", (boolean)false);
        return this;
    }

    public void toNetwork(FriendlyByteBuf buf) {
        buf.writeBoolean(this.isReverse);
    }

    public RecipeCondition fromNetwork(FriendlyByteBuf buf) {
        this.isReverse = buf.readBoolean();
        return this;
    }

    public CompoundTag toNBT() {
        CompoundTag tag = new CompoundTag();
        tag.m_128379_("reverse", this.isReverse);
        return tag;
    }

    public RecipeCondition fromNBT(CompoundTag tag) {
        this.isReverse = tag.m_128471_("reverse");
        return this;
    }

    public RecipeCondition setReverse(boolean isReverse) {
        this.isReverse = isReverse;
        return this;
    }

    public boolean isReverse() {
        return this.isReverse;
    }
}

